/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.checkconsumi;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.MultipuntoOption;
import biz.elabor.prebilling.common.utils.MissingCodicePerseoException;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.Cliente;
import biz.elabor.prebilling.gas.dao.misure.model.ConsumoDiretto;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.OffertaGas;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.checkconsumi.ConsumiGruppoService;
import biz.elabor.prebilling.gas.services.common.DownloadPerseoHelper;
import biz.elabor.prebilling.gas.services.common.WriteLetstdGasService;
import biz.elabor.prebilling.gas.services.pcs.ExportPcsStrategy;
import biz.elabor.prebilling.gas.services.pcs.PcsAzienda;
import biz.elabor.prebilling.gas.services.tariffe.AbstractCalcolaTariffeStrategy;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiGruppo;
import biz.elabor.prebilling.gas.services.tariffe.ConsumoRemi;
import biz.elabor.prebilling.gas.services.tariffe.GlobalErrorHandler;
import biz.elabor.prebilling.gas.services.tariffe.MappaPrezziGas;
import biz.elabor.prebilling.gas.services.tariffe.TariffaCalculator;
import biz.elabor.prebilling.gas.services.tariffe.TariffaDirettoCalculator;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.tools.StringUtils;

public class CheckConsumiDirettiGasStrategy
implements GasServiceStrategy {
    private final Date dataInizio;
    private final Date dataFine;
    private final List<String> pdrs;
    private final boolean tariffa;
    private final boolean lettura;
    private final boolean pcs;
    private final MisureGasDao misureDao;
    private final GiadaGasDao giadaDao;
    private final String direttiBaseUrl;
    private final DateFormat plainDateFormat;
    private final TalkManager talkManager;
    private final DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
    private final DateFormat mediumDateFormat = StrategyHelper.getMediumDateFormat();
    private final WriteLetstdGasService writer;
    private final PrebillingGasConfiguration configuration;
    private final SafeMap<String, OffertaGas> offerte;
    private final String target;

    public CheckConsumiDirettiGasStrategy(Date dataInizio, Date dataFine, List<String> pdrs, String target, boolean tariffa, boolean lettura, boolean pcs, MisureGasDao misureDao, GiadaGasDao giadaDao, PrebillingGasConfiguration configuration, TalkManager talkManager) {
        this.dataInizio = dataInizio;
        this.dataFine = dataFine;
        this.pdrs = pdrs;
        this.tariffa = tariffa;
        this.lettura = lettura;
        this.pcs = pcs;
        this.misureDao = misureDao;
        this.giadaDao = giadaDao;
        this.configuration = configuration;
        this.direttiBaseUrl = configuration.getDirettiBaseUrl();
        this.plainDateFormat = StrategyHelper.getPlainDateFormat();
        this.talkManager = talkManager;
        this.offerte = misureDao.getOfferte();
        this.writer = new WriteLetstdGasService(configuration);
        this.target = target;
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        boolean ok;
        try {
            if (!StringUtils.isEmpty(this.direttiBaseUrl)) {
                Date inizio;
                ElaborCalendar calendar = new ElaborCalendar(this.dataInizio);
                while (!(inizio = calendar.getDate()).after(this.dataFine)) {
                    int anno = calendar.getAnno();
                    Month mese = calendar.getMese();
                    calendar.addMesi(1);
                    Date fine = calendar.getDate();
                    ListMap<String, MultipuntoOption> multipuntoOptions = this.misureDao.getMultipuntoOptions(anno, mese);
                    List<Cliente> clientiDiretti = this.misureDao.getDiretti(inizio, fine, this.pdrs);
                    LinkedHashMap<String, PcsAzienda> pcsAziende = new LinkedHashMap<String, PcsAzienda>();
                    for (Cliente cliente : clientiDiretti) {
                        try {
                            this.checkDiretto(cliente, anno, mese, status, multipuntoOptions, pcsAziende);
                        }
                        catch (DataNotFoundException exc) {
                            String message = exc.getMessage();
                            Message sentence = new Message("consumi", message);
                            sentence.addParam(exc.getKey());
                            this.talkManager.addSentence(sentence);
                        }
                    }
                    ExportPcsStrategy exportPcsStrategy = new ExportPcsStrategy(anno, mese, this.target, this.configuration, Funzionalita.CHECK_CONSUMI);
                    status.setPcsAziende(pcsAziende);
                    exportPcsStrategy.execute(status);
                }
            }
            ok = true;
        }
        catch (InconsistentOptionException | MissingCodicePerseoException | IOException | RuntimeException exc) {
            ok = false;
            Message sentence = new Message("check.consumi", "dwnl.failed");
            sentence.addParam(exc.toString());
            this.talkManager.addSentence(sentence);
            String userMessage = this.talkManager.getMessage(sentence);
            Logger logger = status.getLogger();
            logger.log(Level.SEVERE, userMessage, exc);
        }
        return ok;
    }

    private void checkDiretto(Cliente cliente, int anno, Month mese, GasServiceStatus status, ListMap<String, MultipuntoOption> multipuntoOptions, Map<String, PcsAzienda> pcsAziende) throws IOException, InconsistentOptionException, MissingCodicePerseoException, DataNotFoundException {
        String codicePerseo = cliente.getCodicePerseo();
        if (StringUtils.isEmpty(codicePerseo)) {
            Message sentence = new Message("check.consumi", "perseo.error");
            sentence.addParam(cliente.getCodicePdr());
            sentence.addParam("");
            sentence.addParam("consumi");
            this.talkManager.addSentence(sentence);
        } else {
            Date inizio = CalendarTools.getDate(anno, mese, 1);
            Date fine = CalendarTools.getEndOfMonth(inizio);
            String startDateFmt = this.plainDateFormat.format(inizio);
            String endDateFmt = this.plainDateFormat.format(fine);
            URL url = new URL(String.valueOf(this.direttiBaseUrl) + "/" + codicePerseo + "?startDate=" + startDateFmt + "&endDate=" + endDateFmt + "&dates=true" + "&simulation=0" + "&scenario=0");
            Logger logger = status.getLogger();
            logger.info(url.toString());
            this.checkConsumi(cliente, anno, mese, status, multipuntoOptions, pcsAziende);
        }
    }

    private void checkConsumi(Cliente cliente, int anno, Month mese, GasServiceStatus status, ListMap<String, MultipuntoOption> multipuntoOptions, Map<String, PcsAzienda> pcsAziende) throws InconsistentOptionException, IOException, MissingCodicePerseoException, DataNotFoundException {
        String codiceRemi = cliente.getCodiceRemi();
        int segno = cliente.getSegno();
        Logger logger = status.getLogger();
        Date startDate = StrategyHelper.getStartDate(anno, mese, cliente);
        Date endDate = StrategyHelper.getEndDate(anno, mese, cliente);
        List<Double> consumiPerseo = DownloadPerseoHelper.downloadConsumi(cliente, startDate, endDate, this.direttiBaseUrl, logger);
        this.checkConsumi(cliente, anno, mese, consumiPerseo, codiceRemi, segno, status, multipuntoOptions, pcsAziende);
    }

    private void checkConsumi(Cliente cliente, int anno, Month mese, List<Double> consumiPerseo, String codiceRemi, int segno, GasServiceStatus status, ListMap<String, MultipuntoOption> multipuntoOptions, Map<String, PcsAzienda> pcsAziende) throws InconsistentOptionException, IOException, MissingCodicePerseoException {
        List<ConsumoDiretto> consumiDiretti = this.misureDao.getConsumiDiretti(codiceRemi, anno, mese);
        List<ConsumoRemi> consumiRemi = DownloadPerseoHelper.buildConsumiRemi(this.dataInizio, consumiPerseo);
        Date dataDisallineamento = CheckConsumiDirettiGasStrategy.checkConsumi(anno, mese, consumiRemi, consumiDiretti, segno);
        if (dataDisallineamento != null) {
            this.saveConsumi(cliente, consumiRemi, anno, mese);
            Message sentence = new Message("consumi", "consumi.changes");
            String codicePdr = cliente.getCodicePdr();
            sentence.addParam(codicePdr);
            sentence.addParam(this.mediumDateFormat.format(dataDisallineamento));
            this.talkManager.addSentence(sentence);
            HashSet<String> pdrSet = new HashSet<String>(Arrays.asList(codicePdr));
            ListMap<String, ContrattoGas> contratti = this.giadaDao.getContratti(this.dataInizio, "*", pdrSet, true);
            List contrattiPdr = (List)contratti.get(codicePdr);
            if (contrattiPdr == null) {
                sentence = new Message("consumi", "contratto.notfound");
                sentence.addParam(codicePdr);
                sentence.addParam(this.dateFormat.format(this.dataInizio));
                this.talkManager.addSentence(sentence);
            } else {
                if (this.tariffa || this.lettura) {
                    HashMap<Set<String>, ConsumiGruppo> pdrAggregationMap = new HashMap<Set<String>, ConsumiGruppo>();
                    HashMap<String, Map<Date, MisuraGas>> misureCalcolate = new HashMap<String, Map<Date, MisuraGas>>();
                    MappaPrezziGas mappaPrezziGas = new MappaPrezziGas(this.misureDao);
                    GlobalErrorHandler globalErrorHandler = new GlobalErrorHandler(null);
                    int nCifre = this.configuration.getCifreTariffe();
                    TariffaCalculator tariffaCalculator = new TariffaCalculator(anno, mese, this.offerte, status, nCifre, false, this.misureDao, this.giadaDao, this.configuration, multipuntoOptions, this.talkManager);
                    TariffaDirettoCalculator tariffaDirettoCalculator = new TariffaDirettoCalculator(anno, mese, this.lettura, this.tariffa, false, mappaPrezziGas, globalErrorHandler, tariffaCalculator, this.dateFormat, status, this.talkManager, this.writer);
                    ConsumiGruppoService service = new ConsumiGruppoService(anno, mese, contratti, pdrAggregationMap, misureCalcolate, false, false, AbstractCalcolaTariffeStrategy.STATI, this.talkManager, this.dateFormat, this.configuration, this.giadaDao, this.misureDao, status);
                    for (ContrattoGas contratto : contrattiPdr) {
                        ConsumiGruppo consumiGruppo = service.getConsumiGruppo(contratto);
                        tariffaDirettoCalculator.calcolaTariffa(contratto, consumiGruppo);
                    }
                }
                if (this.pcs) {
                    Logger logger = status.getLogger();
                    String azienda = ((ContrattoGas)contrattiPdr.get(0)).getReseller();
                    try {
                        List<Double> pcsValues = DownloadPerseoHelper.downloadPcs(cliente, anno, mese, this.direttiBaseUrl, logger);
                        DownloadPerseoHelper.addPcs(azienda, cliente, consumiPerseo, pcsValues, pcsAziende);
                    }
                    catch (DataNotFoundException exc) {
                        String message = exc.getMessage();
                        sentence = new Message("pcs", message);
                        sentence.addParam(exc.getKey());
                        this.talkManager.addSentence(sentence);
                    }
                }
            }
        }
    }

    private void saveConsumi(Cliente cliente, List<ConsumoRemi> consumiPerseo, int anno, Month mese) {
        Date dtFinCom;
        Date endDate;
        Date inizioMese = CalendarTools.getDate(anno, mese, 1);
        Date fineMese = CalendarTools.getEndDate(anno, mese);
        Date dtIniCom = cliente.getDtIniCom();
        Date startDate = CalendarTools.max(inizioMese, dtIniCom);
        if (DownloadPerseoHelper.checkDates(startDate, endDate = CalendarTools.min(fineMese, dtFinCom = cliente.getDtFinCom()), consumiPerseo)) {
            String codiceRemi = cliente.getCodiceRemi();
            String codicePdr = cliente.getCodicePdr();
            int segno = cliente.getSegno();
            for (ConsumoRemi consumoPerseo : consumiPerseo) {
                Date dataMisura = consumoPerseo.getDataMisura();
                double consumo = consumoPerseo.getConsumo() * (double)segno;
                this.misureDao.saveConsumo(dataMisura, consumo, codiceRemi, codicePdr);
            }
        } else {
            Message sentence = new Message("consumi", "consumi.incompleti");
            sentence.addParam(cliente.getCodicePdr());
            sentence.addParam(cliente.getCodiceRemi());
            sentence.addParam(this.plainDateFormat.format(startDate));
            sentence.addParam(this.plainDateFormat.format(endDate));
            this.talkManager.addSentence(sentence);
        }
    }

    private static Date checkConsumi(int anno, Month mese, List<ConsumoRemi> consumiPerseo, List<ConsumoDiretto> consumiDiretti, int segno) {
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        Iterator<ConsumoRemi> iterator = consumiPerseo.iterator();
        Iterator<ConsumoDiretto> iteratorDiretti = consumiDiretti.iterator();
        Date dataDisallineamento = null;
        while (dataDisallineamento == null && iterator.hasNext() && iteratorDiretti.hasNext()) {
            ConsumoRemi consumo = iterator.next();
            ConsumoDiretto consumoDiretto = iteratorDiretti.next();
            Date data = consumo.getDataMisura();
            double value = consumo.getConsumo() * (double)segno;
            Date dataDiretto = consumoDiretto.getDataMisura();
            double valueDiretto = consumoDiretto.getValore();
            if (!data.equals(dataDiretto) || value != valueDiretto) {
                dataDisallineamento = data;
            }
            calendar.addGiorni(1);
        }
        if (dataDisallineamento == null && mese == calendar.getMese()) {
            dataDisallineamento = calendar.getDate();
        }
        return dataDisallineamento;
    }
}

