/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.consumi;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.checkconsumi.ConsumiGruppoService;
import biz.elabor.prebilling.gas.services.tariffe.AbstractCalcolaTariffeStrategy;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiGruppo;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiMesePdr;
import biz.elabor.prebilling.gas.services.tariffe.model.Consumo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ExportConsumiGas
implements GasServiceStrategy {
    private static final String NAME = Funzionalita.EXPORT_CONSUMI_GAS.name();
    private final Date dataInizio;
    private final Date dataFine;
    private final Set<String> codiciPdr;
    private final String azienda;
    private final File outpuFolder;
    private final GiadaGasDao giadaDao;
    private final MisureGasDao misureDao;
    private final PrebillingGasConfiguration configuration;
    private final TalkManager talkManager;

    public ExportConsumiGas(Date dataInizio, Date dataFine, String[] codiciPdr, String azienda, File outpuFolder, GiadaGasDao giadaDao, MisureGasDao misureDao, PrebillingGasConfiguration configuration, TalkManager talkManager) {
        this.dataInizio = dataInizio;
        this.dataFine = dataFine;
        this.codiciPdr = new LinkedHashSet<String>(Arrays.asList(codiciPdr));
        this.azienda = azienda;
        this.outpuFolder = outpuFolder;
        this.giadaDao = giadaDao;
        this.misureDao = misureDao;
        this.configuration = configuration;
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        boolean ok;
        ElaborCalendar calendar = new ElaborCalendar(this.dataInizio);
        calendar.setGiorno(1);
        calendar.resetTime();
        BasicListMap<String, ConsumiMesePdr> consumiPdrMesi = new BasicListMap<String, ConsumiMesePdr>();
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        try {
            Date date;
            while (!(date = calendar.getDate()).after(this.dataFine)) {
                int anno = calendar.getAnno();
                Month mese = calendar.getMese();
                ListMap<String, ContrattoGas> mappaContratti = this.giadaDao.getContratti(date, this.azienda, this.codiciPdr, false);
                for (String codicePdr : this.codiciPdr) {
                    List contrattiPdr = (List)mappaContratti.get(codicePdr);
                    if (contrattiPdr == null || contrattiPdr.isEmpty()) {
                        Message sentence = new Message(NAME, "missing.contratto");
                        sentence.addParam(String.valueOf(codicePdr) + " / " + this.azienda);
                        sentence.addParam(dateFormat.format(CalendarTools.getDate(anno, mese, 1)));
                        this.talkManager.addSentence(sentence);
                        continue;
                    }
                    HashMap<Set<String>, ConsumiGruppo> pdrAggregationMap = new HashMap<Set<String>, ConsumiGruppo>();
                    HashMap<String, Map<Date, MisuraGas>> misureCalcolate = new HashMap<String, Map<Date, MisuraGas>>();
                    ConsumiGruppoService service = new ConsumiGruppoService(anno, mese, mappaContratti, pdrAggregationMap, misureCalcolate, false, false, AbstractCalcolaTariffeStrategy.STATI, this.talkManager, dateFormat, this.configuration, this.giadaDao, this.misureDao, status);
                    ContrattoGas contratto = (ContrattoGas)contrattiPdr.get(0);
                    ConsumiGruppo consumiGruppo = service.getConsumiGruppo(contratto);
                    if (!consumiGruppo.isOk()) continue;
                    ConsumiMesePdr consumiMesePdr = consumiGruppo.getConsumiPdr(codicePdr);
                    if (consumiMesePdr == null) {
                        Message sentence = new Message(NAME, "missing.consumi");
                        sentence.addParam(String.valueOf(codicePdr) + " / " + this.azienda);
                        sentence.addParam(dateFormat.format(CalendarTools.getDate(anno, mese, 1)));
                        this.talkManager.addSentence(sentence);
                        continue;
                    }
                    consumiPdrMesi.add(codicePdr, consumiMesePdr);
                }
                calendar.addMesi(1);
            }
            DateFormat timestampFormat = StrategyHelper.getTimestampFormat();
            String timestamp = timestampFormat.format(new Date());
            String id = this.codiciPdr.size() == 1 ? this.codiciPdr.iterator().next() : "multipdr";
            File file = new File(this.outpuFolder, "consumi_giornalieri_" + id + "_" + timestamp + ".csv");
            status.setFile(file);
            this.print(consumiPdrMesi, file);
            ok = true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            ok = false;
        }
        return ok;
    }

    private void print(ListMap<String, ConsumiMesePdr> consumiPdrMesi, File file) throws FileNotFoundException {
        DateFormat dateFormat = StrategyHelper.getMediumDateFormat();
        DecimalFormat decimalFormat = StrategyHelper.getConsumoFormat();
        Throwable throwable = null;
        Object var6_7 = null;
        try (PrintStream writer = new PrintStream(file);){
            writer.print("Data inizio;");
            writer.println(dateFormat.format(this.dataInizio));
            writer.print("Data fine;");
            writer.println(dateFormat.format(this.dataFine));
            writer.println();
            writer.println("data;pdr;consumo;tipo");
            for (Map.Entry entry : consumiPdrMesi.entrySet()) {
                List consumiMesi = (List)entry.getValue();
                String codicePdr = (String)entry.getKey();
                this.print(codicePdr, consumiMesi, decimalFormat, writer);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void print(String codicePdr, List<ConsumiMesePdr> consumiMesi, DecimalFormat decimalFormat, PrintStream writer) {
        for (ConsumiMesePdr consumiMesePdr : consumiMesi) {
            this.print(codicePdr, consumiMesePdr, decimalFormat, writer);
        }
    }

    private void print(String codicePdr, ConsumiMesePdr consumiMesePdr, DecimalFormat decimalFormat, PrintStream writer) {
        for (Consumo consumo : consumiMesePdr.getConsumi(this.dataInizio, this.dataFine)) {
            ExportConsumiGas.print(codicePdr, consumo, decimalFormat, writer);
        }
    }

    private static void print(String codicePdr, Consumo consumo, DecimalFormat decimalFormat, PrintStream writer) {
        writer.print(consumo.getDataMisura());
        writer.print(";");
        writer.print(codicePdr);
        writer.print(";");
        writer.print(decimalFormat.format(consumo.getValore()));
        writer.print(";");
        writer.print(consumo.getTipo());
        writer.println();
    }
}

