/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.IncoherentEndDates;
import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.TariffeCommonHelper;
import biz.elabor.prebilling.common.dao.MultipuntoEntry;
import biz.elabor.prebilling.common.dao.MultipuntoOption;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.ContrattiHelper;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.common.model.TipoFlat;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.Igmg;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.OffertaGas;
import biz.elabor.prebilling.gas.dao.misure.model.PrezzoGas;
import biz.elabor.prebilling.gas.dao.misure.model.TipoLettura;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.checkconsumi.ConsumiGruppoService;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import biz.elabor.prebilling.gas.services.common.IgmgResult;
import biz.elabor.prebilling.gas.services.common.MisuraGasResult;
import biz.elabor.prebilling.gas.services.common.WriteLetstdGasService;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiGruppo;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiMesePdr;
import biz.elabor.prebilling.gas.services.tariffe.GlobalErrorHandler;
import biz.elabor.prebilling.gas.services.tariffe.InvalidSequenceException;
import biz.elabor.prebilling.gas.services.tariffe.MappaPrezziGas;
import biz.elabor.prebilling.gas.services.tariffe.MissingMisuraException;
import biz.elabor.prebilling.gas.services.tariffe.MisuraGasException;
import biz.elabor.prebilling.gas.services.tariffe.TariffaCalculator;
import biz.elabor.prebilling.gas.services.tariffe.TariffaDirettoCalculator;
import biz.elabor.prebilling.gas.services.tariffe.TariffeContratto;
import biz.elabor.prebilling.gas.services.tariffe.TariffeGasHelper;
import biz.elabor.prebilling.gas.services.tariffe.model.Consumo;
import biz.elabor.prebilling.gas.services.tariffe.model.DettaglioGiorno;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.Sentence;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public abstract class AbstractCalcolaTariffeStrategy
implements GasServiceStrategy {
    public static final List<StatoMisure> STATI = Arrays.asList(StatoMisure.values());
    protected static final List<StatoMisure> STATI_DA_ELABORARE = Arrays.asList(StatoMisure.VALIDATO, StatoMisure.SOSPESO);
    protected final DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
    protected final DateFormat dateFormatMonthTear = StrategyCommonHelper.getMeseAnnoDateFormat();
    protected final DecimalFormat doubleFormat = StrategyCommonHelper.getDoubleFormat();
    protected static final String MESSAGE = ErroreElaborazioneGas.MISSING_SBIL.getMessage();
    protected static final int ERROR = ErroreElaborazioneGas.MISSING_SBIL.ordinal();
    private static final List<StatoMisure> DA_ELABORARE = Arrays.asList(StatoMisure.VALIDATO, StatoMisure.SOSPESO);
    protected final PrebillingGasConfiguration configuration;
    protected final TalkManager talkManager;
    protected final MappaPrezziGas mappaPrezziGas;
    protected final MisureGasDao misureDao;
    protected final GiadaGasDao giadaDao;
    protected final boolean scivoloEnabled;
    protected final String onlyPdr;
    protected final int annoRif;
    protected final Month meseRif;
    protected final ListMap<String, MultipuntoOption> multipuntoOptions;
    protected final boolean bloccoIndice;
    protected final boolean forceSopraSoglia;
    protected WriteLetstdGasService letstdGasWriter;
    protected Map<Set<String>, ConsumiGruppo> pdrAggregationMap;
    protected Map<String, Map<Date, MisuraGas>> misureCalcolate;
    private final boolean esportaLetture;
    private final boolean forceLetture;
    private final int nCifre;

    protected abstract List<StatoMisure> getStati();

    public AbstractCalcolaTariffeStrategy(int annoRif, Month meseRif, PrebillingGasConfiguration configuration, TalkManager talkManager, boolean forceSopraSoglia, boolean esportaLetture, boolean forceLetture, MisureGasDao misureDao, GiadaGasDao giadaDao, String onlyPdr, boolean scivoloEnabled, boolean bloccoIndice) {
        this.annoRif = annoRif;
        this.meseRif = meseRif;
        this.configuration = configuration;
        this.talkManager = talkManager;
        this.forceSopraSoglia = forceSopraSoglia;
        this.esportaLetture = esportaLetture;
        this.forceLetture = forceLetture;
        this.giadaDao = giadaDao;
        this.misureDao = misureDao;
        this.mappaPrezziGas = new MappaPrezziGas(misureDao);
        this.nCifre = configuration.getCifreTariffe();
        this.misureCalcolate = new HashMap<String, Map<Date, MisuraGas>>();
        this.scivoloEnabled = scivoloEnabled;
        this.bloccoIndice = bloccoIndice;
        this.onlyPdr = onlyPdr;
        this.multipuntoOptions = this.misureDao.getMultipuntoOptions(annoRif, meseRif);
    }

    public static Set<String> getPdrOnlySet(int anno, Month mese, String pdr, MisureGasDao misureDao) {
        Set<String> pdrSet;
        if (pdr.isEmpty()) {
            pdrSet = null;
        } else {
            Map<String, MultipuntoEntry> pdrMap = ConsumiGruppoService.getPdrMap(anno, mese, pdr, misureDao);
            pdrSet = pdrMap.keySet();
        }
        return pdrSet;
    }

    private boolean calcolaTariffaDiretto(int anno, Month mese, ContrattoGas contratto, ConsumiGruppo consumiGruppo, GlobalErrorHandler globalErrorHandler, TariffaCalculator tariffaCalculator, GasServiceStatus status, WriteLetstdGasService writer) throws InconsistentOptionException {
        TariffaDirettoCalculator calculator = new TariffaDirettoCalculator(anno, mese, this.esportaLetture, true, this.bloccoIndice, this.mappaPrezziGas, globalErrorHandler, tariffaCalculator, this.dateFormat, status, this.talkManager, writer);
        return calculator.calcolaTariffa(contratto, consumiGruppo);
    }

    protected void calcolaTariffeMese(int anno, Month mese, Set<String> activePdr, List<ContrattoGas> contrattiPdr, Date dataUltimaLettura, ListMap<String, ContrattoGas> contratti, SafeMap<String, OffertaGas> offerte, GasServiceStatus status) throws InconsistentOptionException {
        Date dataInizioMese = CalendarTools.getDate(anno, mese, 1);
        Date prevDate = null;
        boolean exportLettura = true;
        DataNotFoundException globalError = TariffeGasHelper.getGlobalError(anno, mese, contrattiPdr, status, this.misureDao);
        GlobalErrorHandler globalErrorHandler = new GlobalErrorHandler(globalError);
        for (ContrattoGas contratto : contrattiPdr) {
            Applicazione applicazione = status.getApplicazione(contratto);
            if (!TariffeGasHelper.checkStart(dataInizioMese, contratto) || applicazione.isSpread() || !TariffeCommonHelper.checkTrattamento(contratto, dataInizioMese, applicazione, TipoTrattamento.REGIME)) continue;
            Date dataInizioTariffa = ContrattiHelper.getInizioTariffa(contratto, anno, mese);
            exportLettura = !dataInizioTariffa.equals(prevDate) || exportLettura;
            prevDate = dataInizioTariffa;
            exportLettura &= !this.calcolaTariffeMeseContratto(anno, mese, contratto, dataUltimaLettura, exportLettura, activePdr, offerte, contratti, globalErrorHandler, status);
        }
    }

    private boolean calcolaTariffeMeseContratto(int anno, Month mese, ContrattoGas contratto, Date dataUltimaLettura, boolean exportLettura, Set<String> activePdr, SafeMap<String, OffertaGas> offerte, ListMap<String, ContrattoGas> contratti, GlobalErrorHandler globalErrorHandler, GasServiceStatus status) throws InconsistentOptionException {
        ConsumiMesePdr consumiMesePdr;
        boolean exported = false;
        List<StatoMisure> stati = this.getStati();
        ConsumiGruppoService service = new ConsumiGruppoService(anno, mese, contratti, this.pdrAggregationMap, this.misureCalcolate, this.scivoloEnabled, this.forceSopraSoglia, stati, this.talkManager, this.dateFormat, this.configuration, this.giadaDao, this.misureDao, status);
        ConsumiGruppo consumiGruppo = service.getConsumiGruppo(contratto);
        String codicePdr = contratto.getCodice();
        if (!consumiGruppo.isEmpty() && (consumiMesePdr = consumiGruppo.getConsumiPdr(codicePdr)) != null) {
            Date dataInizioTariffa = ContrattiHelper.getInizioTariffa(contratto, anno, mese);
            Set<String> pdrSet = consumiGruppo.getPdrSet();
            if (AbstractCalcolaTariffeStrategy.isActive(activePdr, pdrSet) || !this.isTariffaElaborata(pdrSet, dataInizioTariffa)) {
                TariffaCalculator tariffaCalculator = new TariffaCalculator(anno, mese, offerte, status, this.nCifre, this.bloccoIndice, this.misureDao, this.giadaDao, this.configuration, this.multipuntoOptions, this.talkManager);
                if (contratto.isDiretto()) {
                    WriteLetstdGasService writer = exportLettura ? this.letstdGasWriter : null;
                    exported = this.calcolaTariffaDiretto(anno, mese, contratto, consumiGruppo, globalErrorHandler, tariffaCalculator, status, writer);
                } else {
                    SafeListMap<String, PrezzoGas> prezziGas = this.mappaPrezziGas.getPrezziGasMese(anno, mese);
                    MisuraGas misura = this.calcolaTariffaIndiretto(contratto, globalErrorHandler, anno, mese, dataUltimaLettura, consumiGruppo, exportLettura, prezziGas, offerte, status);
                    exported = misura != null;
                }
            }
        }
        return exported;
    }

    private static boolean isActive(Set<String> activePdr, Set<String> pdrSet) {
        boolean active = false;
        for (String codicePdr : pdrSet) {
            if (!activePdr.contains(codicePdr)) continue;
            active = true;
            break;
        }
        return active;
    }

    private boolean isTariffaElaborata(Set<String> pdrSet, Date dataInizioTariffa) {
        boolean elaborata = true;
        for (String codicePdr : pdrSet) {
            elaborata &= this.misureDao.isTariffaElaborata(codicePdr, dataInizioTariffa);
        }
        return elaborata;
    }

    protected MisuraGas calcolaTariffaIndiretto(ContrattoGas contratto, GlobalErrorHandler globalErrorHandler, int anno, Month mese, Date dataUltimaLettura, ConsumiGruppo consumiGruppo, boolean exportLettura, SafeListMap<String, PrezzoGas> prezziGas, SafeMap<String, OffertaGas> offerte, GasServiceStatus status) throws InconsistentOptionException {
        MisuraGas misura;
        block22: {
            String azienda = contratto.getReseller();
            String codicePdr = contratto.getCodice();
            Date dataInizioTariffa = ContrattiHelper.getInizioTariffa(contratto, anno, mese);
            Date dataFineTariffa = ContrattiHelper.getFineTariffa(anno, mese, contratto);
            MisuraGas misuraPrecedente = ConsumiGruppoService.getMisuraPrecedente(codicePdr, dataInizioTariffa, this.misureCalcolate);
            misura = null;
            ConsumiMesePdr consumiMesePdr = consumiGruppo.getConsumiPdr(codicePdr);
            try {
                if (consumiMesePdr == null || misuraPrecedente == null && consumiGruppo.isTrattate() && !this.onlyPdr.equals(codicePdr)) break block22;
                if (!globalErrorHandler.isActive()) {
                    try {
                        TariffeContratto tariffeContratto;
                        List<Consumo> consumiComplessivi = consumiGruppo.getConsumiComplessivi(codicePdr, dataInizioTariffa, dataFineTariffa);
                        List<DettaglioGiorno> dettagli = TariffeGasHelper.buildDettagli(consumiComplessivi);
                        List<Consumo> consumi = consumiMesePdr.getConsumi(dataInizioTariffa, dataFineTariffa);
                        double consumoTotalePdr = AbstractCalcolaTariffeStrategy.getTotale(consumi);
                        Applicazione applicazione = status.getApplicazione(contratto);
                        TipoFlat tipoFlat = applicazione.getTipoFlat();
                        boolean multipunto = consumiGruppo.isMultipunto(codicePdr, dataInizioTariffa, dataFineTariffa);
                        if (consumiMesePdr.isScivolo() && multipunto && !tipoFlat.isFixingSwap()) {
                            double valore = contratto.getEmtaruni();
                            tariffeContratto = TariffeGasHelper.calcolaTariffaDefault(contratto, anno, mese, valore, status);
                        } else {
                            TariffaCalculator tariffaCalculator = new TariffaCalculator(anno, mese, offerte, status, this.nCifre, this.bloccoIndice, this.misureDao, this.giadaDao, this.configuration, this.multipuntoOptions, this.talkManager);
                            tariffeContratto = tariffaCalculator.calcolaTariffe(contratto, multipunto, dataFineTariffa, consumoTotalePdr, dettagli, prezziGas, consumiGruppo);
                        }
                        List<MisuraGas> misure = consumiMesePdr.getMisure();
                        Date dataUltimaLetturaReale = TariffeGasHelper.getDataUltimaLetturaReale(misure);
                        if (!multipunto && (dataUltimaLetturaReale == null || dataUltimaLetturaReale.before(dataFineTariffa))) {
                            Date dataInizioMese = CalendarTools.getDate(anno, mese, 1);
                            if (this.scivoloEnabled && exportLettura) {
                                Consumo lastConsumo = consumi.get(consumi.size() - 1);
                                misura = TariffeGasHelper.handleLetStd(contratto, dataInizioMese, dataFineTariffa, consumiMesePdr, lastConsumo, TipoLettura.STIMA, "letG", status, this.letstdGasWriter, exportLettura, dataUltimaLettura);
                            }
                            Date dataMancante = dataUltimaLetturaReale == null ? dataInizioMese : CalendarTools.nextDay(dataUltimaLetturaReale);
                            TariffeGasHelper.removeStimate(misure);
                            throw new MissingMisuraException(ErroreElaborazioneGas.MISSING_CONSUMI, azienda, codicePdr, dataMancante);
                        }
                        if (contratto.getTipoApplicazione() != 0) {
                            if (consumiMesePdr.isScivolo() && !multipunto) {
                                tariffeContratto = TariffeGasHelper.calcolaTariffaScivolo(contratto, anno, mese, offerte, status);
                            }
                            TariffeGasHelper.addTariffe(status, azienda, tariffeContratto);
                        }
                        if (!(!exportLettura || consumi.isEmpty() || multipunto && misuraPrecedente == null && consumiMesePdr.isTrattate() && !this.forceLetture)) {
                            Date dataInizioMese = CalendarTools.getDate(anno, mese, 1);
                            Consumo lastConsumo = consumi.get(consumi.size() - 1);
                            misura = TariffeGasHelper.handleLetStd(contratto, dataInizioMese, dataFineTariffa, consumiMesePdr, lastConsumo, TipoLettura.EFFETTIVA, null, status, this.letstdGasWriter, this.esportaLetture, dataUltimaLettura);
                        }
                        List<IgmgResult> igmgResults = consumiMesePdr.getIgmgResults();
                        status.addIgmgResults(igmgResults);
                        status.addMisureResult(misure, dataFineTariffa, StatoMisure.ELABORATO, ErroreElaborazioneGas.OK, "");
                        List<MisuraGasResult> results = consumiMesePdr.getResults();
                        status.addMisureResults(results);
                    }
                    catch (MissingMisuraException exc) {
                        Date startDate = ContrattiHelper.getInizioTariffa(contratto, anno, mese);
                        Applicazione applicazione = status.getApplicazione(contratto);
                        TipoFlat tipoFlat = applicazione.getTipoFlat();
                        if (this.scivoloEnabled) {
                            TariffeContratto tariffa;
                            if (tipoFlat.isFixing() || contratto.isFixing()) {
                                tariffa = TariffeGasHelper.calcolaTariffaScivoloFixing(contratto, anno, mese, status);
                                TariffeGasHelper.addTariffe(status, azienda, tariffa);
                            } else if (contratto.getTipoApplicazione() != 0 && (!this.misureDao.isTariffaElaborata(codicePdr, startDate) || this.onlyPdr.equals(codicePdr))) {
                                tariffa = TariffeGasHelper.calcolaTariffaScivolo(contratto, anno, mese, offerte, status);
                                TariffeGasHelper.addTariffe(status, azienda, tariffa);
                            }
                        }
                        List<MisuraGas> misure = consumiMesePdr.getMisure();
                        PrebillingError errore = exc.getErrore();
                        String descrizione = TariffeGasHelper.handleException(this.dateFormat, exc, this.talkManager);
                        status.addMisureResult(misure, dataFineTariffa, StatoMisure.SOSPESO, errore, descrizione);
                        List<Igmg> igmgUtente = consumiMesePdr.getIgmg();
                        status.addIgmgResult(igmgUtente, StatoMisure.SOSPESO, errore, descrizione);
                    }
                    List<MisuraGas> misure = consumiMesePdr.getMisure();
                    if (exportLettura) {
                        Collections.reverse(misure);
                        for (MisuraGas actual : misure) {
                            Date dataMisura = actual.getDataMisura();
                            Date dataFineMese = CalendarTools.getEndDate(anno, mese);
                            if (!actual.getTipoLettura().isEffettiva()) continue;
                            StatoMisure statoMisura = actual.getStatoMisura();
                            if (!dataMisura.before(dataFineMese) || !DA_ELABORARE.contains((Object)statoMisura) || !this.scivoloEnabled) break;
                            Date dataInizioMese = CalendarTools.getDate(anno, mese, 1);
                            boolean convertitore = actual.hasConvertitore();
                            double segnanteMis = actual.getSegnanteMisuratore();
                            double segnanteConv = actual.getSegnanteConvertitore();
                            misura = TariffeGasHelper.handleLetStd(contratto, dataInizioMese, dataMisura, consumiMesePdr, convertitore, segnanteMis, segnanteConv, TipoLettura.EFFETTIVA, "0000", status, this.letstdGasWriter, this.esportaLetture, dataUltimaLettura);
                            break;
                        }
                        Collections.reverse(misure);
                    }
                    break block22;
                }
                globalErrorHandler.handleGlobalError(codicePdr);
            }
            catch (InvalidSequenceException exc) {
                PrebillingError errore = exc.getErrore();
                String descrizione = TariffeGasHelper.handleException(this.dateFormat, exc, this.talkManager);
                List<MisuraGas> misure = consumiMesePdr.getMisure();
                status.addMisureResult(misure, dataFineTariffa, StatoMisure.SOSPESO, errore, descrizione);
                List<Igmg> igmg = consumiMesePdr.getIgmg();
                status.addIgmgResult(igmg, StatoMisure.SOSPESO, errore, descrizione);
            }
            catch (MisuraGasException exc) {
                PrebillingError errore = exc.getErrore();
                String descrizione = TariffeGasHelper.handleException(this.dateFormat, exc, this.talkManager);
                List<MisuraGas> misure = consumiMesePdr.getMisure();
                status.addMisureResult(misure, dataFineTariffa, StatoMisure.SOSPESO, errore, descrizione);
                List<Igmg> igmg = consumiMesePdr.getIgmg();
                status.addIgmgResult(igmg, StatoMisure.SOSPESO, errore, descrizione);
            }
            catch (IncoherentEndDates exc) {
                Date date = exc.getDate();
                String periodo = StrategyCommonHelper.getMeseAnnoDateFormat().format(date);
                ErroreElaborazioneGas errore = ErroreElaborazioneGas.INCOHERENT_ENDDATES;
                Message sentence = new Message("tariffe", errore.getMessage());
                sentence.addParam(String.valueOf(codicePdr) + "/" + azienda);
                sentence.addParam(periodo);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                List<MisuraGas> misure = consumiMesePdr.getMisure();
                status.addMisureResult(misure, dataFineTariffa, StatoMisure.SOSPESO, errore, descrizione);
                List<Igmg> igmg = consumiMesePdr.getIgmg();
                status.addIgmgResult(igmg, StatoMisure.SOSPESO, (PrebillingError)errore, descrizione);
            }
            catch (DataNotFoundException exc) {
                ErroreElaborazioneGas errore = StrategyHelper.getErrore(exc);
                String codice = String.valueOf(codicePdr) + " / " + azienda;
                String excKey = exc.getKey();
                String key = String.valueOf(excKey.equals("0") ? "" : String.valueOf(excKey) + " / ") + this.dateFormat.format(dataInizioTariffa);
                String message = exc.getMessage();
                String descrizione = TariffeGasHelper.handleException(codice, key, message, this.talkManager);
                List<MisuraGas> misure = consumiMesePdr.getMisure();
                status.addMisureResult(misure, dataFineTariffa, StatoMisure.SOSPESO, errore, descrizione);
                List<Igmg> igmg = consumiMesePdr.getIgmg();
                status.addIgmgResult(igmg, StatoMisure.SOSPESO, (PrebillingError)errore, descrizione);
            }
            catch (InconsistentOptionException exc) {
                PrebillingError errore = exc.getErrore();
                List<Sentence> sentences = this.talkManager.getSentencesNoFlush();
                Sentence sentence = sentences.get(sentences.size() - 1);
                List<MisuraGas> misure = consumiMesePdr.getMisure();
                String descrizione = this.talkManager.getMessage(sentence);
                status.addMisureResult(misure, dataFineTariffa, StatoMisure.SOSPESO, errore, descrizione);
                List<Igmg> igmg = consumiMesePdr.getIgmg();
                status.addIgmgResult(igmg, StatoMisure.SOSPESO, errore, descrizione);
                if (!this.bloccoIndice) break block22;
                throw exc;
            }
        }
        return misura;
    }

    protected Date getDataUltimaLettura(String codicePdr) {
        ContrattoGas ultimoContratto = this.giadaDao.getUltimoContratto(codicePdr);
        return ultimoContratto == null ? null : ultimoContratto.getDataLetPre();
    }

    public static double getTotale(List<? extends Consumo> consumi) {
        double totale = 0.0;
        for (Consumo consumo : consumi) {
            totale += consumo.getValore();
        }
        return totale;
    }
}

