/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.TariffeCommonHelper;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.OffertaGas;
import biz.elabor.prebilling.gas.dao.misure.model.PrezzoGas;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.checkconsumi.ConsumiGruppoService;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import biz.elabor.prebilling.gas.services.common.WriteLetstdGasService;
import biz.elabor.prebilling.gas.services.tariffe.AbstractCalcolaTariffeStrategy;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiGruppo;
import biz.elabor.prebilling.gas.services.tariffe.GlobalErrorHandler;
import biz.elabor.prebilling.gas.services.tariffe.TariffeGasHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class CalcolaTariffeStrategy
extends AbstractCalcolaTariffeStrategy {
    private final String reseller;

    public CalcolaTariffeStrategy(int annoRif, Month meseRif, String reseller, MisureGasDao misureDao, String onlyPdr, boolean scivoloEnabled, boolean forceSopraSpglia, boolean bloccoIndice, GiadaGasDao giadaDao, PrebillingGasConfiguration configuration, TalkManager talkManager) {
        super(annoRif, meseRif, configuration, talkManager, forceSopraSpglia, true, false, misureDao, giadaDao, onlyPdr, scivoloEnabled, bloccoIndice);
        this.reseller = reseller;
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        boolean ok;
        SafeMap<String, OffertaGas> offerte = this.misureDao.getOfferte();
        this.letstdGasWriter = new WriteLetstdGasService(this.configuration);
        Set<String> activePdr = this.getActivePdr();
        try {
            ok = this.calcolaTariffePrecedentiIndiretti(activePdr, offerte, status);
            if (ok) {
                ok = this.calcolaTariffeMese(activePdr, offerte, status);
            }
        }
        catch (InconsistentOptionException exc) {
            ok = true;
        }
        return ok;
    }

    @Override
    public List<StatoMisure> getStati() {
        return this.onlyPdr.isEmpty() ? STATI_DA_ELABORARE : STATI;
    }

    private Set<String> getActivePdr() {
        HashSet<String> activePdr;
        if (StrategyHelper.isNull(this.onlyPdr)) {
            activePdr = this.misureDao.getActivePdr(this.annoRif, this.meseRif);
        } else {
            activePdr = new HashSet<String>();
            activePdr.add(this.onlyPdr);
        }
        return activePdr;
    }

    private boolean calcolaTariffeMeseIndiretto(String codicePdr, Date currentMonth, Date dataUltimaLettura, SafeMap<String, OffertaGas> offerte, GasServiceStatus status) throws InconsistentOptionException {
        Month mese;
        ElaborCalendar calendar = new ElaborCalendar(currentMonth);
        int anno = calendar.getAnno();
        Set<String> pdrSet = CalcolaTariffeStrategy.getPdrOnlySet(anno, mese = calendar.getMese(), codicePdr, this.misureDao);
        ListMap<String, ContrattoGas> contratti = this.giadaDao.getContratti(currentMonth, this.reseller, pdrSet, false);
        if (contratti.isEmpty()) {
            this.handleEsclusi(codicePdr, anno, mese, status);
        } else {
            boolean exportLettura = true;
            SafeListMap<String, PrezzoGas> prezziGasMese = this.mappaPrezziGas.getPrezziGasMese(anno, mese);
            boolean next = true;
            Iterable<ContrattoGas> contrattiPdr = contratti.iterable();
            Iterator<ContrattoGas> iterator = contrattiPdr.iterator();
            this.pdrAggregationMap = new HashMap();
            DataNotFoundException globalError = TariffeGasHelper.getGlobalError(anno, mese, contrattiPdr, status, this.misureDao);
            GlobalErrorHandler globalErrorHandler = new GlobalErrorHandler(globalError);
            while (next && iterator.hasNext()) {
                ContrattoGas contratto = iterator.next();
                Applicazione applicazione = status.getApplicazione(contratto);
                if (TariffeGasHelper.checkStart(currentMonth, contratto) && !applicazione.isSpread() && TariffeCommonHelper.checkTrattamento(contratto, anno, mese, applicazione, TipoTrattamento.REGIME)) {
                    ConsumiGruppoService service = new ConsumiGruppoService(anno, mese, contratti, this.pdrAggregationMap, this.misureCalcolate, this.scivoloEnabled, this.forceSopraSoglia, STATI, this.talkManager, this.dateFormat, this.configuration, this.giadaDao, this.misureDao, status);
                    ConsumiGruppo consumiGruppo = service.getConsumiGruppo(contratto);
                    MisuraGas misura = this.calcolaTariffaIndiretto(contratto, globalErrorHandler, anno, mese, dataUltimaLettura, consumiGruppo, exportLettura, prezziGasMese, offerte, status);
                    boolean bl = next = misura != null;
                    if (!next) continue;
                    exportLettura = false;
                    this.addMisura(misura);
                    continue;
                }
                this.handleEsclusi(codicePdr, anno, mese, status);
                break;
            }
        }
        return true;
    }

    private void addMisura(MisuraGas misura) {
        String codicePdr = misura.getCodicePdr();
        LinkedHashMap<Date, MisuraGas> mappaMisurePdr = (LinkedHashMap<Date, MisuraGas>)this.misureCalcolate.get(codicePdr);
        if (mappaMisurePdr == null) {
            mappaMisurePdr = new LinkedHashMap<Date, MisuraGas>();
            this.misureCalcolate.put(codicePdr, mappaMisurePdr);
        }
        Date dataMisura = misura.getDataMisura();
        mappaMisurePdr.put(dataMisura, misura);
    }

    private void handleEsclusi(String codicePdr, int anno, Month mese, GasServiceStatus status) {
        List<MisuraGas> misurePeriodiche = this.misureDao.getMisurePeriodiche(codicePdr, anno, mese, this.talkManager);
        List<MisuraGas> misureRettifica = this.misureDao.getMisureRettificaPeriodiche(codicePdr, anno, mese, this.talkManager);
        Message sentence = new Message("tariffe", "escluso");
        sentence.addParam(String.valueOf(codicePdr) + " - " + mese.getIndex() + "/" + anno);
        String descrizione = this.talkManager.getMessage(sentence);
        Date endDate = CalendarTools.getEndDate(anno, mese);
        status.addMisureResult(misurePeriodiche, endDate, StatoMisure.ESCLUSO, ErroreElaborazioneGas.OK, descrizione);
        status.addMisureResult(misureRettifica, endDate, StatoMisure.ESCLUSO, ErroreElaborazioneGas.OK, descrizione);
    }

    private boolean calcolaTariffePrecedentiIndiretti(Set<String> activePdr, SafeMap<String, OffertaGas> offerte, GasServiceStatus status) throws InconsistentOptionException {
        boolean ok = true;
        Iterator<String> iterator = activePdr.iterator();
        while (ok && iterator.hasNext()) {
            String codicePdr = iterator.next();
            ok &= this.calcolaTariffePrecedentiIndiretto(codicePdr, offerte, status);
        }
        return ok;
    }

    private boolean calcolaTariffePrecedentiIndiretto(String codicePdr, SafeMap<String, OffertaGas> offerte, GasServiceStatus status) throws InconsistentOptionException {
        Date nextMonth;
        boolean ok = true;
        Date firstMonth = this.misureDao.getFirstActiveMonth(codicePdr);
        Date dataUltimaLettura = this.getDataUltimaLettura(codicePdr);
        if (dataUltimaLettura == null) {
            nextMonth = null;
        } else {
            Date nextDate = CalendarTools.nextDay(dataUltimaLettura);
            nextMonth = CalendarTools.getStartOfMonth(nextDate);
        }
        Date startMonth = CalendarTools.minNullable(firstMonth, nextMonth);
        if (startMonth != null) {
            ok = this.calcolaTariffePrecedentiIndiretto(codicePdr, startMonth, dataUltimaLettura, offerte, status);
        }
        return ok;
    }

    private boolean calcolaTariffeMese(Set<String> activePdr, SafeMap<String, OffertaGas> offerte, GasServiceStatus status) throws InconsistentOptionException {
        this.pdrAggregationMap = new HashMap();
        Set<String> pdrSet = CalcolaTariffeStrategy.getPdrOnlySet(this.annoRif, this.meseRif, this.onlyPdr, this.misureDao);
        Date mese = CalendarTools.getDate(this.annoRif, this.meseRif, 1);
        ListMap<String, ContrattoGas> contratti = this.giadaDao.getContratti(mese, this.reseller, pdrSet, false);
        if (contratti.isEmpty()) {
            if (this.onlyPdr.isEmpty() && this.reseller.equals("*")) {
                Message sentence = new Message("tariffe", "missing.indice");
                sentence.addParam(this.dateFormat.format(mese));
                this.talkManager.addSentence(sentence);
            }
        } else {
            for (Map.Entry entry : contratti.entrySet()) {
                String codicePdr = (String)entry.getKey();
                Date dataUltimaLettura = this.getDataUltimaLettura(codicePdr);
                List contrattiPdr = (List)entry.getValue();
                this.calcolaTariffeMese(this.annoRif, this.meseRif, activePdr, contrattiPdr, dataUltimaLettura, contratti, offerte, status);
            }
        }
        return true;
    }

    private boolean calcolaTariffePrecedentiIndiretto(String codicePdr, Date firstMonth, Date dataUltimaLettura, SafeMap<String, OffertaGas> offerte, GasServiceStatus status) throws InconsistentOptionException {
        Date rifMonth = CalendarTools.getDate(this.annoRif, this.meseRif, 1);
        boolean ok = true;
        Date currentMonth = firstMonth;
        while (ok && currentMonth.before(rifMonth)) {
            ok = this.calcolaTariffeMeseIndiretto(codicePdr, currentMonth, dataUltimaLettura, offerte, status);
            currentMonth = CalendarTools.getNextMese(currentMonth);
        }
        return ok;
    }
}

