/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.common.model.TipoFlatVisitor;
import biz.elabor.prebilling.common.model.TipoProfilo;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import biz.elabor.prebilling.gas.services.tariffe.GasTipoProfiloVisitor;
import biz.elabor.prebilling.gas.services.tariffe.ZeroGasProfiler;
import biz.elabor.prebilling.gas.utils.GasProfileBuilder;
import biz.elabor.prebilling.gas.utils.GasProfiler;
import java.util.Date;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;

class GasTipoFlatVisitor
implements TipoFlatVisitor {
    private final String cdProPre;
    private final int anno;
    private final Month mese;
    private final GasProfileBuilder builder;
    private GasProfiler profiler;

    public GasTipoFlatVisitor(String cdProPre, int anno, Month mese, TipoProfilo tipoProfilo, GiadaGasDao giadaDao) {
        this.cdProPre = cdProPre;
        this.anno = anno;
        this.mese = mese;
        GasTipoProfiloVisitor visitor = new GasTipoProfiloVisitor(giadaDao);
        tipoProfilo.accept(visitor);
        this.builder = visitor.getBuilder();
    }

    public double getConsumoFlat(double qtConFla, Date data) throws DataNotFoundException {
        if (this.profiler == null) {
            ErroreElaborazioneGas errore = ErroreElaborazioneGas.MISSING_PROFILO;
            String message = errore.getMessage();
            int ordinal = errore.ordinal();
            throw new DataNotFoundException(message, this.cdProPre, ordinal);
        }
        return this.profiler.getConsumoGiorno(qtConFla, data);
    }

    @Override
    public void visitNonFlat() {
        this.profiler = new ZeroGasProfiler();
    }

    @Override
    public void visitFlat() {
        this.profiler = this.builder.getProfiler(this.cdProPre, this.anno, this.mese);
    }

    @Override
    public void visitResiduo() {
        this.profiler = this.builder.getProfiler(this.cdProPre, this.anno, this.mese);
    }

    @Override
    public void visitResiduoPositivo() {
        this.profiler = this.builder.getProfiler(this.cdProPre, this.anno, this.mese);
    }

    @Override
    public void visitResiduoNegativo() {
        this.profiler = this.builder.getProfiler(this.cdProPre, this.anno, this.mese);
    }

    @Override
    public void visitSpread() {
    }

    @Override
    public void visitResiduoNegativoMinoritario() {
        this.profiler = this.builder.getProfiler(this.cdProPre, this.anno, this.mese);
    }
}

