/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.common.model.TipoProfiloVisitor;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.utils.AnnualProfileBuilder;
import biz.elabor.prebilling.gas.utils.DailyProfileBuilder;
import biz.elabor.prebilling.gas.utils.GasProfileBuilder;

class GasTipoProfiloVisitor
implements TipoProfiloVisitor {
    private final GiadaGasDao giadaDao;
    private GasProfileBuilder builder;

    public GasTipoProfiloVisitor(GiadaGasDao giadaDao) {
        this.giadaDao = giadaDao;
    }

    public GasProfileBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public void visitAnnuale() {
        this.builder = new AnnualProfileBuilder(this.giadaDao);
    }

    @Override
    public void visitGiornaliero() {
        this.builder = new DailyProfileBuilder();
    }

    @Override
    public void visitOrario() {
        throw new RuntimeException("profilo orario non implementato per il gas");
    }

    @Override
    public void visitMensile() {
        throw new RuntimeException("profilo mensile non implementato per il gas");
    }
}

