/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.OffertaGas;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.common.WriteLetstdGasService;
import biz.elabor.prebilling.gas.services.tariffe.AbstractCalcolaTariffeStrategy;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.tools.StringUtils;

public class RicalcoloTariffeStrategy
extends AbstractCalcolaTariffeStrategy {
    private final String reseller;

    public RicalcoloTariffeStrategy(int annoRif, Month meseRif, MisureGasDao misureDao, String pdr, String reseller, boolean scivoloEnabled, boolean forceSopraSpglia, boolean esportaLetture, boolean bloccoIndice, GiadaGasDao giadaDao, PrebillingGasConfiguration configuration, TalkManager talkManager) {
        super(annoRif, meseRif, configuration, talkManager, forceSopraSpglia, esportaLetture, true, misureDao, giadaDao, pdr, scivoloEnabled, bloccoIndice);
        this.reseller = reseller;
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        boolean ok;
        SafeMap<String, OffertaGas> offerte = this.misureDao.getOfferte();
        this.letstdGasWriter = new WriteLetstdGasService(this.configuration);
        try {
            ok = this.ricalcolaTariffeMese(offerte, status);
        }
        catch (InconsistentOptionException exc) {
            ok = true;
        }
        return ok;
    }

    private boolean ricalcolaTariffeMese(SafeMap<String, OffertaGas> offerte, GasServiceStatus status) throws InconsistentOptionException {
        Set<String> pdrSet;
        Date rifMonth = CalendarTools.getDate(this.annoRif, this.meseRif, 1);
        ListMap<String, ContrattoGas> contratti = this.giadaDao.getContratti(rifMonth, "*", pdrSet = RicalcoloTariffeStrategy.getPdrOnlySet(this.annoRif, this.meseRif, this.onlyPdr, this.misureDao), false);
        if (contratti.isEmpty()) {
            Message sentence = new Message("ricalcolo.tariffe", "no.opzioni.contrattuali");
            sentence.addParam(this.onlyPdr);
            sentence.addParam(this.dateFormatMonthTear.format(rifMonth));
            this.talkManager.addSentence(sentence);
        } else {
            List contrattiPdr = (List)contratti.get(this.onlyPdr);
            if (!contratti.isEmpty() && (StringUtils.isEmpty(this.reseller) || this.reseller.equals(((ContrattoGas)contrattiPdr.get(0)).getReseller()))) {
                HashSet<String> activePdr = new HashSet<String>();
                activePdr.add(this.onlyPdr);
                Date dataUltimaLettura = this.getDataUltimaLettura(this.onlyPdr);
                this.pdrAggregationMap = new HashMap();
                this.calcolaTariffeMese(this.annoRif, this.meseRif, activePdr, contrattiPdr, dataUltimaLettura, contratti, offerte, status);
            }
        }
        return true;
    }

    @Override
    protected List<StatoMisure> getStati() {
        return STATI;
    }
}

