/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.TariffeCommonHelper;
import biz.elabor.prebilling.common.dao.MultipuntoOption;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.ContrattiHelper;
import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.common.model.PrezziMedi;
import biz.elabor.prebilling.common.model.TipoFlat;
import biz.elabor.prebilling.common.model.TipoProfilo;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.OffertaGas;
import biz.elabor.prebilling.gas.dao.misure.model.PrezzoGas;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiGruppo;
import biz.elabor.prebilling.gas.services.tariffe.GasTipoFlatVisitor;
import biz.elabor.prebilling.gas.services.tariffe.InvalidInpcsException;
import biz.elabor.prebilling.gas.services.tariffe.InvalidSequenceException;
import biz.elabor.prebilling.gas.services.tariffe.MissingMisuraException;
import biz.elabor.prebilling.gas.services.tariffe.TariffeContratto;
import biz.elabor.prebilling.gas.services.tariffe.TariffeGasHelper;
import biz.elabor.prebilling.gas.services.tariffe.model.DettaglioGiorno;
import biz.elabor.prebilling.gas.services.tariffe.model.TariffaGas;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.tools.MathUtils;
import org.homelinux.elabor.tools.StringUtils;

public class TariffaCalculator {
    private final int anno;
    private final Month mese;
    private final ListMap<String, MultipuntoOption> multipuntoOptions;
    private final SafeMap<String, OffertaGas> offerte;
    private final GasServiceStatus status;
    private final int nCifre;
    private final boolean bloccoIndice;
    private final MisureGasDao misureDao;
    private final GiadaGasDao giadaDao;
    private final PrebillingGasConfiguration configuration;
    private final TalkManager talkManager;
    private PrezziMedi prezziMedi;

    public TariffaCalculator(int anno, Month mese, SafeMap<String, OffertaGas> offerte, GasServiceStatus status, int nCifre, boolean bloccoIndice, MisureGasDao misureDao, GiadaGasDao giadaDao, PrebillingGasConfiguration configuration, ListMap<String, MultipuntoOption> multipuntoOptions, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.multipuntoOptions = multipuntoOptions;
        this.offerte = offerte;
        this.status = status;
        this.nCifre = nCifre;
        this.bloccoIndice = bloccoIndice;
        this.misureDao = misureDao;
        this.giadaDao = giadaDao;
        this.configuration = configuration;
        this.prezziMedi = new PrezziMedi("G", anno, mese, misureDao);
        this.talkManager = talkManager;
    }

    public TariffeContratto calcolaTariffe(ContrattoGas contratto, boolean multipunto, Date dataFine, double consumoTotalePdr, List<DettaglioGiorno> dettagli, SafeListMap<String, PrezzoGas> prezziGas, ConsumiGruppo consumiGruppo) throws DataNotFoundException, InvalidSequenceException, InvalidInpcsException, MissingMisuraException, InconsistentOptionException {
        Date dataInizio = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
        String codicePdr = contratto.getCodice();
        String azienda = contratto.getReseller();
        TariffeGasHelper.checkConsumoFineMese(azienda, codicePdr, dettagli, dataInizio, dataFine);
        return this.calcolaTariffe(contratto, multipunto, consumoTotalePdr, dettagli, prezziGas, consumiGruppo);
    }

    private TariffeContratto calcolaTariffe(ContrattoGas contratto, boolean multipunto, double consumoTotalePdr, List<DettaglioGiorno> dettagli, SafeListMap<String, PrezzoGas> prezziGas, ConsumiGruppo consumiGruppo) throws DataNotFoundException, InvalidSequenceException, InvalidInpcsException, MissingMisuraException, InconsistentOptionException {
        TariffeContratto tariffe;
        String codicePdr = contratto.getCodice();
        Date dataInizioTariffa = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
        if (dettagli.get(0).getDataMisura().after(dataInizioTariffa)) {
            String azienda = contratto.getReseller();
            throw new MissingMisuraException(ErroreElaborazioneGas.MISSING_CONSUMI, azienda, codicePdr, dataInizioTariffa);
        }
        Applicazione applicazione = this.status.getApplicazione(contratto);
        TipoFlat tipoFlat = applicazione.getTipoFlat();
        if (contratto.isFixing() || tipoFlat.isFixing()) {
            double consumoTotaleReale = TariffaCalculator.getConsumoTotaleReale(dettagli);
            if (consumoTotaleReale == 0.0) {
                tariffe = multipunto ? TariffeGasHelper.calcolaTariffaDefault(contratto, this.anno, this.mese, 0.0, this.status) : TariffeGasHelper.calcolaTariffaScivolo(contratto, this.anno, this.mese, this.offerte, this.status);
                TariffeGasHelper.applicaPenale(contratto, this.anno, this.mese, prezziGas, this.nCifre, tariffe);
            } else {
                List<Applicazione> subapplicazioni = TariffeCommonHelper.getSubapplicazioni(applicazione, this.anno, this.mese, this.status, this.misureDao);
                if (subapplicazioni.isEmpty()) {
                    subapplicazioni.add(applicazione);
                }
                tariffe = this.calcolaTariffeSub(contratto, consumoTotalePdr, dettagli, prezziGas, codicePdr, dataInizioTariffa, applicazione, subapplicazioni, consumiGruppo);
            }
        } else {
            List<Applicazione> subapplicazioni = Arrays.asList(applicazione);
            tariffe = this.calcolaTariffeSub(contratto, consumoTotalePdr, dettagli, prezziGas, codicePdr, dataInizioTariffa, applicazione, subapplicazioni, consumiGruppo);
        }
        return tariffe;
    }

    private TariffeContratto calcolaTariffeSub(ContrattoGas contratto, double consumoTotalePdr, List<DettaglioGiorno> dettagli, SafeListMap<String, PrezzoGas> prezziGas, String codicePdr, Date dataInizioTariffa, Applicazione applicazione, List<Applicazione> subapplicazioni, ConsumiGruppo consumiGruppo) throws InvalidSequenceException, DataNotFoundException, InvalidInpcsException, MissingMisuraException, InconsistentOptionException {
        TipoFlat tipoFlat = applicazione.getTipoFlat();
        double consumoReale = TariffaCalculator.getConsumoReale(dettagli);
        Date dataScadenza = contratto.getDataScadenza();
        String codIndEne = tipoFlat.getCodiceIndiceEnergetico(contratto);
        boolean rettifica = this.misureDao.isTariffaElaborata(codicePdr, dataInizioTariffa);
        TariffeContratto tariffe = new TariffeContratto(contratto, this.anno, this.mese, applicazione, codIndEne, dataScadenza, rettifica, false, consumoTotalePdr);
        for (Applicazione subApplicazione : subapplicazioni) {
            double consumoTariffa;
            TariffaGas tariffa;
            TipoFlat subTipoFlat = subApplicazione.getTipoFlat();
            String subCodIndiceEnergetico = subTipoFlat.getCodiceIndiceEnergetico(contratto);
            List<DettaglioGiorno> subDettagli = TariffaCalculator.cloneDettagli(dettagli);
            List<PrezzoGas> prezzi = this.getPrezziIndice(prezziGas, subCodIndiceEnergetico);
            this.checkIndice(contratto, prezzi);
            if (subTipoFlat.isApplicable(consumoReale)) {
                tariffa = this.calcolaTariffa(contratto, subApplicazione, subDettagli, prezzi);
            } else {
                int tipo = subApplicazione.getTipo();
                tariffa = new TariffaGas(this.anno, this.mese, tipo, subDettagli, prezzi, 0.0, 0.0, 0.0, 0.0);
            }
            String codIndApplicato = consumoReale == 0.0 && subTipoFlat == TipoFlat.NON_FLAT ? TariffeGasHelper.getCodIndiceScivolo(this.offerte, codIndEne) : codIndEne;
            tariffe.add(tariffa);
            tariffe.setCodIndiceApplicato(codIndApplicato);
            double consumoEfficace = tariffa.getConsumoTotaleEfficace();
            if (tipoFlat.isFixingSwap()) {
                tariffa.clearDettagli();
                String codRaggruppamento = consumiGruppo.getCodRaggruppamento();
                List opzioniFixingSwap = (List)this.multipuntoOptions.get(codRaggruppamento);
                if (opzioniFixingSwap == null || opzioniFixingSwap.isEmpty()) {
                    ErroreElaborazioneGas errore = ErroreElaborazioneGas.MISSING_FIXING_SWAP_OPTIONS;
                    String message = errore.getMessage();
                    throw new DataNotFoundException(message, codRaggruppamento, errore.ordinal());
                }
                Date dtIndice = contratto.getDtindice();
                Date inizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
                if (!inizioMese.equals(dtIndice)) {
                    ErroreElaborazioneGas error = dtIndice == null ? ErroreElaborazioneGas.MISSING_DTINDICE : ErroreElaborazioneGas.INCONSISTENT_DTINDICE;
                    TariffaCalculator.handleInconsistentPrice(error, contratto, inizioMese, dtIndice, codIndEne, 0.0, 0.0, this.talkManager);
                    throw new InconsistentOptionException(codIndEne, inizioMese, dtIndice, 0.0, 0.0, error);
                }
                double consumoTotaleFixingSwap = consumiGruppo.getConsumoTotaleFixingSwap();
                consumoTariffa = TariffaCalculator.getQtMisuraFixingSwap(contratto, consumoTotaleFixingSwap, opzioniFixingSwap);
                double prezzo = tipoFlat.getEmspread(contratto, consumoTotaleFixingSwap, opzioniFixingSwap);
                if (contratto.getPrezzoMedio() == 0.0) {
                    ErroreElaborazioneGas errore = ErroreElaborazioneGas.ZERO_QTINDENE;
                    TariffaCalculator.handleInconsistentPrice(errore, contratto, inizioMese, null, codIndEne, 0.0, 0.0, this.talkManager);
                    throw new InconsistentOptionException(codIndEne, inizioMese, null, 0.0, 0.0, errore);
                }
                tariffa.setValore(prezzo);
            } else {
                consumoTariffa = subTipoFlat.getConsumoTariffa(consumoTotalePdr, consumoEfficace);
            }
            tariffe.setConsumoTariffa(consumoTariffa);
        }
        return tariffe;
    }

    private TariffaGas calcolaTariffa(ContrattoGas contratto, Applicazione applicazione, List<DettaglioGiorno> dettagli, List<PrezzoGas> prezziIndice) throws InvalidSequenceException, DataNotFoundException, InvalidInpcsException, MissingMisuraException {
        String cdProPre = contratto.getCdProPre();
        double prezzoGiornoFlat = contratto.getEmtaruni();
        TipoFlat tipoFlat = applicazione.getTipoFlat();
        double prezzoGiornoSpread = tipoFlat.getPrezzoGiornoSpread(contratto);
        TipoProfilo tipoProfilo = applicazione.getTipoProfilo();
        GasTipoFlatVisitor tipoFlatVisitor = new GasTipoFlatVisitor(cdProPre, this.anno, this.mese, tipoProfilo, this.giadaDao);
        tipoFlat.accept(tipoFlatVisitor);
        int tipoApplicazione = applicazione.getTipo();
        Date dataInizio = dettagli.get(0).getDataMisura();
        double qtConFla = contratto.getQtConFla();
        double costoGiornoFlat = qtConFla * prezzoGiornoFlat;
        double consumoRealeTotale = 0.0;
        double consumoTotale = 0.0;
        double costoTotale = 0.0;
        Iterator<DettaglioGiorno> dIterator = dettagli.iterator();
        Iterator<PrezzoGas> pIterator = prezziIndice.iterator();
        while (dIterator.hasNext() && pIterator.hasNext()) {
            DettaglioGiorno dettaglio = dIterator.next();
            PrezzoGas prezzo = pIterator.next();
            Date dataMisura = dettaglio.getDataMisura();
            Date dataPrezzo = prezzo.getData();
            while (dataPrezzo.before(dataInizio)) {
                prezzo = pIterator.next();
                dataPrezzo = prezzo.getData();
            }
            if (dataPrezzo.before(dataMisura)) {
                String codicePdr = contratto.getCodice();
                String azienda = contratto.getReseller();
                throw new MissingMisuraException(ErroreElaborazioneGas.MISSING_CONSUMI, azienda, codicePdr, dataPrezzo);
            }
            if (!dataMisura.equals(dataPrezzo)) {
                String codicePdr = contratto.getCodice();
                String azienda = contratto.getReseller();
                String indice = prezzo.getIndice();
                throw new InvalidSequenceException(azienda, codicePdr, indice, dataMisura);
            }
            double consumoReale = dettaglio.getConsumo();
            consumoRealeTotale += consumoReale;
            double consumoFlat = tipoFlatVisitor.getConsumoFlat(qtConFla, dataMisura);
            double prezzoGiornoReale = TariffeGasHelper.getPrezzoConvertito(prezzo, this.nCifre, contratto);
            double prezzoGiornoEfficace = tipoFlat.getPrezzo(prezzoGiornoReale, prezzoGiornoFlat, prezzoGiornoSpread, consumoReale, consumoFlat);
            double emtaruni = contratto.getEmtaruni();
            double consumoEfficace = prezzoGiornoEfficace == 0.0 ? 0.0 : tipoFlat.getConsumoEfficace(consumoReale, consumoFlat, emtaruni, prezzoGiornoReale);
            consumoTotale += consumoEfficace;
            double costoGiorno = tipoFlat.getCostoGiorno(consumoEfficace, prezzoGiornoEfficace, costoGiornoFlat, this.nCifre);
            dettaglio.setConsumoEfficace(consumoEfficace);
            dettaglio.setPrezzo(prezzoGiornoEfficace);
            dettaglio.setCosto(costoGiorno);
            costoTotale += costoGiorno;
        }
        double prezzo = this.getPrezzo(tipoFlat, consumoRealeTotale, consumoTotale, costoTotale);
        double valore = MathUtils.round(prezzo, this.nCifre);
        return new TariffaGas(this.anno, this.mese, tipoApplicazione, dettagli, prezziIndice, valore, consumoTotale, consumoRealeTotale, costoTotale);
    }

    private static double getConsumoTotaleReale(List<DettaglioGiorno> dettagli) {
        double value = 0.0;
        for (DettaglioGiorno dettaglio : dettagli) {
            value += dettaglio.getConsumo();
        }
        return value;
    }

    private static double getConsumoReale(List<DettaglioGiorno> dettagli) {
        double consumoReale = 0.0;
        for (DettaglioGiorno dettaglio : dettagli) {
            consumoReale += dettaglio.getConsumo();
        }
        return consumoReale;
    }

    private static double getQtMisuraFixingSwap(Contratto contratto, double consumoTotaleFixingSwap, List<MultipuntoOption> opzioniFixingSwap) {
        double volume = 0.0;
        for (MultipuntoOption option : opzioniFixingSwap) {
            volume += option.getVolume();
        }
        double qtConsum = contratto.getQtconsum();
        return volume * qtConsum / consumoTotaleFixingSwap;
    }

    private List<PrezzoGas> getPrezziIndice(SafeListMap<String, PrezzoGas> prezziGas, String subCodIndiceEnergetico) throws DataNotFoundException {
        List prezziIndice = StringUtils.isEmpty(subCodIndiceEnergetico) || subCodIndiceEnergetico.equals("0") ? TariffeGasHelper.createPrezziZero(this.anno, this.mese) : (List)prezziGas.get(subCodIndiceEnergetico);
        return prezziIndice;
    }

    private static List<DettaglioGiorno> cloneDettagli(List<DettaglioGiorno> dettagli) {
        ArrayList<DettaglioGiorno> cloneDettagli = new ArrayList<DettaglioGiorno>();
        for (DettaglioGiorno dettaglio : dettagli) {
            cloneDettagli.add(dettaglio.cloneDettaglio());
        }
        return cloneDettagli;
    }

    private void checkIndice(Contratto contratto, List<PrezzoGas> prezzi) throws InconsistentOptionException, DataNotFoundException {
        block5: {
            if (this.configuration.isCheckPrezzi()) {
                Date inizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
                String reseller = contratto.getReseller();
                String codIndEne = contratto.getCodIndiceEnergetico();
                String codIndScivolo = TariffeGasHelper.getCodIndiceScivolo(this.offerte, codIndEne);
                try {
                    double tolleranza = this.configuration.getTolleranzaPrezzi();
                    double prezzoMedioIndice = TariffaCalculator.getPrezzoMedio(prezzi);
                    double prezzoMedioContratto = this.prezziMedi.getPrezzo(reseller, codIndScivolo);
                    if (Math.abs(prezzoMedioContratto - prezzoMedioIndice) > tolleranza) {
                        ErroreElaborazioneGas errore = ErroreElaborazioneGas.INCONSISTENT_PREZZO_MEDIO;
                        TariffaCalculator.handleInconsistentPrice(errore, contratto, inizioMese, null, codIndScivolo, prezzoMedioContratto, prezzoMedioIndice, this.talkManager);
                        if (this.bloccoIndice) {
                            throw new InconsistentOptionException(codIndScivolo, inizioMese, null, prezzoMedioIndice, prezzoMedioContratto, errore);
                        }
                    }
                }
                catch (DataNotFoundException exc) {
                    ErroreElaborazioneGas errore = ErroreElaborazioneGas.MISSING_DTINDICE;
                    TariffaCalculator.handleInconsistentPrice(errore, contratto, inizioMese, null, codIndScivolo, 0.0, 0.0, this.talkManager);
                    if (!this.bloccoIndice) break block5;
                    throw new InconsistentOptionException(codIndScivolo, inizioMese, null, 0.0, 0.0, errore);
                }
            }
        }
    }

    private static void handleInconsistentPrice(PrebillingError errore, Contratto contratto, Date date, Date refDate, String codIndScivolo, double prezzoMedioContratto, double prezzoMedioIndice, TalkManager talkManager) {
        String message = errore.getMessage();
        Message sentence = new Message("tariffe", message);
        String codicePdr = contratto.getCodice();
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        DecimalFormat doubleFormat = StrategyCommonHelper.getPriceFormat();
        String reseller = contratto.getReseller();
        sentence.addParam(String.valueOf(codicePdr) + " / " + reseller);
        sentence.addParam(String.valueOf(codIndScivolo) + " / " + dateFormat.format(date));
        sentence.addParam(refDate == null ? null : dateFormat.format(refDate));
        sentence.addParam(doubleFormat.format(prezzoMedioIndice));
        sentence.addParam(doubleFormat.format(prezzoMedioContratto));
        talkManager.addSentence(sentence);
    }

    private static double getPrezzoMedio(List<PrezzoGas> prezzi) {
        double totale = 0.0;
        double numero = 0.0;
        for (PrezzoGas prezzo : prezzi) {
            totale += prezzo.getValore();
            numero += 1.0;
        }
        return totale / numero;
    }

    private double getPrezzo(TipoFlat tipoFlat, double consumoTotaleReale, double consumoTotaleEfficace, double costoTotale) {
        double consumo = tipoFlat.getConsumoTotale(consumoTotaleReale, consumoTotaleEfficace);
        return consumo == 0.0 ? 0.0 : MathUtils.round(costoTotale / consumo, this.nCifre);
    }
}

