/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.ContrattiHelper;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.services.tariffe.model.TariffaGas;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;

public class TariffeContratto {
    private final ContrattoGas contratto;
    private final int anno;
    private final Month mese;
    private final Applicazione applicazione;
    private final List<TariffaGas> tariffe;
    private Date dataScadenza;
    private final String codIndiceEnergetico;
    private final boolean rettifica;
    private final boolean scivolo;
    private final double consumoTotalePdr;
    private String codIndiceApplicato;
    private double consumoTariffa;
    private TariffaGas penale;

    public TariffeContratto(ContrattoGas contratto, int anno, Month mese, Applicazione applicazione, String codIndiceEnergetico, Date dataScadenza, boolean rettifica, boolean scivolo, double consumoTotalePdr) {
        this.contratto = contratto;
        this.anno = anno;
        this.mese = mese;
        this.applicazione = applicazione;
        this.codIndiceEnergetico = codIndiceEnergetico;
        this.dataScadenza = dataScadenza;
        this.rettifica = rettifica;
        this.scivolo = scivolo;
        this.consumoTotalePdr = consumoTotalePdr;
        this.tariffe = new ArrayList<TariffaGas>();
    }

    public void add(TariffaGas tariffa) {
        this.tariffe.add(tariffa);
    }

    public void setCodIndiceApplicato(String codIndiceApplicato) {
        this.codIndiceApplicato = codIndiceApplicato;
    }

    public int getAnno() {
        return this.anno;
    }

    public Month getMese() {
        return this.mese;
    }

    public Applicazione getApplicazione() {
        return this.applicazione;
    }

    public List<TariffaGas> getTariffe() {
        return this.tariffe;
    }

    public String getAnnoMese() {
        Date date = CalendarTools.getDate(this.anno, this.mese, 1);
        return StrategyCommonHelper.getAnnoMeseDateFormat().format(date);
    }

    public String getAnnoMesePrec() {
        Date date = CalendarTools.getPrevMese(this.anno, this.mese);
        return StrategyCommonHelper.getAnnoMeseDateFormat().format(date);
    }

    public Date getDataScadenza() {
        return this.dataScadenza;
    }

    public void fixDataScadenza() {
        this.dataScadenza = CalendarTools.getEndDate(this.anno, this.mese);
    }

    public Date getDataInizio() {
        return ContrattiHelper.getInizioTariffa(this.contratto, this.anno, this.mese);
    }

    public String getCodicePdr() {
        return this.contratto.getCodice();
    }

    public Date getDataValidita() {
        return this.contratto.getDataValidita();
    }

    public Date getDataRevoca() {
        return this.contratto.getDataRevoca();
    }

    public Integer getCodAzienda() {
        return this.contratto.getCodAzienda();
    }

    public Integer getCodZona() {
        return this.contratto.getCodZona();
    }

    public Integer getCodUtente() {
        return this.contratto.getCodUtente();
    }

    public double getAqconsum() {
        return this.contratto.getAqconsum();
    }

    public double getInpcsAcquisto() {
        return this.contratto.getInpcsAcquisto();
    }

    public double getValore() {
        double valore = 0.0;
        for (TariffaGas tariffa : this.tariffe) {
            valore += tariffa.getValore();
        }
        return valore;
    }

    public double getCostoTotale() {
        double valore = 0.0;
        for (TariffaGas tariffa : this.tariffe) {
            valore += tariffa.getCostoTotale();
        }
        return valore;
    }

    public String getCodIndiceEnergetico() {
        return this.codIndiceEnergetico;
    }

    public boolean isRettifica() {
        return this.rettifica;
    }

    public double getConsumoTotale() {
        return this.tariffe.get(0).getConsumoReale();
    }

    public String getCodIndiceApplicato() {
        return this.codIndiceApplicato;
    }

    public boolean isScivolo() {
        return this.scivolo;
    }

    public void setConsumoTariffa(double consumoTariffa) {
        this.consumoTariffa = consumoTariffa;
    }

    public double getConsumoTariffa() {
        return this.consumoTariffa;
    }

    public void setPenale(TariffaGas penale) {
        this.penale = penale;
    }

    public TariffaGas getPenale() {
        return this.penale;
    }

    public double getConsumoTotalePdr() {
        return this.consumoTotalePdr;
    }
}

