/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.common.IncoherentEndDates;
import biz.elabor.prebilling.common.TariffeCommonHelper;
import biz.elabor.prebilling.common.dao.BasicMisureDao;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.common.model.TipoFlat;
import biz.elabor.prebilling.common.utils.ListWriter;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.OffertaGas;
import biz.elabor.prebilling.gas.dao.misure.model.PrezzoGas;
import biz.elabor.prebilling.gas.dao.misure.model.TipoLettura;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import biz.elabor.prebilling.gas.services.common.WriteLetstdGasService;
import biz.elabor.prebilling.gas.services.tariffe.CoeffCorrChangedException;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiMesePdr;
import biz.elabor.prebilling.gas.services.tariffe.CounterChangedException;
import biz.elabor.prebilling.gas.services.tariffe.InvalidInpcsException;
import biz.elabor.prebilling.gas.services.tariffe.InvalidSequenceException;
import biz.elabor.prebilling.gas.services.tariffe.MissingIngressoException;
import biz.elabor.prebilling.gas.services.tariffe.MissingMisuraException;
import biz.elabor.prebilling.gas.services.tariffe.MisuraGasException;
import biz.elabor.prebilling.gas.services.tariffe.TariffeContratto;
import biz.elabor.prebilling.gas.services.tariffe.TariffePdr;
import biz.elabor.prebilling.gas.services.tariffe.TariffePdrData;
import biz.elabor.prebilling.gas.services.tariffe.model.Consumo;
import biz.elabor.prebilling.gas.services.tariffe.model.DettaglioGiorno;
import biz.elabor.prebilling.gas.services.tariffe.model.TariffaGas;
import biz.elabor.prebilling.util.DefaultListWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.DaysOfMonthIterator;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.DataException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.Sentence;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.tools.MathUtils;
import org.homelinux.elabor.tools.StringUtils;
import org.javatuples.Pair;

public class TariffeGasHelper {
    public static boolean checkStart(Date date, ContrattoGas contratto) {
        Date dataInizio = contratto.getDataInizio();
        Date nextMonth = CalendarTools.getNextMese(date);
        return dataInizio.before(nextMonth);
    }

    public static Date getDataUltimaLetturaReale(List<MisuraGas> letture) {
        Date dataUltimaLetturaReale = null;
        for (MisuraGas lettura : letture) {
            if (lettura.isStimata()) continue;
            dataUltimaLetturaReale = lettura.getDataMisura();
        }
        return dataUltimaLetturaReale;
    }

    public static List<DettaglioGiorno> buildDettagli(List<? extends Consumo> consumi) {
        ArrayList<DettaglioGiorno> dettagli = new ArrayList<DettaglioGiorno>();
        for (Consumo consumo : consumi) {
            dettagli.add(new DettaglioGiorno(consumo));
        }
        return dettagli;
    }

    public static void checkConsumoFineMese(String azienda, String codicePdr, List<DettaglioGiorno> consumi, Date dataInizio, Date dataFine) throws MissingMisuraException {
        if (consumi.isEmpty()) {
            throw new MissingMisuraException(ErroreElaborazioneGas.MISSING_CONSUMI, azienda, codicePdr, dataInizio);
        }
        DettaglioGiorno lastConsumo = consumi.get(consumi.size() - 1);
        Date dataLastConsumo = lastConsumo.getDataMisura();
        if (dataLastConsumo.before(dataFine)) {
            Date dataConsumoMancante = CalendarTools.nextDay(dataLastConsumo);
            throw new MissingMisuraException(ErroreElaborazioneGas.MISSING_CONSUMI, azienda, codicePdr, dataConsumoMancante);
        }
    }

    public static List<PrezzoGas> createPrezziZero(int anno, Month mese) {
        ArrayList<PrezzoGas> prezziIndice = new ArrayList<PrezzoGas>();
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        DaysOfMonthIterator iterator = new DaysOfMonthIterator(anno, mese);
        while (iterator.hasNext()) {
            iterator.next();
            Date data = calendar.getDate();
            prezziIndice.add(new PrezzoGas(null, data, 0.0));
            calendar.addGiorni(1);
        }
        return prezziIndice;
    }

    public static String getCodIndiceScivolo(SafeMap<String, OffertaGas> offerte, String codIndiceEnergetico) throws DataNotFoundException {
        String codIndiceScivolo;
        if (offerte == null || StringUtils.isEmpty(codIndiceEnergetico) || codIndiceEnergetico.equals("0")) {
            codIndiceScivolo = codIndiceEnergetico;
        } else {
            OffertaGas offerta = (OffertaGas)offerte.get(codIndiceEnergetico);
            codIndiceScivolo = offerta.getCodIndiceScivolo();
        }
        return codIndiceScivolo;
    }

    public static ListWriter getListWriter(TipoLettura tipo, String azienda, Date dataInizioMese, GasServiceStatus status) {
        ListWriter meseWriter;
        Pair<TipoLettura, String> key = new Pair<TipoLettura, String>(tipo, azienda);
        Map<Pair<TipoLettura, String>, Map<Date, ListWriter>> writer = status.getLetstdWriter();
        Map<Date, ListWriter> aziendaWriter = writer.get(key);
        if (aziendaWriter == null) {
            aziendaWriter = new HashMap<Date, ListWriter>();
            writer.put(key, aziendaWriter);
        }
        if ((meseWriter = aziendaWriter.get(dataInizioMese)) == null) {
            meseWriter = new DefaultListWriter();
            aziendaWriter.put(dataInizioMese, meseWriter);
        }
        return meseWriter;
    }

    public static void addTariffe(GasServiceStatus status, String azienda, TariffeContratto tariffeContratto) throws IncoherentEndDates {
        Map<String, Map<String, TariffePdr>> tariffeAzienda = TariffeGasHelper.getTariffeAzienda(status, azienda);
        TariffeGasHelper.fixDataScadenza(tariffeContratto, tariffeAzienda);
        String annoMese = tariffeContratto.getAnnoMese();
        Map<String, TariffePdr> tariffeAziendaMese = TariffeGasHelper.getTariffeAziendaMese(tariffeAzienda, annoMese);
        String codicePdr = tariffeContratto.getCodicePdr();
        TariffePdr tariffePdr = TariffeGasHelper.getTariffePdr(tariffeAziendaMese, codicePdr);
        tariffePdr.add(tariffeContratto);
        try {
            TariffeGasHelper.checkDettagli(tariffePdr);
        }
        catch (IncoherentEndDates exc) {
            tariffeAziendaMese.remove(codicePdr);
            throw exc;
        }
        tariffeAziendaMese.put(codicePdr, tariffePdr);
        status.count(azienda, "tariffa", 1);
    }

    private static void checkDettagli(TariffePdr tariffePdr) throws IncoherentEndDates {
        for (Map.Entry<Date, TariffePdrData> tariffeDataEntry : tariffePdr.entrySet()) {
            TariffePdrData tariffeData = tariffeDataEntry.getValue();
            TariffeGasHelper.checkDettagli(tariffeData);
        }
    }

    private static void checkDettagli(TariffePdrData tariffeData) throws IncoherentEndDates {
        List<TariffeContratto> tariffe = tariffeData.getTariffe();
        TariffeGasHelper.checkDettagli(tariffe);
    }

    private static void checkDettagli(List<TariffeContratto> tariffe) throws IncoherentEndDates {
        int prevSize = 0;
        for (TariffeContratto tariffaContratto : tariffe) {
            for (TariffaGas tariffaGas : tariffaContratto.getTariffe()) {
                List<DettaglioGiorno> dettagli = tariffaGas.getDettagli();
                if (dettagli == null) continue;
                int size = dettagli.size();
                if (prevSize > 0 && prevSize != size) {
                    String azienda = tariffaContratto.getCodAzienda().toString();
                    String codicePdr = tariffaContratto.getCodicePdr();
                    Date data = tariffaContratto.getDataValidita();
                    throw new IncoherentEndDates(azienda, codicePdr, data);
                }
                prevSize = size;
            }
        }
    }

    private static TariffePdr getTariffePdr(Map<String, TariffePdr> tariffeAziendaMese, String codicePdr) {
        TariffePdr tariffe = tariffeAziendaMese.get(codicePdr);
        if (tariffe == null) {
            tariffe = new TariffePdr();
            tariffeAziendaMese.put(codicePdr, tariffe);
        }
        return tariffe;
    }

    private static Map<String, TariffePdr> getTariffeAziendaMese(Map<String, Map<String, TariffePdr>> tariffeAzienda, String annoMese) {
        Map<String, TariffePdr> tariffeAziendaMese = tariffeAzienda.get(annoMese);
        if (tariffeAziendaMese == null) {
            tariffeAziendaMese = new TreeMap<String, TariffePdr>();
            tariffeAzienda.put(annoMese, tariffeAziendaMese);
        }
        return tariffeAziendaMese;
    }

    private static Map<String, Map<String, TariffePdr>> getTariffeAzienda(GasServiceStatus status, String azienda) {
        Map<String, Map<String, Map<String, TariffePdr>>> tariffe = status.getTariffe();
        Map<String, Map<String, TariffePdr>> tariffeAzienda = tariffe.get(azienda);
        if (tariffeAzienda == null) {
            tariffeAzienda = new LinkedHashMap<String, Map<String, TariffePdr>>();
            tariffe.put(azienda, tariffeAzienda);
        }
        return tariffeAzienda;
    }

    private static void fixDataScadenza(TariffeContratto tariffeContratto, Map<String, Map<String, TariffePdr>> tariffeAzienda) {
        String codicePdr;
        TariffePdr tariffePdrMesePrec;
        String annoMesePrec = tariffeContratto.getAnnoMesePrec();
        Map<String, TariffePdr> tariffeAziendaMesePrec = tariffeAzienda.get(annoMesePrec);
        if (tariffeAziendaMesePrec != null && (tariffePdrMesePrec = tariffeAziendaMesePrec.get(codicePdr = tariffeContratto.getCodicePdr())) != null) {
            for (Map.Entry<Date, TariffePdrData> entryPdrData : tariffePdrMesePrec.entrySet()) {
                TariffePdrData tariffePdrData = entryPdrData.getValue();
                for (TariffeContratto tariffaPrec : tariffePdrData.getTariffe()) {
                    if (!TariffeGasHelper.check(tariffeContratto, tariffaPrec)) continue;
                    tariffaPrec.fixDataScadenza();
                }
            }
        }
    }

    private static boolean check(TariffeContratto tariffa, TariffeContratto tariffaPrec) {
        return tariffa.getApplicazione().getTipo() == tariffaPrec.getApplicazione().getTipo();
    }

    public static String handleException(String codice, String key, String message, TalkManager talkManager) {
        Message sentence = new Message("tariffe", message);
        sentence.addParam(codice);
        sentence.addParam(key);
        talkManager.addSentence(sentence);
        return talkManager.getMessage(sentence);
    }

    public static String handleException(int anno, Month mese, String codicePdr, DataException exc, TalkManager talkManager) {
        String codice = String.valueOf(codicePdr) + " - " + mese.getIndex() + "/" + anno;
        String message = exc.getMessage();
        return TariffeGasHelper.handleException(codice, null, message, talkManager);
    }

    public static String handleException(DateFormat dateFormat, InvalidSequenceException exc, TalkManager talkManager) {
        String message = exc.getMessage();
        Message sentence = new Message("tariffe", message);
        sentence.addParam(exc.getKey());
        String indice = exc.getIndice();
        Date data = exc.getData();
        sentence.addParam(String.valueOf(indice) + " - " + dateFormat.format(data));
        talkManager.addSentence(sentence);
        return talkManager.getMessage(sentence);
    }

    public static String handleException(DateFormat dateFormat, MisuraGasException exc, TalkManager talkManager) {
        String message = exc.getMessage();
        String riferimento = exc.getRiferimento();
        String codicePdr = exc.getKey();
        Date data = exc.getData();
        String flusso = exc.getFlusso();
        Sentence sentence = TariffeGasHelper.handleMessage(dateFormat, message, String.valueOf(codicePdr) + " / " + riferimento, data, flusso, talkManager);
        return talkManager.getMessage(sentence);
    }

    public static Sentence handleMessage(DateFormat dateFormat, String message, String codicePdr, Date data, String flusso, TalkManager talkManager) {
        Message sentence = new Message("tariffe", message);
        sentence.addParam(codicePdr);
        sentence.addParam(dateFormat.format(data));
        sentence.addParam(flusso);
        talkManager.addSentence(sentence);
        return sentence;
    }

    public static void checkIngresso(MisuraGas misura, String azienda) throws MissingIngressoException {
        if (!misura.hasIngresso()) {
            String codicePdr = misura.getCodicePdr();
            Date dataMisura = misura.getDataMisura();
            throw new MissingIngressoException(azienda, codicePdr, dataMisura);
        }
    }

    public static void checkContinuita(Contratto contratto, MisuraGas prevMisura, MisuraGas misura) throws CounterChangedException, CoeffCorrChangedException {
        double postCoeff;
        double preCoeff;
        String matrMis = misura.getMatrMis();
        String matrConv = misura.getMatrConv();
        String matrMisPrev = prevMisura.getMatrMis();
        String matrConvPrev = prevMisura.getMatrConv();
        String codicePdr = contratto.getCodice();
        String azienda = contratto.getReseller();
        if (!(StrategyHelper.isNull(matrMis) || StrategyHelper.isNull(matrMisPrev) || matrMis.equals(matrMisPrev))) {
            Date dataMisura = misura.getDataMisura();
            String flusso = misura.getFlusso();
            throw new CounterChangedException(codicePdr, azienda, matrMisPrev, matrMis, dataMisura, flusso);
        }
        if (!(StrategyHelper.isNull(matrConv) || StrategyHelper.isNull(matrConvPrev) || matrConv.equals(matrConvPrev))) {
            Date dataMisura = misura.getDataMisura();
            String flusso = misura.getFlusso();
            throw new CounterChangedException(codicePdr, azienda, matrConvPrev, matrConv, dataMisura, flusso);
        }
        if (!misura.hasConvertitore() && !"igmg".equals(prevMisura.getFlusso()) && (preCoeff = prevMisura.getCoeffCorr()) != (postCoeff = misura.getCoeffCorr())) {
            Date preData = prevMisura.getDataMisura();
            Date postData = misura.getDataMisura();
            throw new CoeffCorrChangedException(codicePdr, azienda, preCoeff, postCoeff, preData, postData);
        }
    }

    public static void handleConsumo(Date data, double valCons, boolean convertitore, double segnanteMis, double segnanteConv, List<Consumo> consumi, String tipo, String flusso) {
        if (!TariffeGasHelper.handleSameDay(data, valCons, segnanteMis, segnanteConv, consumi)) {
            Consumo consumo = new Consumo(data, valCons, segnanteMis, segnanteConv, convertitore, tipo, flusso);
            consumi.add(consumo);
        }
    }

    private static boolean handleSameDay(Date dataMisura, double valCons, double segnanteMis, double segnanteConv, List<Consumo> consumi) {
        Consumo lastConsumo;
        Date dataLastDettaglio;
        boolean handled = false;
        if (!consumi.isEmpty() && (dataLastDettaglio = (lastConsumo = consumi.get(consumi.size() - 1)).getDataMisura()).equals(dataMisura)) {
            lastConsumo.addConsumo(valCons);
            lastConsumo.setSegnanteMis(segnanteMis);
            lastConsumo.setSegnanteConv(segnanteConv);
            handled = true;
        }
        return handled;
    }

    public static double checkGiroContatore(ContrattoGas contratto, double segnante) {
        int numCifre = contratto.getNumCifre();
        double giroContatore = Math.pow(10.0, numCifre);
        return segnante >= giroContatore ? segnante - giroContatore : segnante;
    }

    public static void removeStimate(List<MisuraGas> misure) {
        Iterator<MisuraGas> iterator = misure.iterator();
        while (iterator.hasNext()) {
            MisuraGas misura = iterator.next();
            if (!misura.isStimata()) continue;
            iterator.remove();
        }
    }

    public static TariffeContratto calcolaTariffaDefault(ContrattoGas contratto, int anno, Month mese, double valore, GasServiceStatus status) {
        String codIndEne = contratto.getCodIndiceEnergetico();
        TariffeContratto tariffeContratto = TariffeGasHelper.calcolaTariffaSpeciale(contratto, anno, mese, codIndEne, valore, false, status);
        tariffeContratto.setCodIndiceApplicato(codIndEne);
        return tariffeContratto;
    }

    public static TariffeContratto calcolaTariffaScivolo(ContrattoGas contratto, int anno, Month mese, SafeMap<String, OffertaGas> offerte, GasServiceStatus status) throws DataNotFoundException {
        String codIndEne = contratto.getCodIndiceEnergetico();
        TariffeContratto tariffeContratto = TariffeGasHelper.calcolaTariffaSpeciale(contratto, anno, mese, codIndEne, 0.0, true, status);
        String codIndiceScivolo = TariffeGasHelper.getCodIndiceScivolo(offerte, codIndEne);
        tariffeContratto.setCodIndiceApplicato(codIndiceScivolo);
        return tariffeContratto;
    }

    private static TariffeContratto calcolaTariffaSpeciale(ContrattoGas contratto, int anno, Month mese, String codIndEne, double valore, boolean scivolo, GasServiceStatus status) {
        int tipoApplicazione = contratto.getTipoApplicazione();
        Applicazione applicazione = status.getApplicazione(contratto);
        Date dataScadenza = contratto.getDataScadenza();
        TariffeContratto tariffeContratto = new TariffeContratto(contratto, anno, mese, applicazione, codIndEne, dataScadenza, false, scivolo, 0.0);
        TariffaGas tariffa = new TariffaGas(anno, mese, tipoApplicazione, null, null, valore, 0.0, 0.0, 0.0);
        tariffeContratto.add(tariffa);
        return tariffeContratto;
    }

    public static TariffeContratto calcolaTariffaScivoloFixing(ContrattoGas contratto, int anno, Month mese, GasServiceStatus status) {
        String codIndiceEnergetico = contratto.getCodIndiceEnergetico();
        int tipoApplicazione = contratto.getTipoApplicazione();
        Applicazione applicazione = status.getApplicazione(contratto);
        Date dataScadenza = contratto.getDataScadenza();
        double emtaruni = contratto.getEmtaruni();
        TariffeContratto tariffeContratto = new TariffeContratto(contratto, anno, mese, applicazione, codIndiceEnergetico, dataScadenza, false, true, 0.0);
        TariffaGas tariffa = new TariffaGas(anno, mese, tipoApplicazione, null, null, emtaruni, 0.0, 0.0, 0.0);
        tariffeContratto.add(tariffa);
        tariffeContratto.setCodIndiceApplicato(codIndiceEnergetico);
        return tariffeContratto;
    }

    public static double getPrezzoConvertito(PrezzoGas prezzo, int nCifre, ContrattoGas contratto) throws InvalidInpcsException {
        double inpcsAcquisto = contratto.getInpcsAcquisto();
        double valore = prezzo.getValore();
        if (Math.abs(inpcsAcquisto) < 1.0E-8 && valore > 1.0E-8) {
            String codicePdr = contratto.getCodice();
            String azienda = contratto.getReseller();
            Date inizio = contratto.getDataInizio();
            throw new InvalidInpcsException(azienda, codicePdr, inizio);
        }
        return MathUtils.round(valore * inpcsAcquisto / 3600.0, nCifre);
    }

    public static void applicaPenale(ContrattoGas contratto, int anno, Month mese, SafeListMap<String, PrezzoGas> prezziGas, int nCifre, TariffeContratto tariffe) throws DataNotFoundException, InvalidInpcsException {
        int tipoAppPenale = contratto.getTipoAppPenale();
        if (tipoAppPenale != 0) {
            double qtConFla = contratto.getQtConFla();
            double prezzoGiornoFlat = contratto.getEmtaruni();
            double emspreneg = contratto.getEmspreneg();
            String cdindneg = contratto.getCdindneg();
            List prezziIndice = (List)prezziGas.get(cdindneg);
            Iterator pIterator = prezziIndice.iterator();
            double valorePenale = 0.0;
            double consumoPenale = 0.0;
            ArrayList<DettaglioGiorno> dettagli = new ArrayList<DettaglioGiorno>();
            DaysOfMonthIterator dIterator = new DaysOfMonthIterator(anno, mese);
            while (dIterator.hasNext() && pIterator.hasNext()) {
                int day = dIterator.next();
                PrezzoGas prezzoGiorno = (PrezzoGas)pIterator.next();
                double prezzoGiornoReale = TariffeGasHelper.getPrezzoConvertito(prezzoGiorno, nCifre, contratto);
                Date data = CalendarTools.getDate(anno, mese, day);
                double prezzoPenaleGiorno = Math.max(0.0, prezzoGiornoFlat - prezzoGiornoReale + emspreneg);
                double valorePenaleGiorno = qtConFla * prezzoPenaleGiorno;
                Consumo consumo = new Consumo(data, qtConFla, 0.0, 0.0, false, "", "");
                DettaglioGiorno dettaglio = new DettaglioGiorno(consumo);
                dettaglio.setConsumoEfficace(qtConFla);
                dettaglio.setPrezzo(prezzoPenaleGiorno);
                dettaglio.setCosto(valorePenaleGiorno);
                dettagli.add(dettaglio);
                consumoPenale += qtConFla;
                valorePenale += valorePenaleGiorno;
            }
            TariffaGas penale = new TariffaGas(anno, mese, tipoAppPenale, dettagli, null, 0.0, consumoPenale, 0.0, valorePenale);
            tariffe.setPenale(penale);
        }
    }

    public static MisuraGas getMisuraContratto(ContrattoGas contratto, String matrConvRif, Date startDate) {
        MisuraGas misuraContratto = contratto.getMisuraGas(matrConvRif);
        Date dataMisuraContratto = misuraContratto.getDataMisura();
        Date dataInizio = contratto.getDataInizio();
        Date dataRiferimento = CalendarTools.previousDay(dataInizio);
        if (dataMisuraContratto == null || !dataMisuraContratto.before(startDate) || dataMisuraContratto.before(dataRiferimento)) {
            misuraContratto = null;
        }
        return misuraContratto;
    }

    public static void checkCoerenzaContratto(MisuraGas misuraContratto, MisuraGas misuraRiferimento, String azienda) throws CoeffCorrChangedException {
        double coeffCorrRif;
        double coeffCorrContr;
        if (misuraContratto != null && (coeffCorrContr = misuraContratto.getCoeffCorr()) != (coeffCorrRif = misuraRiferimento.getCoeffCorr())) {
            Date dataMisuraContratto = misuraContratto.getDataMisura();
            Date dataMisuraRif = misuraRiferimento.getDataMisura();
            String codicePdr = misuraContratto.getCodicePdr();
            throw new CoeffCorrChangedException(codicePdr, azienda, coeffCorrContr, coeffCorrRif, dataMisuraContratto, dataMisuraRif);
        }
    }

    public static MisuraGas updateMisuraRiferimento(MisuraGas misuraRiferimento, MisuraGas misura) {
        MisuraGas update = misuraRiferimento;
        if (misura != null && (misuraRiferimento == null || misura.compareTo(misuraRiferimento) >= 0)) {
            update = misura;
        }
        return update;
    }

    @Deprecated
    public static MisuraGas handleLetStd(ContrattoGas contratto, Date dataInizioMese, Date dataFine, Date dataUltimaLettura, String matrLett, String matrConv, double coeffCorr, TipoLettura tipoLettura, String mesLet, GasServiceStatus status, WriteLetstdGasService letstdGasWriter, boolean esportaLetture) {
        String azienda = contratto.getReseller();
        String codicePdr = contratto.getCodice();
        MisuraGas misura = null;
        double segnanteMis = 0.0;
        double segnanteConv = 0.0;
        ListWriter meseWriter = TariffeGasHelper.getListWriter(tipoLettura, azienda, dataInizioMese, status);
        String actualMesLet = dataUltimaLettura != null && !dataFine.after(dataUltimaLettura) ? "RGL" : mesLet;
        boolean convertitore = false;
        letstdGasWriter.write(meseWriter, contratto, "", dataFine, segnanteMis, segnanteConv, actualMesLet, convertitore);
        if (esportaLetture) {
            status.count(azienda, "lettura", 1);
        }
        misura = new MisuraGas("", "giada", codicePdr, dataFine, tipoLettura, matrLett, matrConv, segnanteMis, segnanteConv, coeffCorr, true, null);
        return misura;
    }

    public static MisuraGas handleLetStd(ContrattoGas contratto, Date dataInizioMese, Date dataFineTariffa, ConsumiMesePdr consumiDataPdr, boolean convertitore, double segnanteMis, double segnanteConv, TipoLettura tipoLettura, String mesLet, GasServiceStatus status, WriteLetstdGasService letstdGasWriter, boolean esportaLetture, Date dataUltimaLettura) {
        String azienda = contratto.getReseller();
        String codicePdr = contratto.getCodice();
        String matrLett = consumiDataPdr.getMatrLett();
        String matrConv = consumiDataPdr.getMatrConv();
        double coeffCorr = consumiDataPdr.getCoeffCorr();
        MisuraGas misura = null;
        if (esportaLetture) {
            ListWriter meseWriter = TariffeGasHelper.getListWriter(tipoLettura, azienda, dataInizioMese, status);
            String actualMesLet = dataUltimaLettura != null && !dataFineTariffa.after(dataUltimaLettura) ? "RGL" : mesLet;
            letstdGasWriter.write(meseWriter, contratto, "", dataFineTariffa, segnanteMis, segnanteConv, actualMesLet, convertitore);
            status.count(azienda, "lettura", 1);
        }
        misura = new MisuraGas("", "giada", codicePdr, dataFineTariffa, tipoLettura, matrLett, matrConv, segnanteMis, segnanteConv, coeffCorr, true, null);
        return misura;
    }

    public static MisuraGas handleLetStd(ContrattoGas contratto, Date dataInizioMese, Date dataFineTariffa, ConsumiMesePdr consumiDataPdr, Consumo lastConsumo, TipoLettura tipoLettura, String mesLet, GasServiceStatus status, WriteLetstdGasService letstdGasWriter, boolean esportaLetture, Date dataUltimaLettura) {
        boolean convertitore = lastConsumo.isConvertitore();
        double segnanteMis = lastConsumo.getSegnanteMisuratore();
        double segnanteConv = lastConsumo.getSegnanteConvertitore();
        String fixMesLet = mesLet == null ? lastConsumo.getFlusso() : mesLet;
        return TariffeGasHelper.handleLetStd(contratto, dataInizioMese, dataFineTariffa, consumiDataPdr, convertitore, segnanteMis, segnanteConv, tipoLettura, fixMesLet, status, letstdGasWriter, esportaLetture, dataUltimaLettura);
    }

    public static DataNotFoundException getGlobalError(int anno, Month mese, Iterable<ContrattoGas> contrattiPdr, GasServiceStatus status, BasicMisureDao misureDao) {
        DataNotFoundException globalError = null;
        Iterator<ContrattoGas> iterator = contrattiPdr.iterator();
        while (globalError == null && iterator.hasNext()) {
            List<Applicazione> subapplicazioni;
            ContrattoGas contratto = iterator.next();
            Applicazione applicazione = status.getApplicazione(contratto);
            TipoFlat tipoFlat = applicazione.getTipoFlat();
            if (tipoFlat.isMissingSbil(contratto)) {
                globalError = TariffeGasHelper.buildGlobalError(ErroreElaborazioneGas.MISSING_SBIL, 0);
            }
            if (!tipoFlat.isFixing() || !(subapplicazioni = TariffeCommonHelper.getSubapplicazioni(applicazione, anno, mese, status, misureDao)).isEmpty()) continue;
            int idTipoApp = applicazione.getTipo();
            globalError = TariffeGasHelper.buildGlobalError(ErroreElaborazioneGas.SUBAPP_NOTFOUND, idTipoApp);
        }
        return globalError;
    }

    private static DataNotFoundException buildGlobalError(ErroreElaborazioneGas error, int key) {
        String messaggio = error.getMessage();
        int ordinal = error.ordinal();
        return new DataNotFoundException(messaggio, key, ordinal);
    }
}

