/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.checkconsumi;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.services.GasStrategiesManager;
import biz.elabor.prebilling.gas.services.checkconsumi.CheckConsumiDirettiGasStrategy;
import biz.elabor.prebilling.gas.services.common.CheckGasStatusStrategy;
import biz.elabor.prebilling.gas.services.common.FileCopyStrategy;
import biz.elabor.prebilling.gas.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.gas.services.tariffe.ExportLettureStrategy;
import biz.elabor.prebilling.gas.services.tariffe.ExportTariffeStrategy;
import biz.elabor.prebilling.gas.services.tariffe.GetSpreadStrategy;
import biz.elabor.prebilling.gas.services.tariffe.RecordStatoTariffeStrategy;
import biz.elabor.prebilling.gas.web.AbstractGasStrategiesHandler;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class CheckConsumiGasStrategiesHandler
extends AbstractGasStrategiesHandler {
    private final Date inizio;
    private final Date fine;
    private final List<String> pdrs;
    private final boolean tariffa;
    private final boolean lettura;
    private final boolean pcs;
    private final String target;

    public CheckConsumiGasStrategiesHandler(Date inizio, Date fine, List<String> pdrs, String target, boolean tariffa, boolean lettura, boolean pcs, ConfigurationGasInstance instance, TalkManager talkManager) {
        super(instance, talkManager);
        this.inizio = inizio;
        this.fine = fine;
        this.pdrs = pdrs;
        this.tariffa = tariffa;
        this.lettura = lettura;
        this.pcs = pcs;
        this.target = target;
    }

    @Override
    public GasStrategiesManager buildStrategiesManager() {
        GasStrategiesManager manager = new GasStrategiesManager(this.configuration);
        manager.addStrategy(new CheckGasStatusStrategy(Funzionalita.CHECK_CONSUMI, "*", "check", this.configuration, this.misureDao, this.talkManager));
        manager.addStrategy(new GetSpreadStrategy(this.misureDao));
        manager.addStrategy(new CheckConsumiDirettiGasStrategy(this.inizio, this.fine, this.pdrs, this.target, this.tariffa, this.lettura, this.pcs, this.misureDao, this.giadaDao, this.configuration, this.talkManager));
        manager.addStrategy(new ExportTariffeStrategy(Funzionalita.CHECK_CONSUMI, this.configuration));
        manager.addStrategy(new ExportLettureStrategy(this.configuration, Funzionalita.CHECK_CONSUMI));
        manager.addStrategy(new RecordStatoTariffeStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.CHECK_CONSUMI, "*", TipoStato.COPIA_FILE, this.misureDao, this.configuration));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.CHECK_CONSUMI, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.CHECK_CONSUMI, "*", TipoStato.NO_ESECUZIONE, this.misureDao, this.configuration));
        return manager;
    }
}

