/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.consumi;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.services.GasStrategiesManager;
import biz.elabor.prebilling.gas.services.common.CheckGasStatusStrategy;
import biz.elabor.prebilling.gas.services.common.FileCopyStrategy;
import biz.elabor.prebilling.gas.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.gas.services.tariffe.DownloadDirettiGas;
import biz.elabor.prebilling.gas.web.AbstractGasStrategiesHandler;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ConsumiGasStrategiesHandler
extends AbstractGasStrategiesHandler {
    private final int anno;
    private final Month mese;

    public ConsumiGasStrategiesHandler(int anno, Month mese, ConfigurationGasInstance instanceConfiguration, TalkManager talkManager) {
        super(instanceConfiguration, talkManager);
        this.anno = anno;
        this.mese = mese;
    }

    @Override
    public GasStrategiesManager buildStrategiesManager() {
        GasStrategiesManager manager = new GasStrategiesManager(this.configuration);
        manager.addStrategy(new CheckGasStatusStrategy(Funzionalita.DWNL_CONSUMI_GAS, "*", "check", this.configuration, this.misureDao, this.talkManager));
        manager.addStrategy(new DownloadDirettiGas(this.anno, this.mese, this.misureDao, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.DWNL_CONSUMI_GAS, "*", TipoStato.COPIA_FILE, this.misureDao, this.configuration));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.DWNL_CONSUMI_GAS, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.DWNL_CONSUMI_GAS, "*", TipoStato.NO_ESECUZIONE, this.misureDao, this.configuration));
        return manager;
    }
}

