/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.prezzi;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.services.GasStrategiesManager;
import biz.elabor.prebilling.gas.services.common.CheckGasStatusStrategy;
import biz.elabor.prebilling.gas.services.common.FileCopyStrategy;
import biz.elabor.prebilling.gas.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.gas.services.tariffe.DownloadPrezziGasPeriodo;
import biz.elabor.prebilling.gas.web.AbstractGasStrategiesHandler;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class PrezziGasStrategiesHandler
extends AbstractGasStrategiesHandler {
    private final int annoInizio;
    private final Month meseInizio;
    private final int annoFine;
    private final Month meseFine;
    private final String indice;
    private final boolean bloccoIndice;

    public PrezziGasStrategiesHandler(int annoInizio, Month meseInizio, int annoFine, Month meseFine, String indice, boolean bloccoIndice, ConfigurationGasInstance InstanceConfiguration, TalkManager talkManager) {
        super(InstanceConfiguration, talkManager);
        this.annoInizio = annoInizio;
        this.meseInizio = meseInizio;
        this.annoFine = annoFine;
        this.meseFine = meseFine;
        this.indice = indice;
        this.bloccoIndice = bloccoIndice;
    }

    @Override
    public GasStrategiesManager buildStrategiesManager() {
        GasStrategiesManager manager = new GasStrategiesManager(this.configuration);
        manager.addStrategy(new CheckGasStatusStrategy(Funzionalita.DWNL_PREZZI_GAS, "*", "check", this.configuration, this.misureDao, this.talkManager));
        manager.addStrategy(new DownloadPrezziGasPeriodo(this.annoInizio, this.meseInizio, this.annoFine, this.meseFine, this.indice, this.bloccoIndice, this.misureDao, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.DWNL_PREZZI_GAS, "*", TipoStato.COPIA_FILE, this.misureDao, this.configuration));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.DWNL_PREZZI_GAS, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.DWNL_PREZZI_GAS, "*", TipoStato.NO_ESECUZIONE, this.misureDao, this.configuration));
        return manager;
    }
}

