/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.ricalcolotariffe;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.services.GasStrategiesManager;
import biz.elabor.prebilling.gas.services.common.CheckGasStatusStrategy;
import biz.elabor.prebilling.gas.services.common.FileCopyStrategy;
import biz.elabor.prebilling.gas.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.gas.services.tariffe.DownloadDirettiGas;
import biz.elabor.prebilling.gas.services.tariffe.DownloadPrezziGas;
import biz.elabor.prebilling.gas.services.tariffe.ExportLettureStrategy;
import biz.elabor.prebilling.gas.services.tariffe.ExportTariffeStrategy;
import biz.elabor.prebilling.gas.services.tariffe.GetSpreadStrategy;
import biz.elabor.prebilling.gas.services.tariffe.RecordStatoTariffeStrategy;
import biz.elabor.prebilling.gas.services.tariffe.RicalcoloTariffeStrategy;
import biz.elabor.prebilling.gas.web.AbstractGasStrategiesHandler;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class RicalcoloTariffeGasStrategiesHandler
extends AbstractGasStrategiesHandler {
    private static final List<Funzionalita> FUNZIONALITA = Arrays.asList(Funzionalita.RICALCOLOTARIFFE_GAS, Funzionalita.TARIFFE_GAS);
    private final Date dataInizio;
    private final Date datafine;
    private final List<String> pdrs;
    private String reseller;
    private final boolean scivoloEnabled;
    private final boolean forceSopraSoglia;
    private final boolean esportaLetture;
    private final boolean bloccoIndice;

    public RicalcoloTariffeGasStrategiesHandler(Date dataInizio, Date datafine, List<String> pdrs, String reseller, boolean scivoloEnabled, boolean forceSopraSoglia, boolean esportaLetture, boolean bloccoIndice, ConfigurationGasInstance configurationInstance, TalkManager talkManager) {
        super(configurationInstance, talkManager);
        this.dataInizio = dataInizio;
        this.datafine = datafine;
        this.pdrs = pdrs;
        this.reseller = reseller;
        this.scivoloEnabled = scivoloEnabled;
        this.esportaLetture = esportaLetture;
        this.bloccoIndice = bloccoIndice;
        this.forceSopraSoglia = forceSopraSoglia;
    }

    @Override
    public GasStrategiesManager buildStrategiesManager() {
        GasStrategiesManager manager = new GasStrategiesManager(this.configuration);
        manager.addStrategy(new CheckGasStatusStrategy(FUNZIONALITA, "*", "check", this.configuration, this.misureDao, this.talkManager));
        ElaborCalendar calendarInizio = new ElaborCalendar(this.dataInizio);
        ElaborCalendar calendarFine = new ElaborCalendar(this.datafine);
        calendarInizio.resetTime();
        calendarFine.resetTime();
        while (!calendarInizio.after(calendarFine)) {
            for (String pdr : this.pdrs) {
                int anno = calendarInizio.getAnno();
                Month mese = calendarInizio.getMese();
                manager.addStrategy(new DownloadPrezziGas(anno, mese, this.bloccoIndice, this.misureDao, this.configuration, this.talkManager));
                manager.addStrategy(new DownloadDirettiGas(anno, mese, this.misureDao, this.configuration, this.talkManager));
                manager.addStrategy(new GetSpreadStrategy(this.misureDao));
                manager.addStrategy(new RicalcoloTariffeStrategy(anno, mese, this.misureDao, pdr, this.reseller, this.scivoloEnabled, this.forceSopraSoglia, this.esportaLetture, this.bloccoIndice, this.giadaDao, this.configuration, this.talkManager));
            }
            calendarInizio.addMesi(1);
        }
        manager.addStrategy(new ExportTariffeStrategy(Funzionalita.RICALCOLOTARIFFE_GAS, this.configuration));
        if (this.esportaLetture) {
            manager.addStrategy(new ExportLettureStrategy(this.configuration, Funzionalita.RICALCOLOTARIFFE_GAS));
        }
        manager.addStrategy(new RecordStatoTariffeStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.RICALCOLOTARIFFE_GAS, "*", TipoStato.COPIA_FILE, this.misureDao, this.configuration));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.RICALCOLOTARIFFE_GAS, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.RICALCOLOTARIFFE_GAS, "*", TipoStato.NO_ESECUZIONE, this.misureDao, this.configuration));
        return manager;
    }
}

