/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.tariffe;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.services.GasStrategiesManager;
import biz.elabor.prebilling.gas.services.common.CheckGasStatusStrategy;
import biz.elabor.prebilling.gas.services.common.FileCopyStrategy;
import biz.elabor.prebilling.gas.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.gas.services.tariffe.CalcolaTariffeStrategy;
import biz.elabor.prebilling.gas.services.tariffe.DownloadDirettiGas;
import biz.elabor.prebilling.gas.services.tariffe.DownloadPrezziGas;
import biz.elabor.prebilling.gas.services.tariffe.ExportLettureStrategy;
import biz.elabor.prebilling.gas.services.tariffe.ExportTariffeStrategy;
import biz.elabor.prebilling.gas.services.tariffe.GetSpreadStrategy;
import biz.elabor.prebilling.gas.services.tariffe.RecordStatoTariffeStrategy;
import biz.elabor.prebilling.gas.web.AbstractGasStrategiesHandler;
import java.util.Arrays;
import java.util.List;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class TariffeGasStrategiesHandler
extends AbstractGasStrategiesHandler {
    private static final List<Funzionalita> FUNZIONALITA = Arrays.asList(Funzionalita.TARIFFE_GAS, Funzionalita.RICALCOLOTARIFFE_GAS);
    private final int anno;
    private final Month mese;
    private final String reseller;
    private final String onlyPdr;
    private final boolean scivoloEnabled;
    private final boolean forceSopraSoglia;
    private final boolean bloccoIndice;

    public TariffeGasStrategiesHandler(int anno, Month mese, String reseller, String onlyPdr, boolean scivoloEnabled, boolean forceSopraSoglia, boolean bloccoIndice, ConfigurationGasInstance instanceConfiguration, TalkManager talkManager) {
        super(instanceConfiguration, talkManager);
        this.anno = anno;
        this.mese = mese;
        this.reseller = reseller;
        this.onlyPdr = onlyPdr;
        this.scivoloEnabled = scivoloEnabled;
        this.bloccoIndice = bloccoIndice;
        this.forceSopraSoglia = forceSopraSoglia;
    }

    @Override
    public GasStrategiesManager buildStrategiesManager() {
        GasStrategiesManager manager = new GasStrategiesManager(this.configuration);
        manager.addStrategy(new CheckGasStatusStrategy(FUNZIONALITA, this.reseller, "check", this.configuration, this.misureDao, this.talkManager));
        manager.addStrategy(new DownloadPrezziGas(this.anno, this.mese, this.bloccoIndice, this.misureDao, this.configuration, this.talkManager));
        manager.addStrategy(new DownloadDirettiGas(this.anno, this.mese, this.misureDao, this.configuration, this.talkManager));
        manager.addStrategy(new GetSpreadStrategy(this.misureDao));
        manager.addStrategy(new CalcolaTariffeStrategy(this.anno, this.mese, this.reseller, this.misureDao, this.onlyPdr, this.scivoloEnabled, this.forceSopraSoglia, this.bloccoIndice, this.giadaDao, this.configuration, this.talkManager));
        manager.addStrategy(new ExportTariffeStrategy(Funzionalita.TARIFFE_GAS, this.configuration));
        manager.addStrategy(new ExportLettureStrategy(this.configuration, Funzionalita.TARIFFE_GAS));
        manager.addStrategy(new RecordStatoTariffeStrategy(this.misureDao, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.TARIFFE_GAS, this.reseller, TipoStato.COPIA_FILE, this.misureDao, this.configuration));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.TARIFFE_GAS, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.TARIFFE_GAS, this.reseller, TipoStato.NO_ESECUZIONE, this.misureDao, this.configuration));
        return manager;
    }
}

