/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.BinaryCurveApproximationAlgorithm;
import com.graphbuilder.curve.ControlPath;
import com.graphbuilder.curve.GroupIterator;
import com.graphbuilder.curve.MultiPath;
import com.graphbuilder.curve.ParametricCurve;
import com.graphbuilder.math.PascalsTriangle;

public class BezierCurve
extends ParametricCurve {
    private static final ThreadLocal<SharedData> SHARED_DATA = new ThreadLocal<SharedData>(){

        @Override
        protected SharedData initialValue() {
            return new SharedData();
        }
    };
    private final SharedData sharedData = SHARED_DATA.get();
    private final PascalsTriangle pascalsTriangle = new PascalsTriangle();
    private double t_min = 0.0;
    private double t_max = 1.0;
    private int sampleLimit = 1;

    public BezierCurve(ControlPath cp, GroupIterator gi) {
        super(cp, gi);
    }

    public void eval(double[] p2) {
        int i2;
        double t = p2[p2.length - 1];
        int numPts = this.gi.getGroupSize();
        if (numPts > this.sharedData.a.length) {
            SharedData.access$102(this.sharedData, new double[2 * numPts]);
        }
        ((SharedData)this.sharedData).a[numPts - 1] = 1.0;
        double b2 = 1.0;
        double one_minus_t = 1.0 - t;
        for (i2 = numPts - 2; i2 >= 0; --i2) {
            ((SharedData)this.sharedData).a[i2] = this.sharedData.a[i2 + 1] * one_minus_t;
        }
        this.gi.set(0, 0);
        for (i2 = 0; i2 < numPts; ++i2) {
            double pt = this.pascalsTriangle.nCr(numPts - 1, i2);
            if (!Double.isInfinite(pt) && !Double.isNaN(pt)) {
                double gravity = this.sharedData.a[i2] * b2 * pt;
                double[] d2 = this.cp.getPoint(this.gi.next()).getLocation();
                for (int j2 = 0; j2 < p2.length - 1; ++j2) {
                    p2[j2] = p2[j2] + d2[j2] * gravity;
                }
            }
            b2 *= t;
        }
    }

    public int getSampleLimit() {
        return this.sampleLimit;
    }

    public void setSampleLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Sample-limit >= 0 required.");
        }
        this.sampleLimit = limit;
    }

    public void setInterval(double t_min, double t_max) {
        if (t_min > t_max) {
            throw new IllegalArgumentException("t_min <= t_max required.");
        }
        this.t_min = t_min;
        this.t_max = t_max;
    }

    public double t_min() {
        return this.t_min;
    }

    public double t_max() {
        return this.t_max;
    }

    public void appendTo(MultiPath mp) {
        if (!this.gi.isInRange(0, this.cp.numPoints())) {
            throw new IllegalArgumentException("group iterator not in range");
        }
        int n2 = mp.getDimension();
        double[] d2 = new double[n2 + 1];
        d2[n2] = this.t_min;
        this.eval(d2);
        if (this.connect) {
            mp.lineTo(d2);
        } else {
            mp.moveTo(d2);
        }
        BinaryCurveApproximationAlgorithm.genPts(this, this.t_min, this.t_max, mp);
    }

    public void resetMemory() {
        if (this.sharedData.a.length > 0) {
            SharedData.access$102(this.sharedData, new double[0]);
        }
    }

    private static class SharedData {
        private double[] a = new double[0];

        private SharedData() {
        }

        static /* synthetic */ double[] access$102(SharedData x0, double[] x1) {
            x0.a = x1;
            return x1;
        }
    }
}

