/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.geom.Geom;

public class MultiPath {
    public static final Object MOVE_TO = new Object();
    public static final Object LINE_TO = new Object();
    private double[][] point = new double[2][0];
    private Object[] type = new Object[this.point.length];
    private int size = 0;
    private double flatness = 1.0;
    private final int dimension;

    public MultiPath(int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException("dimension > 0 required");
        }
        this.dimension = dimension;
    }

    public int getDimension() {
        return this.dimension;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public void setFlatness(double f2) {
        if (f2 <= 0.0) {
            throw new IllegalArgumentException("flatness > 0 required");
        }
        this.flatness = f2;
    }

    public double[] get(int index) {
        return this.point[index];
    }

    public void set(int index, double[] p2) {
        if (p2 == null) {
            throw new IllegalArgumentException("Point cannot be null.");
        }
        if (p2.length < this.dimension) {
            throw new IllegalArgumentException("p.length >= dimension required");
        }
        if (this.point[index] == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.point[index] = p2;
    }

    public Object getType(int index) {
        if (this.type[index] == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.type[index];
    }

    public void setType(int index, Object type) {
        if (type != MOVE_TO && type != LINE_TO) {
            throw new IllegalArgumentException("unknown type");
        }
        if (this.type[index] == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index == 0 && type != MOVE_TO) {
            throw new IllegalArgumentException("type[0] must always be MOVE_TO");
        }
        this.type[index] = type;
    }

    public int getNumPoints() {
        return this.size;
    }

    public void setNumPoints(int n2) {
        if (n2 != 0 && this.point[n2 - 1] == null) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.size = n2;
    }

    public int getCapacity() {
        return this.point.length;
    }

    public void ensureCapacity(int capacity) {
        if (this.point.length < capacity) {
            int x = 2 * this.point.length;
            if (x < capacity) {
                x = capacity;
            }
            double[][] p2 = new double[x][];
            for (int i2 = 0; i2 < this.size; ++i2) {
                p2[i2] = this.point[i2];
            }
            Object[] t2 = new Object[x];
            for (int i3 = 0; i3 < this.size; ++i3) {
                t2[i3] = this.type[i3];
            }
            this.point = p2;
            this.type = t2;
        }
    }

    public void trimArray() {
        if (this.size < this.point.length) {
            double[][] p2 = new double[this.size][];
            for (int i2 = 0; i2 < this.size; ++i2) {
                p2[i2] = this.point[i2];
            }
            Object[] t2 = new Object[this.size];
            for (int i3 = 0; i3 < this.size; ++i3) {
                t2[i3] = this.type[i3];
            }
            this.point = p2;
            this.type = t2;
        }
    }

    public void lineTo(double[] p2) {
        this.append(p2, LINE_TO);
    }

    public void moveTo(double[] p2) {
        this.append(p2, MOVE_TO);
    }

    private void append(double[] p2, Object t) {
        if (p2 == null) {
            throw new IllegalArgumentException("Point cannot be null.");
        }
        if (p2.length < this.dimension) {
            throw new IllegalArgumentException("p.length >= dimension required");
        }
        if (this.size == 0) {
            t = MOVE_TO;
        }
        this.ensureCapacity(this.size + 1);
        this.point[this.size] = p2;
        this.type[this.size] = t;
        ++this.size;
    }

    public double getDistSq(double[] p2) {
        if (p2 == null) {
            throw new IllegalArgumentException("Point cannot be null.");
        }
        if (p2.length < this.dimension) {
            throw new IllegalArgumentException("p.length >= dimension required");
        }
        int n2 = this.getNumPoints();
        if (n2 == 0) {
            return Double.MAX_VALUE;
        }
        double dist = Double.MAX_VALUE;
        double[] b2 = this.get(0);
        double[] c2 = new double[this.dimension + 1];
        for (int i2 = 1; i2 < n2; ++i2) {
            double d2;
            double[] a2 = this.get(i2);
            if (this.getType(i2) != LINE_TO || !((d2 = Geom.ptSegDistSq(a2, b2, p2, c2, this.dimension)) < dist)) continue;
            dist = d2;
        }
        return dist;
    }
}

