/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataTypes;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.Table;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Database {
    private static final Log LOG = LogFactory.getLog(Database.class);
    private static final byte[] SID = new byte[2];
    private static final int COPY_TABLE_BATCH_SIZE = 200;
    private static final int PAGE_SYSTEM_CATALOG = 2;
    private static final Integer ACM;
    private static final short USAGE_MAP_DEF_FREE_SPACE = 3940;
    private static final String COL_ACM = "ACM";
    private static final String COL_DATE_CREATE = "DateCreate";
    private static final String COL_DATE_UPDATE = "DateUpdate";
    private static final String COL_F_INHERITABLE = "FInheritable";
    private static final String COL_FLAGS = "Flags";
    private static final String COL_ID = "Id";
    private static final String COL_NAME = "Name";
    private static final String COL_OBJECT_ID = "ObjectId";
    private static final String COL_OWNER = "Owner";
    private static final String COL_PARENT_ID = "ParentId";
    private static final String COL_SID = "SID";
    private static final String COL_TYPE = "Type";
    private static final String EMPTY_MDB = "com/healthmarketscience/jackcess/empty.mdb";
    private static final String ESCAPE_PREFIX = "x";
    private static final String PREFIX_SYSTEM = "MSys";
    private static final String SYSTEM_OBJECT_NAME_TABLES = "Tables";
    private static final String TABLE_SYSTEM_ACES = "MSysACEs";
    private static final Short TYPE_TABLE;
    private static final Set RESERVED_WORDS;
    private ByteBuffer _buffer;
    private Integer _tableParentId;
    private JetFormat _format;
    private Map _tables = new HashMap();
    private PageChannel _pageChannel;
    private Table _systemCatalog;
    private Table _accessControlEntries;

    public static Database open(File mdbFile) throws IOException {
        return new Database(Database.openChannel(mdbFile));
    }

    public static Database create(File mdbFile) throws IOException {
        FileChannel channel = Database.openChannel(mdbFile);
        channel.transferFrom(Channels.newChannel(Thread.currentThread().getContextClassLoader().getResourceAsStream(EMPTY_MDB)), 0L, Integer.MAX_VALUE);
        return new Database(channel);
    }

    private static FileChannel openChannel(File mdbFile) throws FileNotFoundException {
        return new RandomAccessFile(mdbFile, "rw").getChannel();
    }

    protected Database(FileChannel channel) throws IOException {
        this._format = JetFormat.getFormat(channel);
        this._pageChannel = new PageChannel(channel, this._format);
        this._buffer = this._pageChannel.createPageBuffer();
        this.readSystemCatalog();
    }

    public PageChannel getPageChannel() {
        return this._pageChannel;
    }

    public Table getSystemCatalog() {
        return this._systemCatalog;
    }

    public Table getAccessControlEntries() {
        return this._accessControlEntries;
    }

    private void readSystemCatalog() throws IOException {
        Map row;
        this._pageChannel.readPage(this._buffer, 2);
        byte pageType = this._buffer.get();
        if (pageType != 2) {
            throw new IOException("Looking for system catalog at page 2, but page type is " + pageType);
        }
        this._systemCatalog = new Table(this._buffer, this._pageChannel, this._format, 2);
        while ((row = this._systemCatalog.getNextRow(Arrays.asList(COL_NAME, COL_TYPE, COL_ID))) != null) {
            String name = (String)row.get(COL_NAME);
            if (name != null && TYPE_TABLE.equals(row.get(COL_TYPE))) {
                if (!name.startsWith(PREFIX_SYSTEM)) {
                    this._tables.put(row.get(COL_NAME), row.get(COL_ID));
                    continue;
                }
                if (!TABLE_SYSTEM_ACES.equals(name)) continue;
                this.readAccessControlEntries((Integer)row.get(COL_ID));
                continue;
            }
            if (!SYSTEM_OBJECT_NAME_TABLES.equals(name)) continue;
            this._tableParentId = (Integer)row.get(COL_ID);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished reading system catalog.  Tables: " + this._tables);
        }
    }

    private void readAccessControlEntries(int pageNum) throws IOException {
        ByteBuffer buffer = this._pageChannel.createPageBuffer();
        this._pageChannel.readPage(buffer, pageNum);
        byte pageType = buffer.get();
        if (pageType != 2) {
            throw new IOException("Looking for MSysACEs at page " + pageNum + ", but page type is " + pageType);
        }
        this._accessControlEntries = new Table(buffer, this._pageChannel, this._format, pageNum);
    }

    public Set getTableNames() {
        return this._tables.keySet();
    }

    public Table getTable(String name) throws IOException {
        Integer pageNumber = (Integer)this._tables.get(name);
        if (pageNumber == null) {
            pageNumber = (Integer)this._tables.get(Character.toUpperCase(name.charAt(0)) + name.substring(1));
        }
        if (pageNumber == null) {
            return null;
        }
        this._pageChannel.readPage(this._buffer, pageNumber);
        return new Table(this._buffer, this._pageChannel, this._format, pageNumber);
    }

    public void createTable(String name, List columns) throws IOException {
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        int pageNumber = this._pageChannel.getPageCount();
        ByteBuffer buffer = this._pageChannel.createPageBuffer();
        this.writeTableDefinition(buffer, columns, pageNumber);
        this.writeColumnDefinitions(buffer, columns);
        buffer.put((byte)-1);
        buffer.put((byte)-1);
        buffer.putInt(8, buffer.position());
        this._pageChannel.writeNewPage(buffer);
        this._pageChannel.writeNewPage(this.createUsageMapDefinitionBuffer(pageNumber));
        this._pageChannel.writeNewPage(this.createUsageMapDataBuffer());
        this._tables.put(name, new Integer(pageNumber));
        this.addToSystemCatalog(name, pageNumber);
        this.addToAccessControlEntries(pageNumber);
    }

    private void writeTableDefinition(ByteBuffer buffer, List columns, int pageNumber) throws IOException {
        buffer.put((byte)2);
        buffer.put((byte)1);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.put((byte)89);
        buffer.put((byte)6);
        buffer.putShort((short)0);
        buffer.putInt(0);
        buffer.putInt(0);
        for (int i2 = 0; i2 < 16; ++i2) {
            buffer.put((byte)0);
        }
        buffer.put((byte)78);
        buffer.putShort((short)columns.size());
        buffer.putShort(Column.countVariableLength(columns));
        buffer.putShort((short)columns.size());
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.put((byte)0);
        int usageMapPage = pageNumber + 1;
        buffer.put(ByteUtil.to3ByteInt(usageMapPage));
        buffer.put((byte)1);
        buffer.put(ByteUtil.to3ByteInt(usageMapPage));
        if (LOG.isDebugEnabled()) {
            int position = buffer.position();
            buffer.rewind();
            LOG.debug("Creating new table def block:\n" + ByteUtil.toHexString(buffer, this._format.SIZE_TDEF_BLOCK));
            buffer.position(position);
        }
    }

    private void writeColumnDefinitions(ByteBuffer buffer, List columns) throws IOException {
        short columnNumber = 0;
        short fixedOffset = 0;
        short variableOffset = 0;
        for (Column col : columns) {
            int position = buffer.position();
            buffer.put(col.getType());
            buffer.put((byte)89);
            buffer.put((byte)6);
            buffer.putShort((short)0);
            buffer.putShort(columnNumber);
            if (col.isVariableLength()) {
                short s2 = variableOffset;
                variableOffset = (short)(variableOffset + 1);
                buffer.putShort(s2);
            } else {
                buffer.putShort((short)0);
            }
            buffer.putShort(columnNumber);
            buffer.put((byte)9);
            buffer.put((byte)4);
            buffer.putShort((short)0);
            if (col.isVariableLength()) {
                buffer.put((byte)2);
            } else {
                buffer.put((byte)3);
            }
            if (col.isCompressedUnicode()) {
                buffer.put((byte)1);
            } else {
                buffer.put((byte)0);
            }
            buffer.putInt(0);
            if (col.isVariableLength()) {
                buffer.putShort((short)0);
            } else {
                buffer.putShort(fixedOffset);
                fixedOffset = (short)(fixedOffset + col.size());
            }
            buffer.putShort(col.getLength());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating new column def block\n" + ByteUtil.toHexString(buffer, position, this._format.SIZE_COLUMN_DEF_BLOCK));
            }
            columnNumber = (short)(columnNumber + 1);
        }
        for (Column col : columns) {
            ByteBuffer colName = this._format.CHARSET.encode(col.getName());
            buffer.putShort((short)colName.remaining());
            buffer.put(colName);
        }
    }

    private ByteBuffer createUsageMapDefinitionBuffer(int pageNumber) throws IOException {
        ByteBuffer rtn = this._pageChannel.createPageBuffer();
        rtn.put((byte)1);
        rtn.put((byte)1);
        rtn.putShort((short)3940);
        rtn.putInt(0);
        rtn.putInt(0);
        rtn.putShort((short)2);
        rtn.putShort((short)this._format.OFFSET_USED_PAGES_USAGE_MAP_DEF);
        rtn.putShort((short)this._format.OFFSET_FREE_PAGES_USAGE_MAP_DEF);
        rtn.position(this._format.OFFSET_USED_PAGES_USAGE_MAP_DEF);
        rtn.put((byte)1);
        rtn.putInt(pageNumber + 2);
        rtn.position(this._format.OFFSET_FREE_PAGES_USAGE_MAP_DEF);
        rtn.put((byte)0);
        return rtn;
    }

    private ByteBuffer createUsageMapDataBuffer() throws IOException {
        ByteBuffer rtn = this._pageChannel.createPageBuffer();
        rtn.put((byte)5);
        rtn.put((byte)1);
        rtn.putShort((short)0);
        return rtn;
    }

    private void addToSystemCatalog(String name, int pageNumber) throws IOException {
        Object[] catalogRow = new Object[this._systemCatalog.getColumns().size()];
        int idx = 0;
        for (Column col : this._systemCatalog.getColumns()) {
            if (COL_ID.equals(col.getName())) {
                catalogRow[idx] = new Integer(pageNumber);
            } else if (COL_NAME.equals(col.getName())) {
                catalogRow[idx] = name;
            } else if (COL_TYPE.equals(col.getName())) {
                catalogRow[idx] = TYPE_TABLE;
            } else if (COL_DATE_CREATE.equals(col.getName()) || COL_DATE_UPDATE.equals(col.getName())) {
                catalogRow[idx] = new Date();
            } else if (COL_PARENT_ID.equals(col.getName())) {
                catalogRow[idx] = this._tableParentId;
            } else if (COL_FLAGS.equals(col.getName())) {
                catalogRow[idx] = new Integer(0);
            } else if (COL_OWNER.equals(col.getName())) {
                byte[] owner = new byte[2];
                catalogRow[idx] = owner;
                owner[0] = -49;
                owner[1] = 95;
            }
            ++idx;
        }
        this._systemCatalog.addRow(catalogRow);
    }

    private void addToAccessControlEntries(int pageNumber) throws IOException {
        Object[] aceRow = new Object[this._accessControlEntries.getColumns().size()];
        int idx = 0;
        for (Column col : this._accessControlEntries.getColumns()) {
            if (col.getName().equals(COL_ACM)) {
                aceRow[idx] = ACM;
            } else if (col.getName().equals(COL_F_INHERITABLE)) {
                aceRow[idx] = Boolean.FALSE;
            } else if (col.getName().equals(COL_OBJECT_ID)) {
                aceRow[idx] = new Integer(pageNumber);
            } else if (col.getName().equals(COL_SID)) {
                aceRow[idx] = SID;
            }
            ++idx;
        }
        this._accessControlEntries.addRow(aceRow);
    }

    public void copyTable(String name, ResultSet source) throws SQLException, IOException {
        ResultSetMetaData md = source.getMetaData();
        LinkedList<Column> columns = new LinkedList<Column>();
        int textCount = 0;
        int totalSize = 0;
        block5: for (int i2 = 1; i2 <= md.getColumnCount(); ++i2) {
            switch (md.getColumnType(i2)) {
                case 4: 
                case 6: {
                    totalSize += 4;
                    continue block5;
                }
                case 8: 
                case 91: {
                    totalSize += 8;
                    continue block5;
                }
                case 12: {
                    ++textCount;
                }
            }
        }
        short textSize = 0;
        if (textCount > 0) {
            textSize = (short)((1900 - totalSize) / textCount);
            if (textSize > 510) {
                textSize = (short)510;
            }
        }
        for (int i3 = 1; i3 <= md.getColumnCount(); ++i3) {
            Column column = new Column();
            column.setName(this.escape(md.getColumnName(i3)));
            column.setType(DataTypes.fromSQLType(md.getColumnType(i3)));
            if (column.getType() == 10) {
                column.setLength(textSize);
            }
            columns.add(column);
        }
        this.createTable(this.escape(name), columns);
        Table table = this.getTable(this.escape(name));
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (source.next()) {
            Object[] row = new Object[md.getColumnCount()];
            for (int i4 = 0; i4 < row.length; ++i4) {
                row[i4] = source.getObject(i4 + 1);
            }
            rows.add(row);
            if (rows.size() != 200) continue;
            table.addRows(rows);
            rows.clear();
        }
        if (rows.size() > 0) {
            table.addRows(rows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(String name, File f2, String delim) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f2));
            this.importReader(name, in, delim);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOG.warn("Could not close file " + f2.getAbsolutePath(), ex);
                }
            }
        }
    }

    public void importReader(String name, BufferedReader in, String delim) throws IOException {
        String line = in.readLine();
        if (line == null || line.trim().length() == 0) {
            return;
        }
        String tableName = this.escape(name);
        int counter = 0;
        while (this.getTable(tableName) != null) {
            tableName = this.escape(name + counter++);
        }
        LinkedList<Column> columns = new LinkedList<Column>();
        String[] columnNames = line.split(delim);
        short textSize = (short)(1900 / columnNames.length);
        if (textSize > 510) {
            textSize = 510;
        }
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            Column column = new Column();
            column.setName(this.escape(columnNames[i2]));
            column.setType((byte)10);
            column.setLength(textSize);
            columns.add(column);
        }
        this.createTable(tableName, columns);
        Table table = this.getTable(tableName);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        while ((line = in.readLine()) != null) {
            String[] data = new String[columnNames.length];
            String[] splitData = line.split(delim);
            System.arraycopy(splitData, 0, data, 0, splitData.length);
            rows.add(data);
            if (rows.size() != 200) continue;
            table.addRows(rows);
            rows.clear();
        }
        if (rows.size() > 0) {
            table.addRows(rows);
        }
    }

    public void close() throws IOException {
        this._pageChannel.close();
    }

    private String escape(String s2) {
        if (RESERVED_WORDS.contains(s2.toLowerCase())) {
            return ESCAPE_PREFIX + s2;
        }
        return s2;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    static {
        Database.SID[0] = -90;
        Database.SID[1] = 51;
        ACM = new Integer(1048319);
        TYPE_TABLE = new Short(1);
        RESERVED_WORDS = new HashSet();
        RESERVED_WORDS.addAll(Arrays.asList("add", "all", "alphanumeric", "alter", "and", "any", "application", "as", "asc", "assistant", "autoincrement", "avg", "between", "binary", "bit", "boolean", "by", "byte", "char", "character", "column", "compactdatabase", "constraint", "container", "count", "counter", "create", "createdatabase", "createfield", "creategroup", "createindex", "createobject", "createproperty", "createrelation", "createtabledef", "createuser", "createworkspace", "currency", "currentuser", "database", "date", "datetime", "delete", "desc", "description", "disallow", "distinct", "distinctrow", "document", "double", "drop", "echo", "else", "end", "eqv", "error", "exists", "exit", "false", "field", "fields", "fillcache", "float", "float4", "float8", "foreign", "form", "forms", "from", "full", "function", "general", "getobject", "getoption", "gotopage", "group", "group by", "guid", "having", "idle", "ieeedouble", "ieeesingle", "if", "ignore", "imp", "in", "index", "indexes", "inner", "insert", "inserttext", "int", "integer", "integer1", "integer2", "integer4", "into", "is", "join", "key", "lastmodified", "left", "level", "like", "logical", "logical1", "long", "longbinary", "longtext", "macro", "match", "max", "min", "mod", "memo", "module", "money", "move", "name", "newpassword", "no", "not", "null", "number", "numeric", "object", "oleobject", "off", "on", "openrecordset", "option", "or", "order", "outer", "owneraccess", "parameter", "parameters", "partial", "percent", "pivot", "primary", "procedure", "property", "queries", "query", "quit", "real", "recalc", "recordset", "references", "refresh", "refreshlink", "registerdatabase", "relation", "repaint", "repairdatabase", "report", "reports", "requery", "right", "screen", "section", "select", "set", "setfocus", "setoption", "short", "single", "smallint", "some", "sql", "stdev", "stdevp", "string", "sum", "table", "tabledef", "tabledefs", "tableid", "text", "time", "timestamp", "top", "transform", "true", "type", "union", "unique", "update", "user", "value", "values", "var", "varp", "varbinary", "varchar", "where", "with", "workspace", "xor", "year", "yes", "yesno"));
    }
}

