/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.scsu;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Debug {
    private static final Log LOG = LogFactory.getLog(Debug.class);

    public static void out(char[] chars) {
        Debug.out(chars, 0);
    }

    public static void out(char[] chars, int iStart) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        for (int i2 = iStart; i2 < chars.length; ++i2) {
            if (chars[i2] >= '\u0000' && chars[i2] <= '\u001a') {
                msg.append("^" + (char)(chars[i2] + 64));
                continue;
            }
            if (chars[i2] <= '\u00ff') {
                msg.append(chars[i2]);
                continue;
            }
            msg.append("\\u" + Integer.toString(chars[i2], 16));
        }
        LOG.debug(msg.toString());
    }

    public static void out(byte[] bytes) {
        Debug.out(bytes, 0);
    }

    public static void out(byte[] bytes, int iStart) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        for (int i2 = iStart; i2 < bytes.length; ++i2) {
            msg.append(bytes[i2] + ",");
        }
        LOG.debug(msg.toString());
    }

    public static void out(String str) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(str);
    }

    public static void out(String msg, int iData) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(msg + iData);
    }

    public static void out(String msg, char ch) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(msg + "[U+" + Integer.toString(ch, 16) + "]" + ch);
    }

    public static void out(String msg, byte bData) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(msg + bData);
    }

    public static void out(String msg, String str) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(msg + str);
    }

    public static void out(String msg, char[] data) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(msg);
        Debug.out(data);
    }

    public static void out(String msg, byte[] data) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(msg);
        Debug.out(data);
    }

    public static void out(String msg, char[] data, int iStart) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(msg + "(" + iStart + "): ");
        Debug.out(data, iStart);
    }

    public static void out(String msg, byte[] data, int iStart) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug(msg + "(" + iStart + "): ");
        Debug.out(data, iStart);
    }
}

