/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser.clipper;

import com.itextpdf.text.pdf.parser.clipper.Clipper;
import com.itextpdf.text.pdf.parser.clipper.DefaultClipper;
import com.itextpdf.text.pdf.parser.clipper.LongRect;
import com.itextpdf.text.pdf.parser.clipper.Path;
import com.itextpdf.text.pdf.parser.clipper.Paths;
import com.itextpdf.text.pdf.parser.clipper.Point;
import com.itextpdf.text.pdf.parser.clipper.PolyNode;
import com.itextpdf.text.pdf.parser.clipper.PolyTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClipperOffset {
    private Paths destPolys;
    private Path srcPoly;
    private Path destPoly;
    private final List<Point.DoublePoint> normals;
    private double delta;
    private double inA;
    private double sin;
    private double cos;
    private double miterLim;
    private double stepsPerRad;
    private Point.LongPoint lowest;
    private final PolyNode polyNodes;
    private final double arcTolerance;
    private final double miterLimit;
    private static final double TWO_PI = Math.PI * 2;
    private static final double DEFAULT_ARC_TOLERANCE = 0.25;
    private static final double TOLERANCE = 1.0E-20;

    private static boolean nearZero(double val) {
        return val > -1.0E-20 && val < 1.0E-20;
    }

    public ClipperOffset() {
        this(2.0, 0.25);
    }

    public ClipperOffset(double miterLimit) {
        this(miterLimit, 0.25);
    }

    public ClipperOffset(double miterLimit, double arcTolerance) {
        this.miterLimit = miterLimit;
        this.arcTolerance = arcTolerance;
        this.lowest = new Point.LongPoint();
        this.lowest.setX(-1L);
        this.polyNodes = new PolyNode();
        this.normals = new ArrayList<Point.DoublePoint>();
    }

    public void addPath(Path path, Clipper.JoinType joinType, Clipper.EndType endType) {
        int highI = path.size() - 1;
        if (highI < 0) {
            return;
        }
        PolyNode newNode = new PolyNode();
        newNode.setJoinType(joinType);
        newNode.setEndType(endType);
        if (endType == Clipper.EndType.CLOSED_LINE || endType == Clipper.EndType.CLOSED_POLYGON) {
            while (highI > 0 && path.get(0) == path.get(highI)) {
                --highI;
            }
        }
        newNode.getPolygon().add(path.get(0));
        int j2 = 0;
        int k2 = 0;
        for (int i2 = 1; i2 <= highI; ++i2) {
            if (newNode.getPolygon().get(j2) == path.get(i2)) continue;
            ++j2;
            newNode.getPolygon().add(path.get(i2));
            if (((Point.LongPoint)path.get(i2)).getY() <= ((Point.LongPoint)newNode.getPolygon().get(k2)).getY() && (((Point.LongPoint)path.get(i2)).getY() != ((Point.LongPoint)newNode.getPolygon().get(k2)).getY() || ((Point.LongPoint)path.get(i2)).getX() >= ((Point.LongPoint)newNode.getPolygon().get(k2)).getX())) continue;
            k2 = j2;
        }
        if (endType == Clipper.EndType.CLOSED_POLYGON && j2 < 2) {
            return;
        }
        this.polyNodes.addChild(newNode);
        if (endType != Clipper.EndType.CLOSED_POLYGON) {
            return;
        }
        if (this.lowest.getX() < 0L) {
            this.lowest = new Point.LongPoint(this.polyNodes.getChildCount() - 1, k2);
        } else {
            Point.LongPoint ip = (Point.LongPoint)this.polyNodes.getChilds().get((int)this.lowest.getX()).getPolygon().get((int)this.lowest.getY());
            if (((Point.LongPoint)newNode.getPolygon().get(k2)).getY() > ip.getY() || ((Point.LongPoint)newNode.getPolygon().get(k2)).getY() == ip.getY() && ((Point.LongPoint)newNode.getPolygon().get(k2)).getX() < ip.getX()) {
                this.lowest = new Point.LongPoint(this.polyNodes.getChildCount() - 1, k2);
            }
        }
    }

    public void addPaths(Paths paths, Clipper.JoinType joinType, Clipper.EndType endType) {
        for (Path p2 : paths) {
            this.addPath(p2, joinType, endType);
        }
    }

    public void clear() {
        this.polyNodes.getChilds().clear();
        this.lowest.setX(-1L);
    }

    private void doMiter(int j2, int k2, double r2) {
        double q2 = this.delta / r2;
        this.destPoly.add(new Point.LongPoint((int)Math.round((double)((Point.LongPoint)this.srcPoly.get(j2)).getX() + (this.normals.get(k2).getX() + this.normals.get(j2).getX()) * q2), (int)Math.round((double)((Point.LongPoint)this.srcPoly.get(j2)).getY() + (this.normals.get(k2).getY() + this.normals.get(j2).getY()) * q2)));
    }

    private void doOffset(double delta) {
        this.destPolys = new Paths();
        this.delta = delta;
        if (ClipperOffset.nearZero(delta)) {
            for (int i2 = 0; i2 < this.polyNodes.getChildCount(); ++i2) {
                PolyNode node = this.polyNodes.getChilds().get(i2);
                if (node.getEndType() != Clipper.EndType.CLOSED_POLYGON) continue;
                this.destPolys.add(node.getPolygon());
            }
            return;
        }
        this.miterLim = this.miterLimit > 2.0 ? 2.0 / (this.miterLimit * this.miterLimit) : 0.5;
        double y = this.arcTolerance <= 0.0 ? 0.25 : (this.arcTolerance > Math.abs(delta) * 0.25 ? Math.abs(delta) * 0.25 : this.arcTolerance);
        double steps = Math.PI / Math.acos(1.0 - y / Math.abs(delta));
        this.sin = Math.sin(Math.PI * 2 / steps);
        this.cos = Math.cos(Math.PI * 2 / steps);
        this.stepsPerRad = steps / (Math.PI * 2);
        if (delta < 0.0) {
            this.sin = -this.sin;
        }
        for (int i3 = 0; i3 < this.polyNodes.getChildCount(); ++i3) {
            int j2;
            int j3;
            PolyNode node = this.polyNodes.getChilds().get(i3);
            this.srcPoly = node.getPolygon();
            int len = this.srcPoly.size();
            if (len == 0 || delta <= 0.0 && (len < 3 || node.getEndType() != Clipper.EndType.CLOSED_POLYGON)) continue;
            this.destPoly = new Path();
            if (len == 1) {
                int j4;
                double Y;
                double X;
                if (node.getJoinType() == Clipper.JoinType.ROUND) {
                    X = 1.0;
                    Y = 0.0;
                    j4 = 1;
                    while ((double)j4 <= steps) {
                        this.destPoly.add(new Point.LongPoint((int)Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getX() + X * delta), (int)Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getY() + Y * delta)));
                        double X2 = X;
                        X = X * this.cos - this.sin * Y;
                        Y = X2 * this.sin + Y * this.cos;
                        ++j4;
                    }
                } else {
                    X = -1.0;
                    Y = -1.0;
                    for (j4 = 0; j4 < 4; ++j4) {
                        this.destPoly.add(new Point.LongPoint((int)Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getX() + X * delta), (int)Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getY() + Y * delta)));
                        if (X < 0.0) {
                            X = 1.0;
                            continue;
                        }
                        if (Y < 0.0) {
                            Y = 1.0;
                            continue;
                        }
                        X = -1.0;
                    }
                }
                this.destPolys.add(this.destPoly);
                continue;
            }
            this.normals.clear();
            for (int j5 = 0; j5 < len - 1; ++j5) {
                this.normals.add(Point.getUnitNormal((Point.LongPoint)this.srcPoly.get(j5), (Point.LongPoint)this.srcPoly.get(j5 + 1)));
            }
            if (node.getEndType() == Clipper.EndType.CLOSED_LINE || node.getEndType() == Clipper.EndType.CLOSED_POLYGON) {
                this.normals.add(Point.getUnitNormal((Point.LongPoint)this.srcPoly.get(len - 1), (Point.LongPoint)this.srcPoly.get(0)));
            } else {
                this.normals.add(new Point.DoublePoint(this.normals.get(len - 2)));
            }
            if (node.getEndType() == Clipper.EndType.CLOSED_POLYGON) {
                int[] k2 = new int[]{len - 1};
                for (j3 = 0; j3 < len; ++j3) {
                    this.offsetPoint(j3, k2, node.getJoinType());
                }
                this.destPolys.add(this.destPoly);
                continue;
            }
            if (node.getEndType() == Clipper.EndType.CLOSED_LINE) {
                int j6;
                int[] k3 = new int[]{len - 1};
                for (j3 = 0; j3 < len; ++j3) {
                    this.offsetPoint(j3, k3, node.getJoinType());
                }
                this.destPolys.add(this.destPoly);
                this.destPoly = new Path();
                Point.DoublePoint n2 = this.normals.get(len - 1);
                for (j6 = len - 1; j6 > 0; --j6) {
                    this.normals.set(j6, new Point.DoublePoint(-this.normals.get(j6 - 1).getX(), -this.normals.get(j6 - 1).getY()));
                }
                this.normals.set(0, new Point.DoublePoint(-n2.getX(), -n2.getY(), 0.0));
                k3[0] = 0;
                for (j6 = len - 1; j6 >= 0; --j6) {
                    this.offsetPoint(j6, k3, node.getJoinType());
                }
                this.destPolys.add(this.destPoly);
                continue;
            }
            int[] k4 = new int[1];
            for (j3 = 1; j3 < len - 1; ++j3) {
                this.offsetPoint(j3, k4, node.getJoinType());
            }
            if (node.getEndType() == Clipper.EndType.OPEN_BUTT) {
                j2 = len - 1;
                Point.LongPoint pt1 = new Point.LongPoint((int)Math.round((double)((Point.LongPoint)this.srcPoly.get(j2)).getX() + this.normals.get(j2).getX() * delta), (int)Math.round((double)((Point.LongPoint)this.srcPoly.get(j2)).getY() + this.normals.get(j2).getY() * delta), 0L);
                this.destPoly.add(pt1);
                pt1 = new Point.LongPoint((int)Math.round((double)((Point.LongPoint)this.srcPoly.get(j2)).getX() - this.normals.get(j2).getX() * delta), (int)Math.round((double)((Point.LongPoint)this.srcPoly.get(j2)).getY() - this.normals.get(j2).getY() * delta), 0L);
                this.destPoly.add(pt1);
            } else {
                j2 = len - 1;
                k4[0] = len - 2;
                this.inA = 0.0;
                this.normals.set(j2, new Point.DoublePoint(-this.normals.get(j2).getX(), -this.normals.get(j2).getY()));
                if (node.getEndType() == Clipper.EndType.OPEN_SQUARE) {
                    this.doSquare(j2, k4[0], true);
                } else {
                    this.doRound(j2, k4[0]);
                }
            }
            for (j2 = len - 1; j2 > 0; --j2) {
                this.normals.set(j2, new Point.DoublePoint(-this.normals.get(j2 - 1).getX(), -this.normals.get(j2 - 1).getY()));
            }
            this.normals.set(0, new Point.DoublePoint(-this.normals.get(1).getX(), -this.normals.get(1).getY()));
            k4[0] = len - 1;
            for (j2 = k4[0] - 1; j2 > 0; --j2) {
                this.offsetPoint(j2, k4, node.getJoinType());
            }
            if (node.getEndType() == Clipper.EndType.OPEN_BUTT) {
                Point.LongPoint pt1 = new Point.LongPoint((int)Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getX() - this.normals.get(0).getX() * delta), (int)Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getY() - this.normals.get(0).getY() * delta));
                this.destPoly.add(pt1);
                pt1 = new Point.LongPoint((int)Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getX() + this.normals.get(0).getX() * delta), (int)Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getY() + this.normals.get(0).getY() * delta));
                this.destPoly.add(pt1);
            } else {
                k4[0] = 1;
                this.inA = 0.0;
                if (node.getEndType() == Clipper.EndType.OPEN_SQUARE) {
                    this.doSquare(0, 1, true);
                } else {
                    this.doRound(0, 1);
                }
            }
            this.destPolys.add(this.destPoly);
        }
    }

    private void doRound(int j2, int k2) {
        double a2 = Math.atan2(this.inA, this.normals.get(k2).getX() * this.normals.get(j2).getX() + this.normals.get(k2).getY() * this.normals.get(j2).getY());
        int steps = Math.max((int)Math.round(this.stepsPerRad * Math.abs(a2)), 1);
        double X = this.normals.get(k2).getX();
        double Y = this.normals.get(k2).getY();
        for (int i2 = 0; i2 < steps; ++i2) {
            this.destPoly.add(new Point.LongPoint((int)Math.round((double)((Point.LongPoint)this.srcPoly.get(j2)).getX() + X * this.delta), (int)Math.round((double)((Point.LongPoint)this.srcPoly.get(j2)).getY() + Y * this.delta)));
            double X2 = X;
            X = X * this.cos - this.sin * Y;
            Y = X2 * this.sin + Y * this.cos;
        }
        this.destPoly.add(new Point.LongPoint((int)Math.round((double)((Point.LongPoint)this.srcPoly.get(j2)).getX() + this.normals.get(j2).getX() * this.delta), (int)Math.round((double)((Point.LongPoint)this.srcPoly.get(j2)).getY() + this.normals.get(j2).getY() * this.delta)));
    }

    private void doSquare(int j2, int k2, boolean addExtra) {
        double nkx = this.normals.get(k2).getX();
        double nky = this.normals.get(k2).getY();
        double njx = this.normals.get(j2).getX();
        double njy = this.normals.get(j2).getY();
        double sjx = ((Point.LongPoint)this.srcPoly.get(j2)).getX();
        double sjy = ((Point.LongPoint)this.srcPoly.get(j2)).getY();
        double dx = Math.tan(Math.atan2(this.inA, nkx * njx + nky * njy) / 4.0);
        this.destPoly.add(new Point.LongPoint((int)Math.round(sjx + this.delta * (nkx - (addExtra ? nky * dx : 0.0))), (int)Math.round(sjy + this.delta * (nky + (addExtra ? nkx * dx : 0.0))), 0L));
        this.destPoly.add(new Point.LongPoint((int)Math.round(sjx + this.delta * (njx + (addExtra ? njy * dx : 0.0))), (int)Math.round(sjy + this.delta * (njy - (addExtra ? njx * dx : 0.0))), 0L));
    }

    public void execute(Paths solution, double delta) {
        solution.clear();
        this.fixOrientations();
        this.doOffset(delta);
        DefaultClipper clpr = new DefaultClipper(1);
        clpr.addPaths(this.destPolys, Clipper.PolyType.SUBJECT, true);
        if (delta > 0.0) {
            clpr.execute(Clipper.ClipType.UNION, solution, Clipper.PolyFillType.POSITIVE, Clipper.PolyFillType.POSITIVE);
        } else {
            LongRect r2 = this.destPolys.getBounds();
            Path outer = new Path(4);
            outer.add(new Point.LongPoint(r2.left - 10L, r2.bottom + 10L, 0L));
            outer.add(new Point.LongPoint(r2.right + 10L, r2.bottom + 10L, 0L));
            outer.add(new Point.LongPoint(r2.right + 10L, r2.top - 10L, 0L));
            outer.add(new Point.LongPoint(r2.left - 10L, r2.top - 10L, 0L));
            clpr.addPath(outer, Clipper.PolyType.SUBJECT, true);
            clpr.execute(Clipper.ClipType.UNION, solution, Clipper.PolyFillType.NEGATIVE, Clipper.PolyFillType.NEGATIVE);
            if (solution.size() > 0) {
                solution.remove(0);
            }
        }
    }

    public void execute(PolyTree solution, double delta) {
        solution.Clear();
        this.fixOrientations();
        this.doOffset(delta);
        DefaultClipper clpr = new DefaultClipper(1);
        clpr.addPaths(this.destPolys, Clipper.PolyType.SUBJECT, true);
        if (delta > 0.0) {
            clpr.execute(Clipper.ClipType.UNION, solution, Clipper.PolyFillType.POSITIVE, Clipper.PolyFillType.POSITIVE);
        } else {
            LongRect r2 = this.destPolys.getBounds();
            Path outer = new Path(4);
            outer.add(new Point.LongPoint(r2.left - 10L, r2.bottom + 10L, 0L));
            outer.add(new Point.LongPoint(r2.right + 10L, r2.bottom + 10L, 0L));
            outer.add(new Point.LongPoint(r2.right + 10L, r2.top - 10L, 0L));
            outer.add(new Point.LongPoint(r2.left - 10L, r2.top - 10L, 0L));
            clpr.addPath(outer, Clipper.PolyType.SUBJECT, true);
            clpr.execute(Clipper.ClipType.UNION, solution, Clipper.PolyFillType.NEGATIVE, Clipper.PolyFillType.NEGATIVE);
            if (solution.getChildCount() == 1 && solution.getChilds().get(0).getChildCount() > 0) {
                PolyNode outerNode = solution.getChilds().get(0);
                solution.getChilds().set(0, outerNode.getChilds().get(0));
                solution.getChilds().get(0).setParent(solution);
                for (int i2 = 1; i2 < outerNode.getChildCount(); ++i2) {
                    solution.addChild(outerNode.getChilds().get(i2));
                }
            } else {
                solution.Clear();
            }
        }
    }

    private void fixOrientations() {
        if (this.lowest.getX() >= 0L && !this.polyNodes.childs.get((int)this.lowest.getX()).getPolygon().orientation()) {
            for (int i2 = 0; i2 < this.polyNodes.getChildCount(); ++i2) {
                PolyNode node = this.polyNodes.childs.get(i2);
                if (node.getEndType() != Clipper.EndType.CLOSED_POLYGON && (node.getEndType() != Clipper.EndType.CLOSED_LINE || !node.getPolygon().orientation())) continue;
                Collections.reverse(node.getPolygon());
            }
        } else {
            for (int i3 = 0; i3 < this.polyNodes.getChildCount(); ++i3) {
                PolyNode node = this.polyNodes.childs.get(i3);
                if (node.getEndType() != Clipper.EndType.CLOSED_LINE || node.getPolygon().orientation()) continue;
                Collections.reverse(node.getPolygon());
            }
        }
    }

    private void offsetPoint(int j2, int[] kV, Clipper.JoinType jointype) {
        int k2 = kV[0];
        double nkx = this.normals.get(k2).getX();
        double nky = this.normals.get(k2).getY();
        double njy = this.normals.get(j2).getY();
        double njx = this.normals.get(j2).getX();
        long sjx = ((Point.LongPoint)this.srcPoly.get(j2)).getX();
        long sjy = ((Point.LongPoint)this.srcPoly.get(j2)).getY();
        this.inA = nkx * njy - njx * nky;
        if (Math.abs(this.inA * this.delta) < 1.0) {
            double cosA = nkx * njx + njy * nky;
            if (cosA > 0.0) {
                this.destPoly.add(new Point.LongPoint((int)Math.round((double)sjx + nkx * this.delta), (int)Math.round((double)sjy + nky * this.delta), 0L));
                return;
            }
        } else if (this.inA > 1.0) {
            this.inA = 1.0;
        } else if (this.inA < -1.0) {
            this.inA = -1.0;
        }
        if (this.inA * this.delta < 0.0) {
            this.destPoly.add(new Point.LongPoint((int)Math.round((double)sjx + nkx * this.delta), (int)Math.round((double)sjy + nky * this.delta)));
            this.destPoly.add(this.srcPoly.get(j2));
            this.destPoly.add(new Point.LongPoint((int)Math.round((double)sjx + njx * this.delta), (int)Math.round((double)sjy + njy * this.delta)));
        } else {
            switch (jointype) {
                case MITER: {
                    double r2 = 1.0 + njx * nkx + njy * nky;
                    if (r2 >= this.miterLim) {
                        this.doMiter(j2, k2, r2);
                        break;
                    }
                    this.doSquare(j2, k2, false);
                    break;
                }
                case BEVEL: {
                    this.doSquare(j2, k2, false);
                    break;
                }
                case ROUND: {
                    this.doRound(j2, k2);
                }
            }
        }
        kV[0] = j2;
    }
}

