/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jxl.Cell;
import jxl.CellType;
import jxl.LabelCell;
import jxl.Sheet;

public class CellFinder {
    private Sheet sheet;

    public CellFinder(Sheet s2) {
        this.sheet = s2;
    }

    public Cell findCell(String contents, int firstCol, int firstRow, int lastCol, int lastRow, boolean reverse) {
        Cell cell = null;
        boolean found = false;
        int numCols = lastCol - firstCol;
        int numRows = lastRow - firstRow;
        int row1 = reverse ? lastRow : firstRow;
        int row2 = reverse ? firstRow : lastRow;
        int col1 = reverse ? lastCol : firstCol;
        int col2 = reverse ? firstCol : lastCol;
        int inc = reverse ? -1 : 1;
        for (int i2 = 0; i2 <= numCols && !found; ++i2) {
            for (int j2 = 0; j2 <= numRows && !found; ++j2) {
                Cell c2;
                int curCol = col1 + i2 * inc;
                int curRow = row1 + j2 * inc;
                if (curCol >= this.sheet.getColumns() || curRow >= this.sheet.getRows() || (c2 = this.sheet.getCell(curCol, curRow)).getType() == CellType.EMPTY || !c2.getContents().equals(contents)) continue;
                cell = c2;
                found = true;
            }
        }
        return cell;
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        for (int i2 = 0; i2 < this.sheet.getRows() && !found; ++i2) {
            Cell[] row = this.sheet.getRow(i2);
            for (int j2 = 0; j2 < row.length && !found; ++j2) {
                if (!row[j2].getContents().equals(contents)) continue;
                cell = row[j2];
                found = true;
            }
        }
        return cell;
    }

    public Cell findCell(Pattern pattern, int firstCol, int firstRow, int lastCol, int lastRow, boolean reverse) {
        Cell cell = null;
        boolean found = false;
        int numCols = lastCol - firstCol;
        int numRows = lastRow - firstRow;
        int row1 = reverse ? lastRow : firstRow;
        int row2 = reverse ? firstRow : lastRow;
        int col1 = reverse ? lastCol : firstCol;
        int col2 = reverse ? firstCol : lastCol;
        int inc = reverse ? -1 : 1;
        for (int i2 = 0; i2 <= numCols && !found; ++i2) {
            for (int j2 = 0; j2 <= numRows && !found; ++j2) {
                Matcher m2;
                Cell c2;
                int curCol = col1 + i2 * inc;
                int curRow = row1 + j2 * inc;
                if (curCol >= this.sheet.getColumns() || curRow >= this.sheet.getRows() || (c2 = this.sheet.getCell(curCol, curRow)).getType() == CellType.EMPTY || !(m2 = pattern.matcher(c2.getContents())).matches()) continue;
                cell = c2;
                found = true;
            }
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        for (int i2 = 0; i2 < this.sheet.getRows() && !found; ++i2) {
            Cell[] row = this.sheet.getRow(i2);
            for (int j2 = 0; j2 < row.length && !found; ++j2) {
                if (row[j2].getType() != CellType.LABEL && row[j2].getType() != CellType.STRING_FORMULA || !row[j2].getContents().equals(contents)) continue;
                cell = (LabelCell)row[j2];
                found = true;
            }
        }
        return cell;
    }
}

