/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import java.util.Stack;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Area;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Function;
import jxl.biff.formula.Operator;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;
import jxl.common.Logger;

class VariableArgFunction
extends Operator
implements ParsedThing {
    private static Logger logger = Logger.getLogger(VariableArgFunction.class);
    private Function function;
    private int arguments;
    private boolean readFromSheet;
    private WorkbookSettings settings;

    public VariableArgFunction(WorkbookSettings ws) {
        this.readFromSheet = true;
        this.settings = ws;
    }

    public VariableArgFunction(Function f2, int a2, WorkbookSettings ws) {
        this.function = f2;
        this.arguments = a2;
        this.readFromSheet = false;
        this.settings = ws;
    }

    @Override
    public int read(byte[] data, int pos) throws FormulaException {
        this.arguments = data[pos];
        int index = IntegerHelper.getInt(data[pos + 1], data[pos + 2]);
        this.function = Function.getFunction(index);
        if (this.function == Function.UNKNOWN) {
            throw new FormulaException(FormulaException.UNRECOGNIZED_FUNCTION, index);
        }
        return 3;
    }

    @Override
    public void getOperands(Stack s2) {
        int i2;
        ParseItem[] items = new ParseItem[this.arguments];
        for (i2 = this.arguments - 1; i2 >= 0; --i2) {
            ParseItem pi;
            items[i2] = pi = (ParseItem)s2.pop();
        }
        for (i2 = 0; i2 < this.arguments; ++i2) {
            this.add(items[i2]);
        }
    }

    @Override
    public void getString(StringBuffer buf) {
        buf.append(this.function.getName(this.settings));
        buf.append('(');
        if (this.arguments > 0) {
            ParseItem[] operands = this.getOperands();
            if (this.readFromSheet) {
                operands[0].getString(buf);
                for (int i2 = 1; i2 < this.arguments; ++i2) {
                    buf.append(',');
                    operands[i2].getString(buf);
                }
            } else {
                operands[this.arguments - 1].getString(buf);
                for (int i3 = this.arguments - 2; i3 >= 0; --i3) {
                    buf.append(',');
                    operands[i3].getString(buf);
                }
            }
        }
        buf.append(')');
    }

    @Override
    public void adjustRelativeCellReferences(int colAdjust, int rowAdjust) {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].adjustRelativeCellReferences(colAdjust, rowAdjust);
        }
    }

    @Override
    void columnInserted(int sheetIndex, int col, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].columnInserted(sheetIndex, col, currentSheet);
        }
    }

    @Override
    void columnRemoved(int sheetIndex, int col, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].columnRemoved(sheetIndex, col, currentSheet);
        }
    }

    @Override
    void rowInserted(int sheetIndex, int row, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].rowInserted(sheetIndex, row, currentSheet);
        }
    }

    @Override
    void rowRemoved(int sheetIndex, int row, boolean currentSheet) {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].rowRemoved(sheetIndex, row, currentSheet);
        }
    }

    @Override
    void handleImportedCellReferences() {
        ParseItem[] operands = this.getOperands();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            operands[i2].handleImportedCellReferences();
        }
    }

    Function getFunction() {
        return this.function;
    }

    @Override
    byte[] getBytes() {
        this.handleSpecialCases();
        ParseItem[] operands = this.getOperands();
        byte[] data = new byte[]{};
        for (int i2 = 0; i2 < operands.length; ++i2) {
            byte[] opdata = operands[i2].getBytes();
            byte[] newdata = new byte[data.length + opdata.length];
            System.arraycopy(data, 0, newdata, 0, data.length);
            System.arraycopy(opdata, 0, newdata, data.length, opdata.length);
            data = newdata;
        }
        byte[] newdata = new byte[data.length + 4];
        System.arraycopy(data, 0, newdata, 0, data.length);
        newdata[data.length] = !this.useAlternateCode() ? Token.FUNCTIONVARARG.getCode() : Token.FUNCTIONVARARG.getCode2();
        newdata[data.length + 1] = (byte)this.arguments;
        IntegerHelper.getTwoBytes(this.function.getCode(), newdata, data.length + 2);
        return newdata;
    }

    @Override
    int getPrecedence() {
        return 3;
    }

    private void handleSpecialCases() {
        if (this.function == Function.SUMPRODUCT) {
            ParseItem[] operands = this.getOperands();
            for (int i2 = operands.length - 1; i2 >= 0; --i2) {
                if (!(operands[i2] instanceof Area)) continue;
                operands[i2].setAlternateCode();
            }
        }
    }
}

