/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.util.ArrayList;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.common.Logger;
import jxl.read.biff.File;

public final class Record {
    private static final Logger logger = Logger.getLogger(Record.class);
    private int code;
    private Type type;
    private int length;
    private int dataPos;
    private File file;
    private byte[] data;
    private ArrayList continueRecords;

    Record(byte[] d2, int offset, File f2) {
        this.code = IntegerHelper.getInt(d2[offset], d2[offset + 1]);
        this.length = IntegerHelper.getInt(d2[offset + 2], d2[offset + 3]);
        this.file = f2;
        this.file.skip(4);
        this.dataPos = f2.getPos();
        this.file.skip(this.length);
        this.type = Type.getType(this.code);
    }

    public Type getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getData() {
        if (this.data == null) {
            this.data = this.file.read(this.dataPos, this.length);
        }
        if (this.continueRecords != null) {
            int size = 0;
            byte[][] contData = new byte[this.continueRecords.size()][];
            for (int i2 = 0; i2 < this.continueRecords.size(); ++i2) {
                Record r2 = (Record)this.continueRecords.get(i2);
                contData[i2] = r2.getData();
                byte[] d2 = contData[i2];
                size += d2.length;
            }
            byte[] d3 = new byte[this.data.length + size];
            System.arraycopy(this.data, 0, d3, 0, this.data.length);
            int pos = this.data.length;
            for (int i3 = 0; i3 < contData.length; ++i3) {
                byte[] d2 = contData[i3];
                System.arraycopy(d2, 0, d3, pos, d2.length);
                pos += d2.length;
            }
            this.data = d3;
        }
        return this.data;
    }

    public int getCode() {
        return this.code;
    }

    void setType(Type t) {
        this.type = t;
    }

    public void addContinueRecord(Record d2) {
        if (this.continueRecords == null) {
            this.continueRecords = new ArrayList();
        }
        this.continueRecords.add(d2);
    }
}

