/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.util.Arrays;
import net.lingala.zip4j.crypto.AesCipherUtil;
import net.lingala.zip4j.crypto.Decrypter;
import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.engine.AESEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.enums.AesKeyStrength;

public class AESDecrypter
implements Decrypter {
    private AESExtraDataRecord aesExtraDataRecord;
    private char[] password;
    private AESEngine aesEngine;
    private MacBasedPRF mac;
    private int nonce = 1;
    private byte[] iv;
    private byte[] counterBlock;

    public AESDecrypter(AESExtraDataRecord aesExtraDataRecord, char[] password, byte[] salt, byte[] passwordVerifier) throws ZipException {
        this.aesExtraDataRecord = aesExtraDataRecord;
        this.password = password;
        this.iv = new byte[16];
        this.counterBlock = new byte[16];
        this.init(salt, passwordVerifier);
    }

    private void init(byte[] salt, byte[] passwordVerifier) throws ZipException {
        if (this.password == null || this.password.length <= 0) {
            throw new ZipException("empty or null password provided for AES decryption");
        }
        AesKeyStrength aesKeyStrength = this.aesExtraDataRecord.getAesKeyStrength();
        byte[] derivedKey = AesCipherUtil.derivePasswordBasedKey(salt, this.password, aesKeyStrength);
        byte[] derivedPasswordVerifier = AesCipherUtil.derivePasswordVerifier(derivedKey, aesKeyStrength);
        if (!Arrays.equals(passwordVerifier, derivedPasswordVerifier)) {
            throw new ZipException("Wrong Password", ZipException.Type.WRONG_PASSWORD);
        }
        this.aesEngine = AesCipherUtil.getAESEngine(derivedKey, aesKeyStrength);
        this.mac = AesCipherUtil.getMacBasedPRF(derivedKey, aesKeyStrength);
    }

    @Override
    public int decryptData(byte[] buff, int start, int len) throws ZipException {
        for (int j2 = start; j2 < start + len; j2 += 16) {
            int loopCount = j2 + 16 <= start + len ? 16 : start + len - j2;
            this.mac.update(buff, j2, loopCount);
            AesCipherUtil.prepareBuffAESIVBytes(this.iv, this.nonce);
            this.aesEngine.processBlock(this.iv, this.counterBlock);
            for (int k2 = 0; k2 < loopCount; ++k2) {
                buff[j2 + k2] = (byte)(buff[j2 + k2] ^ this.counterBlock[k2]);
            }
            ++this.nonce;
        }
        return len;
    }

    public byte[] getCalculatedAuthenticationBytes() {
        return this.mac.doFinal();
    }
}

