/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.behavior.ICacheObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheWatchRepairable
implements ICacheObserver {
    private static final Log log = LogFactory.getLog(CacheWatchRepairable.class);
    private ICacheObserver cacheWatch;
    private final ConcurrentMap<String, Set<ICacheListener<?, ?>>> cacheMap = new ConcurrentHashMap();

    public void setCacheWatch(ICacheObserver cacheWatch) {
        this.cacheWatch = cacheWatch;
        for (Map.Entry entry : this.cacheMap.entrySet()) {
            String cacheName = (String)entry.getKey();
            for (ICacheListener listener : (Set)entry.getValue()) {
                try {
                    if (log.isInfoEnabled()) {
                        log.info("Adding listener to cache watch. ICacheListener = " + listener + " | ICacheObserver = " + cacheWatch);
                    }
                    cacheWatch.addCacheListener(cacheName, listener);
                }
                catch (IOException ex) {
                    log.error("Problem adding listener. ICacheListener = " + listener + " | ICacheObserver = " + cacheWatch, ex);
                }
            }
        }
    }

    @Override
    public <K, V> void addCacheListener(String cacheName, ICacheListener<K, V> obj) throws IOException {
        CopyOnWriteArraySet<ICacheListener<K, V>> newListenerSet;
        CopyOnWriteArraySet<ICacheListener<K, V>> listenerSet = (CopyOnWriteArraySet<ICacheListener<K, V>>)this.cacheMap.get(cacheName);
        if (listenerSet == null && (listenerSet = (Set)this.cacheMap.putIfAbsent(cacheName, newListenerSet = new CopyOnWriteArraySet<ICacheListener<K, V>>())) == null) {
            listenerSet = newListenerSet;
        }
        listenerSet.add(obj);
        if (log.isInfoEnabled()) {
            log.info("Adding listener to cache watch. ICacheListener = " + obj + " | ICacheObserver = " + this.cacheWatch + " | cacheName = " + cacheName);
        }
        this.cacheWatch.addCacheListener(cacheName, obj);
    }

    @Override
    public <K, V> void addCacheListener(ICacheListener<K, V> obj) throws IOException {
        for (Set listenerSet : this.cacheMap.values()) {
            listenerSet.add(obj);
        }
        if (log.isInfoEnabled()) {
            log.info("Adding listener to cache watch. ICacheListener = " + obj + " | ICacheObserver = " + this.cacheWatch);
        }
        this.cacheWatch.addCacheListener(obj);
    }

    @Override
    public <K, V> void removeCacheListener(String cacheName, ICacheListener<K, V> obj) throws IOException {
        Set listenerSet;
        if (log.isInfoEnabled()) {
            log.info("removeCacheListener, cacheName [" + cacheName + "]");
        }
        if ((listenerSet = (Set)this.cacheMap.get(cacheName)) != null) {
            listenerSet.remove(obj);
        }
        this.cacheWatch.removeCacheListener(cacheName, obj);
    }

    @Override
    public <K, V> void removeCacheListener(ICacheListener<K, V> obj) throws IOException {
        if (log.isInfoEnabled()) {
            log.info("removeCacheListener, ICacheListener [" + obj + "]");
        }
        for (Set listenerSet : this.cacheMap.values()) {
            if (log.isDebugEnabled()) {
                log.debug("Before removing [" + obj + "] the listenerSet = " + listenerSet);
            }
            listenerSet.remove(obj);
        }
        this.cacheWatch.removeCacheListener(obj);
    }
}

