/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.access;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.access.GroupCacheAccess;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.utils.access.JCSWorkerHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCSWorker<K, V> {
    private static final Log logger = LogFactory.getLog(JCSWorker.class);
    private CacheAccess<K, V> cache;
    private GroupCacheAccess<K, V> groupCache;
    private volatile ConcurrentMap<String, JCSWorkerHelper<V>> map = new ConcurrentHashMap<String, JCSWorkerHelper<V>>();
    private final String region;

    public JCSWorker(String aRegion) {
        this.region = aRegion;
        try {
            this.cache = JCS.getInstance(aRegion);
            this.groupCache = JCS.getGroupCacheInstance(aRegion);
        }
        catch (CacheException e2) {
            throw new RuntimeException(e2.getMessage());
        }
    }

    public String getRegion() {
        return this.region;
    }

    public V getResult(K aKey, JCSWorkerHelper<V> aWorker) throws Exception {
        return this.run(aKey, null, aWorker);
    }

    public V getResult(K aKey, String aGroup, JCSWorkerHelper<V> aWorker) throws Exception {
        return this.run(aKey, aGroup, aWorker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V run(K aKey, String aGroup, JCSWorkerHelper<V> aHelper) throws Exception {
        JCSWorkerHelper<V> jCSWorkerHelper;
        Object result = null;
        JCSWorkerHelper<V> helper = this.map.putIfAbsent(this.getRegion() + aKey, aHelper);
        if (helper != null) {
            jCSWorkerHelper = helper;
            synchronized (jCSWorkerHelper) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found a worker already doing this work (" + this.getRegion() + ":" + aKey + ").");
                }
                while (!helper.isFinished()) {
                    try {
                        helper.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Another thread finished our work for us. Using those results instead. (" + this.getRegion() + ":" + aKey + ").");
                }
            }
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(this.getRegion() + " is doing the work.");
            }
            if ((result = aGroup != null ? (Object)this.groupCache.getFromGroup(aKey, aGroup) : (Object)this.cache.get(aKey)) == null) {
                result = aHelper.doWork();
                if (logger.isDebugEnabled()) {
                    logger.debug("Work Done, caching: key:" + aKey + ", group:" + aGroup + ", result:" + result + ".");
                }
                if (aGroup != null) {
                    this.groupCache.putInGroup(aKey, aGroup, result);
                } else {
                    this.cache.put(aKey, result);
                }
            }
            jCSWorkerHelper = result;
            return (V)jCSWorkerHelper;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug(this.getRegion() + ":" + aKey + " entered finally.");
            }
            if (helper == null) {
                this.map.remove(this.getRegion() + aKey);
            }
            JCSWorkerHelper<V> jCSWorkerHelper2 = aHelper;
            synchronized (jCSWorkerHelper2) {
                aHelper.setFinished(true);
                aHelper.notifyAll();
            }
        }
    }
}

