/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostNameUtil {
    private static final Log log = LogFactory.getLog(HostNameUtil.class);

    public static String getLocalHostAddress() throws UnknownHostException {
        try {
            String hostAddress = HostNameUtil.getLocalHostLANAddress().getHostAddress();
            if (log.isDebugEnabled()) {
                log.debug("hostAddress = [" + hostAddress + "]");
            }
            return hostAddress;
        }
        catch (UnknownHostException e1) {
            log.error("Couldn't get localhost address", e1);
            throw e1;
        }
    }

    public static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e2) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e2);
            unknownHostException.initCause(e2);
            throw unknownHostException;
        }
    }
}

