/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.LutherFieldStepInterpolator;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegrator;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LutherFieldIntegrator<T extends RealFieldElement<T>>
extends RungeKuttaFieldIntegrator<T> {
    public LutherFieldIntegrator(Field<T> field, T step) {
        super(field, "Luther", step);
    }

    @Override
    public T[] getC() {
        RealFieldElement q2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getZero()).add(21.0)).sqrt();
        RealFieldElement[] c2 = (RealFieldElement[])MathArrays.buildArray(this.getField(), 6);
        c2[0] = (RealFieldElement)this.getField().getOne();
        c2[1] = this.fraction(1, 2);
        c2[2] = this.fraction(2, 3);
        c2[3] = (RealFieldElement)((RealFieldElement)q2.subtract(7.0)).divide(-14.0);
        c2[4] = (RealFieldElement)((RealFieldElement)q2.add(7.0)).divide(14.0);
        c2[5] = (RealFieldElement)this.getField().getOne();
        return c2;
    }

    @Override
    public T[][] getA() {
        RealFieldElement q2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getZero()).add(21.0)).sqrt();
        RealFieldElement[][] a2 = (RealFieldElement[][])MathArrays.buildArray(this.getField(), 6, -1);
        for (int i2 = 0; i2 < a2.length; ++i2) {
            a2[i2] = (RealFieldElement[])MathArrays.buildArray(this.getField(), i2 + 1);
        }
        a2[0][0] = (RealFieldElement)this.getField().getOne();
        a2[1][0] = this.fraction(3, 8);
        a2[1][1] = this.fraction(1, 8);
        a2[2][0] = this.fraction(8, 27);
        a2[2][1] = this.fraction(2, 27);
        a2[2][2] = a2[2][0];
        a2[3][0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(9)).add(-21.0)).divide(392.0);
        a2[3][1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(8)).add(-56.0)).divide(392.0);
        a2[3][2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(-48)).add(336.0)).divide(392.0);
        a2[3][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(3)).add(-63.0)).divide(392.0);
        a2[4][0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(-255)).add(-1155.0)).divide(1960.0);
        a2[4][1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(-40)).add(-280.0)).divide(1960.0);
        a2[4][2] = (RealFieldElement)((RealFieldElement)q2.multiply(-320)).divide(1960.0);
        a2[4][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(363)).add(63.0)).divide(1960.0);
        a2[4][4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(392)).add(2352.0)).divide(1960.0);
        a2[5][0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(105)).add(330.0)).divide(180.0);
        a2[5][1] = this.fraction(2, 3);
        a2[5][2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(280)).add(-200.0)).divide(180.0);
        a2[5][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(-189)).add(126.0)).divide(180.0);
        a2[5][4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(-126)).add(-686.0)).divide(180.0);
        a2[5][5] = (RealFieldElement)((RealFieldElement)((RealFieldElement)q2.multiply(-70)).add(490.0)).divide(180.0);
        return a2;
    }

    @Override
    public T[] getB() {
        RealFieldElement[] b2 = (RealFieldElement[])MathArrays.buildArray(this.getField(), 7);
        b2[0] = this.fraction(1, 20);
        b2[1] = (RealFieldElement)this.getField().getZero();
        b2[2] = this.fraction(16, 45);
        b2[3] = (RealFieldElement)this.getField().getZero();
        b2[4] = this.fraction(49, 180);
        b2[5] = b2[4];
        b2[6] = b2[0];
        return b2;
    }

    @Override
    protected LutherFieldStepInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new LutherFieldStepInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

