/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMAESOptimizer
extends MultivariateOptimizer {
    private int lambda;
    private final boolean isActiveCMA;
    private final int checkFeasableCount;
    private double[] inputSigma;
    private int dimension;
    private int diagonalOnly;
    private boolean isMinimize = true;
    private final boolean generateStatistics;
    private final int maxIterations;
    private final double stopFitness;
    private double stopTolUpX;
    private double stopTolX;
    private double stopTolFun;
    private double stopTolHistFun;
    private int mu;
    private double logMu2;
    private RealMatrix weights;
    private double mueff;
    private double sigma;
    private double cc;
    private double cs;
    private double damps;
    private double ccov1;
    private double ccovmu;
    private double chiN;
    private double ccov1Sep;
    private double ccovmuSep;
    private RealMatrix xmean;
    private RealMatrix pc;
    private RealMatrix ps;
    private double normps;
    private RealMatrix B;
    private RealMatrix D;
    private RealMatrix BD;
    private RealMatrix diagD;
    private RealMatrix C;
    private RealMatrix diagC;
    private int iterations;
    private double[] fitnessHistory;
    private int historySize;
    private final RandomGenerator random;
    private final List<Double> statisticsSigmaHistory = new ArrayList<Double>();
    private final List<RealMatrix> statisticsMeanHistory = new ArrayList<RealMatrix>();
    private final List<Double> statisticsFitnessHistory = new ArrayList<Double>();
    private final List<RealMatrix> statisticsDHistory = new ArrayList<RealMatrix>();

    public CMAESOptimizer(int maxIterations, double stopFitness, boolean isActiveCMA, int diagonalOnly, int checkFeasableCount, RandomGenerator random, boolean generateStatistics, ConvergenceChecker<PointValuePair> checker) {
        super(checker);
        this.maxIterations = maxIterations;
        this.stopFitness = stopFitness;
        this.isActiveCMA = isActiveCMA;
        this.diagonalOnly = diagonalOnly;
        this.checkFeasableCount = checkFeasableCount;
        this.random = random;
        this.generateStatistics = generateStatistics;
    }

    public List<Double> getStatisticsSigmaHistory() {
        return this.statisticsSigmaHistory;
    }

    public List<RealMatrix> getStatisticsMeanHistory() {
        return this.statisticsMeanHistory;
    }

    public List<Double> getStatisticsFitnessHistory() {
        return this.statisticsFitnessHistory;
    }

    public List<RealMatrix> getStatisticsDHistory() {
        return this.statisticsDHistory;
    }

    @Override
    public PointValuePair optimize(OptimizationData ... optData) throws TooManyEvaluationsException, DimensionMismatchException {
        return super.optimize(optData);
    }

    @Override
    protected PointValuePair doOptimize() {
        this.isMinimize = this.getGoalType().equals(GoalType.MINIMIZE);
        FitnessFunction fitfun = new FitnessFunction();
        double[] guess = this.getStartPoint();
        this.dimension = guess.length;
        this.initializeCMA(guess);
        this.iterations = 0;
        ValuePenaltyPair valuePenalty = fitfun.value(guess);
        double bestValue = valuePenalty.value + valuePenalty.penalty;
        CMAESOptimizer.push(this.fitnessHistory, bestValue);
        PointValuePair optimum = new PointValuePair(this.getStartPoint(), this.isMinimize ? bestValue : -bestValue);
        PointValuePair lastResult = null;
        this.iterations = 1;
        block2: while (this.iterations <= this.maxIterations) {
            int i2;
            this.incrementIterationCount();
            RealMatrix arz = this.randn1(this.dimension, this.lambda);
            RealMatrix arx = CMAESOptimizer.zeros(this.dimension, this.lambda);
            double[] fitness = new double[this.lambda];
            ValuePenaltyPair[] valuePenaltyPairs = new ValuePenaltyPair[this.lambda];
            for (int k2 = 0; k2 < this.lambda; ++k2) {
                RealMatrix arxk = null;
                for (int i3 = 0; i3 < this.checkFeasableCount + 1; ++i3) {
                    arxk = this.diagonalOnly <= 0 ? this.xmean.add(this.BD.multiply(arz.getColumnMatrix(k2)).scalarMultiply(this.sigma)) : this.xmean.add(CMAESOptimizer.times(this.diagD, arz.getColumnMatrix(k2)).scalarMultiply(this.sigma));
                    if (i3 >= this.checkFeasableCount || fitfun.isFeasible(arxk.getColumn(0))) break;
                    arz.setColumn(k2, this.randn(this.dimension));
                }
                CMAESOptimizer.copyColumn(arxk, 0, arx, k2);
                try {
                    valuePenaltyPairs[k2] = fitfun.value(arx.getColumn(k2));
                    continue;
                }
                catch (TooManyEvaluationsException e2) {
                    break block2;
                }
            }
            double valueRange = this.valueRange(valuePenaltyPairs);
            for (int iValue = 0; iValue < valuePenaltyPairs.length; ++iValue) {
                fitness[iValue] = valuePenaltyPairs[iValue].value + valuePenaltyPairs[iValue].penalty * valueRange;
            }
            int[] arindex = this.sortedIndices(fitness);
            RealMatrix xold = this.xmean;
            RealMatrix bestArx = CMAESOptimizer.selectColumns(arx, MathArrays.copyOf(arindex, this.mu));
            this.xmean = bestArx.multiply(this.weights);
            RealMatrix bestArz = CMAESOptimizer.selectColumns(arz, MathArrays.copyOf(arindex, this.mu));
            RealMatrix zmean = bestArz.multiply(this.weights);
            boolean hsig = this.updateEvolutionPaths(zmean, xold);
            if (this.diagonalOnly <= 0) {
                this.updateCovariance(hsig, bestArx, arz, arindex, xold);
            } else {
                this.updateCovarianceDiagonalOnly(hsig, bestArz);
            }
            this.sigma *= FastMath.exp(FastMath.min(1.0, (this.normps / this.chiN - 1.0) * this.cs / this.damps));
            double bestFitness = fitness[arindex[0]];
            double worstFitness = fitness[arindex[arindex.length - 1]];
            if (bestValue > bestFitness) {
                bestValue = bestFitness;
                lastResult = optimum;
                optimum = new PointValuePair(fitfun.repair(bestArx.getColumn(0)), this.isMinimize ? bestFitness : -bestFitness);
                if (this.getConvergenceChecker() != null && lastResult != null && this.getConvergenceChecker().converged(this.iterations, optimum, lastResult)) break;
            }
            if (this.stopFitness != 0.0) {
                if (bestFitness < (this.isMinimize ? this.stopFitness : -this.stopFitness)) break;
            }
            double[] sqrtDiagC = CMAESOptimizer.sqrt(this.diagC).getColumn(0);
            double[] pcCol = this.pc.getColumn(0);
            for (i2 = 0; i2 < this.dimension && !(this.sigma * FastMath.max(FastMath.abs(pcCol[i2]), sqrtDiagC[i2]) > this.stopTolX); ++i2) {
                if (i2 >= this.dimension - 1) break block2;
            }
            for (i2 = 0; i2 < this.dimension; ++i2) {
                if (this.sigma * sqrtDiagC[i2] > this.stopTolUpX) break block2;
            }
            double historyBest = CMAESOptimizer.min(this.fitnessHistory);
            double historyWorst = CMAESOptimizer.max(this.fitnessHistory);
            if (this.iterations > 2 && FastMath.max(historyWorst, worstFitness) - FastMath.min(historyBest, bestFitness) < this.stopTolFun || this.iterations > this.fitnessHistory.length && historyWorst - historyBest < this.stopTolHistFun || CMAESOptimizer.max(this.diagD) / CMAESOptimizer.min(this.diagD) > 1.0E7) break;
            if (this.getConvergenceChecker() != null) {
                PointValuePair current = new PointValuePair(bestArx.getColumn(0), this.isMinimize ? bestFitness : -bestFitness);
                if (lastResult != null && this.getConvergenceChecker().converged(this.iterations, current, lastResult)) break;
                lastResult = current;
            }
            if (bestValue == fitness[arindex[(int)(0.1 + (double)this.lambda / 4.0)]]) {
                this.sigma *= FastMath.exp(0.2 + this.cs / this.damps);
            }
            if (this.iterations > 2 && FastMath.max(historyWorst, bestFitness) - FastMath.min(historyBest, bestFitness) == 0.0) {
                this.sigma *= FastMath.exp(0.2 + this.cs / this.damps);
            }
            CMAESOptimizer.push(this.fitnessHistory, bestFitness);
            if (this.generateStatistics) {
                this.statisticsSigmaHistory.add(this.sigma);
                this.statisticsFitnessHistory.add(bestFitness);
                this.statisticsMeanHistory.add(this.xmean.transpose());
                this.statisticsDHistory.add(this.diagD.transpose().scalarMultiply(100000.0));
            }
            ++this.iterations;
        }
        return optimum;
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        for (OptimizationData data : optData) {
            if (data instanceof Sigma) {
                this.inputSigma = ((Sigma)data).getSigma();
                continue;
            }
            if (!(data instanceof PopulationSize)) continue;
            this.lambda = ((PopulationSize)data).getPopulationSize();
        }
        this.checkParameters();
    }

    private void checkParameters() {
        double[] init = this.getStartPoint();
        double[] lB = this.getLowerBound();
        double[] uB = this.getUpperBound();
        if (this.inputSigma != null) {
            if (this.inputSigma.length != init.length) {
                throw new DimensionMismatchException(this.inputSigma.length, init.length);
            }
            for (int i2 = 0; i2 < init.length; ++i2) {
                if (!(this.inputSigma[i2] > uB[i2] - lB[i2])) continue;
                throw new OutOfRangeException(this.inputSigma[i2], (Number)0, uB[i2] - lB[i2]);
            }
        }
    }

    private void initializeCMA(double[] guess) {
        int i2;
        if (this.lambda <= 0) {
            throw new NotStrictlyPositiveException(this.lambda);
        }
        double[][] sigmaArray = new double[guess.length][1];
        for (int i3 = 0; i3 < guess.length; ++i3) {
            sigmaArray[i3][0] = this.inputSigma[i3];
        }
        Array2DRowRealMatrix insigma = new Array2DRowRealMatrix(sigmaArray, false);
        this.sigma = CMAESOptimizer.max(insigma);
        this.stopTolUpX = 1000.0 * CMAESOptimizer.max(insigma);
        this.stopTolX = 1.0E-11 * CMAESOptimizer.max(insigma);
        this.stopTolFun = 1.0E-12;
        this.stopTolHistFun = 1.0E-13;
        this.mu = this.lambda / 2;
        this.logMu2 = FastMath.log((double)this.mu + 0.5);
        this.weights = CMAESOptimizer.log(CMAESOptimizer.sequence(1.0, this.mu, 1.0)).scalarMultiply(-1.0).scalarAdd(this.logMu2);
        double sumw = 0.0;
        double sumwq = 0.0;
        for (i2 = 0; i2 < this.mu; ++i2) {
            double w = this.weights.getEntry(i2, 0);
            sumw += w;
            sumwq += w * w;
        }
        this.weights = this.weights.scalarMultiply(1.0 / sumw);
        this.mueff = sumw * sumw / sumwq;
        this.cc = (4.0 + this.mueff / (double)this.dimension) / ((double)(this.dimension + 4) + 2.0 * this.mueff / (double)this.dimension);
        this.cs = (this.mueff + 2.0) / ((double)this.dimension + this.mueff + 3.0);
        this.damps = (1.0 + 2.0 * FastMath.max(0.0, FastMath.sqrt((this.mueff - 1.0) / (double)(this.dimension + 1)) - 1.0)) * FastMath.max(0.3, 1.0 - (double)this.dimension / (1.0E-6 + (double)this.maxIterations)) + this.cs;
        this.ccov1 = 2.0 / (((double)this.dimension + 1.3) * ((double)this.dimension + 1.3) + this.mueff);
        this.ccovmu = FastMath.min(1.0 - this.ccov1, 2.0 * (this.mueff - 2.0 + 1.0 / this.mueff) / ((double)((this.dimension + 2) * (this.dimension + 2)) + this.mueff));
        this.ccov1Sep = FastMath.min(1.0, this.ccov1 * ((double)this.dimension + 1.5) / 3.0);
        this.ccovmuSep = FastMath.min(1.0 - this.ccov1, this.ccovmu * ((double)this.dimension + 1.5) / 3.0);
        this.chiN = FastMath.sqrt(this.dimension) * (1.0 - 1.0 / (4.0 * (double)this.dimension) + 1.0 / (21.0 * (double)this.dimension * (double)this.dimension));
        this.xmean = MatrixUtils.createColumnRealMatrix(guess);
        this.diagD = insigma.scalarMultiply(1.0 / this.sigma);
        this.diagC = CMAESOptimizer.square(this.diagD);
        this.pc = CMAESOptimizer.zeros(this.dimension, 1);
        this.ps = CMAESOptimizer.zeros(this.dimension, 1);
        this.normps = this.ps.getFrobeniusNorm();
        this.B = CMAESOptimizer.eye(this.dimension, this.dimension);
        this.D = CMAESOptimizer.ones(this.dimension, 1);
        this.BD = CMAESOptimizer.times(this.B, CMAESOptimizer.repmat(this.diagD.transpose(), this.dimension, 1));
        this.C = this.B.multiply(CMAESOptimizer.diag(CMAESOptimizer.square(this.D)).multiply(this.B.transpose()));
        this.historySize = 10 + (int)((double)(30 * this.dimension) / (double)this.lambda);
        this.fitnessHistory = new double[this.historySize];
        for (i2 = 0; i2 < this.historySize; ++i2) {
            this.fitnessHistory[i2] = Double.MAX_VALUE;
        }
    }

    private boolean updateEvolutionPaths(RealMatrix zmean, RealMatrix xold) {
        this.ps = this.ps.scalarMultiply(1.0 - this.cs).add(this.B.multiply(zmean).scalarMultiply(FastMath.sqrt(this.cs * (2.0 - this.cs) * this.mueff)));
        this.normps = this.ps.getFrobeniusNorm();
        boolean hsig = this.normps / FastMath.sqrt(1.0 - FastMath.pow(1.0 - this.cs, 2 * this.iterations)) / this.chiN < 1.4 + 2.0 / ((double)this.dimension + 1.0);
        this.pc = this.pc.scalarMultiply(1.0 - this.cc);
        if (hsig) {
            this.pc = this.pc.add(this.xmean.subtract(xold).scalarMultiply(FastMath.sqrt(this.cc * (2.0 - this.cc) * this.mueff) / this.sigma));
        }
        return hsig;
    }

    private void updateCovarianceDiagonalOnly(boolean hsig, RealMatrix bestArz) {
        double oldFac = hsig ? 0.0 : this.ccov1Sep * this.cc * (2.0 - this.cc);
        this.diagC = this.diagC.scalarMultiply(oldFac += 1.0 - this.ccov1Sep - this.ccovmuSep).add(CMAESOptimizer.square(this.pc).scalarMultiply(this.ccov1Sep)).add(CMAESOptimizer.times(this.diagC, CMAESOptimizer.square(bestArz).multiply(this.weights)).scalarMultiply(this.ccovmuSep));
        this.diagD = CMAESOptimizer.sqrt(this.diagC);
        if (this.diagonalOnly > 1 && this.iterations > this.diagonalOnly) {
            this.diagonalOnly = 0;
            this.B = CMAESOptimizer.eye(this.dimension, this.dimension);
            this.BD = CMAESOptimizer.diag(this.diagD);
            this.C = CMAESOptimizer.diag(this.diagC);
        }
    }

    private void updateCovariance(boolean hsig, RealMatrix bestArx, RealMatrix arz, int[] arindex, RealMatrix xold) {
        double negccov = 0.0;
        if (this.ccov1 + this.ccovmu > 0.0) {
            RealMatrix arpos = bestArx.subtract(CMAESOptimizer.repmat(xold, 1, this.mu)).scalarMultiply(1.0 / this.sigma);
            RealMatrix roneu = this.pc.multiply(this.pc.transpose()).scalarMultiply(this.ccov1);
            double oldFac = hsig ? 0.0 : this.ccov1 * this.cc * (2.0 - this.cc);
            oldFac += 1.0 - this.ccov1 - this.ccovmu;
            if (this.isActiveCMA) {
                int[] idxInv;
                negccov = (1.0 - this.ccovmu) * 0.25 * this.mueff / (FastMath.pow((double)(this.dimension + 2), 1.5) + 2.0 * this.mueff);
                double negminresidualvariance = 0.66;
                double negalphaold = 0.5;
                int[] arReverseIndex = CMAESOptimizer.reverse(arindex);
                RealMatrix arzneg = CMAESOptimizer.selectColumns(arz, MathArrays.copyOf(arReverseIndex, this.mu));
                RealMatrix arnorms = CMAESOptimizer.sqrt(CMAESOptimizer.sumRows(CMAESOptimizer.square(arzneg)));
                int[] idxnorms = this.sortedIndices(arnorms.getRow(0));
                RealMatrix arnormsSorted = CMAESOptimizer.selectColumns(arnorms, idxnorms);
                int[] idxReverse = CMAESOptimizer.reverse(idxnorms);
                RealMatrix arnormsReverse = CMAESOptimizer.selectColumns(arnorms, idxReverse);
                RealMatrix arnormsInv = CMAESOptimizer.selectColumns(arnorms = CMAESOptimizer.divide(arnormsReverse, arnormsSorted), idxInv = CMAESOptimizer.inverse(idxnorms));
                double negcovMax = 0.33999999999999997 / CMAESOptimizer.square(arnormsInv).multiply(this.weights).getEntry(0, 0);
                if (negccov > negcovMax) {
                    negccov = negcovMax;
                }
                arzneg = CMAESOptimizer.times(arzneg, CMAESOptimizer.repmat(arnormsInv, this.dimension, 1));
                RealMatrix artmp = this.BD.multiply(arzneg);
                RealMatrix Cneg = artmp.multiply(CMAESOptimizer.diag(this.weights)).multiply(artmp.transpose());
                this.C = this.C.scalarMultiply(oldFac += 0.5 * negccov).add(roneu).add(arpos.scalarMultiply(this.ccovmu + 0.5 * negccov).multiply(CMAESOptimizer.times(CMAESOptimizer.repmat(this.weights, 1, this.dimension), arpos.transpose()))).subtract(Cneg.scalarMultiply(negccov));
            } else {
                this.C = this.C.scalarMultiply(oldFac).add(roneu).add(arpos.scalarMultiply(this.ccovmu).multiply(CMAESOptimizer.times(CMAESOptimizer.repmat(this.weights, 1, this.dimension), arpos.transpose())));
            }
        }
        this.updateBD(negccov);
    }

    private void updateBD(double negccov) {
        if (this.ccov1 + this.ccovmu + negccov > 0.0 && (double)this.iterations % 1.0 / (this.ccov1 + this.ccovmu + negccov) / (double)this.dimension / 10.0 < 1.0) {
            double tfac;
            this.C = CMAESOptimizer.triu(this.C, 0).add(CMAESOptimizer.triu(this.C, 1).transpose());
            EigenDecomposition eig = new EigenDecomposition(this.C);
            this.B = eig.getV();
            this.D = eig.getD();
            this.diagD = CMAESOptimizer.diag(this.D);
            if (CMAESOptimizer.min(this.diagD) <= 0.0) {
                for (int i2 = 0; i2 < this.dimension; ++i2) {
                    if (!(this.diagD.getEntry(i2, 0) < 0.0)) continue;
                    this.diagD.setEntry(i2, 0, 0.0);
                }
                tfac = CMAESOptimizer.max(this.diagD) / 1.0E14;
                this.C = this.C.add(CMAESOptimizer.eye(this.dimension, this.dimension).scalarMultiply(tfac));
                this.diagD = this.diagD.add(CMAESOptimizer.ones(this.dimension, 1).scalarMultiply(tfac));
            }
            if (CMAESOptimizer.max(this.diagD) > 1.0E14 * CMAESOptimizer.min(this.diagD)) {
                tfac = CMAESOptimizer.max(this.diagD) / 1.0E14 - CMAESOptimizer.min(this.diagD);
                this.C = this.C.add(CMAESOptimizer.eye(this.dimension, this.dimension).scalarMultiply(tfac));
                this.diagD = this.diagD.add(CMAESOptimizer.ones(this.dimension, 1).scalarMultiply(tfac));
            }
            this.diagC = CMAESOptimizer.diag(this.C);
            this.diagD = CMAESOptimizer.sqrt(this.diagD);
            this.BD = CMAESOptimizer.times(this.B, CMAESOptimizer.repmat(this.diagD.transpose(), this.dimension, 1));
        }
    }

    private static void push(double[] vals, double val) {
        for (int i2 = vals.length - 1; i2 > 0; --i2) {
            vals[i2] = vals[i2 - 1];
        }
        vals[0] = val;
    }

    private int[] sortedIndices(double[] doubles) {
        Object[] dis = new DoubleIndex[doubles.length];
        for (int i2 = 0; i2 < doubles.length; ++i2) {
            dis[i2] = new DoubleIndex(doubles[i2], i2);
        }
        Arrays.sort(dis);
        int[] indices = new int[doubles.length];
        for (int i3 = 0; i3 < doubles.length; ++i3) {
            indices[i3] = ((DoubleIndex)dis[i3]).index;
        }
        return indices;
    }

    private double valueRange(ValuePenaltyPair[] vpPairs) {
        double max = Double.NEGATIVE_INFINITY;
        double min = Double.MAX_VALUE;
        for (ValuePenaltyPair vpPair : vpPairs) {
            if (vpPair.value > max) {
                max = vpPair.value;
            }
            if (!(vpPair.value < min)) continue;
            min = vpPair.value;
        }
        return max - min;
    }

    private static RealMatrix log(RealMatrix m2) {
        double[][] d2 = new double[m2.getRowDimension()][m2.getColumnDimension()];
        for (int r2 = 0; r2 < m2.getRowDimension(); ++r2) {
            for (int c2 = 0; c2 < m2.getColumnDimension(); ++c2) {
                d2[r2][c2] = FastMath.log(m2.getEntry(r2, c2));
            }
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static RealMatrix sqrt(RealMatrix m2) {
        double[][] d2 = new double[m2.getRowDimension()][m2.getColumnDimension()];
        for (int r2 = 0; r2 < m2.getRowDimension(); ++r2) {
            for (int c2 = 0; c2 < m2.getColumnDimension(); ++c2) {
                d2[r2][c2] = FastMath.sqrt(m2.getEntry(r2, c2));
            }
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static RealMatrix square(RealMatrix m2) {
        double[][] d2 = new double[m2.getRowDimension()][m2.getColumnDimension()];
        for (int r2 = 0; r2 < m2.getRowDimension(); ++r2) {
            for (int c2 = 0; c2 < m2.getColumnDimension(); ++c2) {
                double e2 = m2.getEntry(r2, c2);
                d2[r2][c2] = e2 * e2;
            }
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static RealMatrix times(RealMatrix m2, RealMatrix n2) {
        double[][] d2 = new double[m2.getRowDimension()][m2.getColumnDimension()];
        for (int r2 = 0; r2 < m2.getRowDimension(); ++r2) {
            for (int c2 = 0; c2 < m2.getColumnDimension(); ++c2) {
                d2[r2][c2] = m2.getEntry(r2, c2) * n2.getEntry(r2, c2);
            }
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static RealMatrix divide(RealMatrix m2, RealMatrix n2) {
        double[][] d2 = new double[m2.getRowDimension()][m2.getColumnDimension()];
        for (int r2 = 0; r2 < m2.getRowDimension(); ++r2) {
            for (int c2 = 0; c2 < m2.getColumnDimension(); ++c2) {
                d2[r2][c2] = m2.getEntry(r2, c2) / n2.getEntry(r2, c2);
            }
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static RealMatrix selectColumns(RealMatrix m2, int[] cols) {
        double[][] d2 = new double[m2.getRowDimension()][cols.length];
        for (int r2 = 0; r2 < m2.getRowDimension(); ++r2) {
            for (int c2 = 0; c2 < cols.length; ++c2) {
                d2[r2][c2] = m2.getEntry(r2, cols[c2]);
            }
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static RealMatrix triu(RealMatrix m2, int k2) {
        double[][] d2 = new double[m2.getRowDimension()][m2.getColumnDimension()];
        for (int r2 = 0; r2 < m2.getRowDimension(); ++r2) {
            for (int c2 = 0; c2 < m2.getColumnDimension(); ++c2) {
                d2[r2][c2] = r2 <= c2 - k2 ? m2.getEntry(r2, c2) : 0.0;
            }
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static RealMatrix sumRows(RealMatrix m2) {
        double[][] d2 = new double[1][m2.getColumnDimension()];
        for (int c2 = 0; c2 < m2.getColumnDimension(); ++c2) {
            double sum = 0.0;
            for (int r2 = 0; r2 < m2.getRowDimension(); ++r2) {
                sum += m2.getEntry(r2, c2);
            }
            d2[0][c2] = sum;
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static RealMatrix diag(RealMatrix m2) {
        if (m2.getColumnDimension() == 1) {
            double[][] d2 = new double[m2.getRowDimension()][m2.getRowDimension()];
            for (int i2 = 0; i2 < m2.getRowDimension(); ++i2) {
                d2[i2][i2] = m2.getEntry(i2, 0);
            }
            return new Array2DRowRealMatrix(d2, false);
        }
        double[][] d3 = new double[m2.getRowDimension()][1];
        for (int i3 = 0; i3 < m2.getColumnDimension(); ++i3) {
            d3[i3][0] = m2.getEntry(i3, i3);
        }
        return new Array2DRowRealMatrix(d3, false);
    }

    private static void copyColumn(RealMatrix m1, int col1, RealMatrix m2, int col2) {
        for (int i2 = 0; i2 < m1.getRowDimension(); ++i2) {
            m2.setEntry(i2, col2, m1.getEntry(i2, col1));
        }
    }

    private static RealMatrix ones(int n2, int m2) {
        double[][] d2 = new double[n2][m2];
        for (int r2 = 0; r2 < n2; ++r2) {
            Arrays.fill(d2[r2], 1.0);
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static RealMatrix eye(int n2, int m2) {
        double[][] d2 = new double[n2][m2];
        for (int r2 = 0; r2 < n2; ++r2) {
            if (r2 >= m2) continue;
            d2[r2][r2] = 1.0;
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static RealMatrix zeros(int n2, int m2) {
        return new Array2DRowRealMatrix(n2, m2);
    }

    private static RealMatrix repmat(RealMatrix mat, int n2, int m2) {
        int rd = mat.getRowDimension();
        int cd = mat.getColumnDimension();
        double[][] d2 = new double[n2 * rd][m2 * cd];
        for (int r2 = 0; r2 < n2 * rd; ++r2) {
            for (int c2 = 0; c2 < m2 * cd; ++c2) {
                d2[r2][c2] = mat.getEntry(r2 % rd, c2 % cd);
            }
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static RealMatrix sequence(double start, double end, double step) {
        int size = (int)((end - start) / step + 1.0);
        double[][] d2 = new double[size][1];
        double value = start;
        for (int r2 = 0; r2 < size; ++r2) {
            d2[r2][0] = value;
            value += step;
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private static double max(RealMatrix m2) {
        double max = -1.7976931348623157E308;
        for (int r2 = 0; r2 < m2.getRowDimension(); ++r2) {
            for (int c2 = 0; c2 < m2.getColumnDimension(); ++c2) {
                double e2 = m2.getEntry(r2, c2);
                if (!(max < e2)) continue;
                max = e2;
            }
        }
        return max;
    }

    private static double min(RealMatrix m2) {
        double min = Double.MAX_VALUE;
        for (int r2 = 0; r2 < m2.getRowDimension(); ++r2) {
            for (int c2 = 0; c2 < m2.getColumnDimension(); ++c2) {
                double e2 = m2.getEntry(r2, c2);
                if (!(min > e2)) continue;
                min = e2;
            }
        }
        return min;
    }

    private static double max(double[] m2) {
        double max = -1.7976931348623157E308;
        for (int r2 = 0; r2 < m2.length; ++r2) {
            if (!(max < m2[r2])) continue;
            max = m2[r2];
        }
        return max;
    }

    private static double min(double[] m2) {
        double min = Double.MAX_VALUE;
        for (int r2 = 0; r2 < m2.length; ++r2) {
            if (!(min > m2[r2])) continue;
            min = m2[r2];
        }
        return min;
    }

    private static int[] inverse(int[] indices) {
        int[] inverse = new int[indices.length];
        for (int i2 = 0; i2 < indices.length; ++i2) {
            inverse[indices[i2]] = i2;
        }
        return inverse;
    }

    private static int[] reverse(int[] indices) {
        int[] reverse = new int[indices.length];
        for (int i2 = 0; i2 < indices.length; ++i2) {
            reverse[i2] = indices[indices.length - i2 - 1];
        }
        return reverse;
    }

    private double[] randn(int size) {
        double[] randn = new double[size];
        for (int i2 = 0; i2 < size; ++i2) {
            randn[i2] = this.random.nextGaussian();
        }
        return randn;
    }

    private RealMatrix randn1(int size, int popSize) {
        double[][] d2 = new double[size][popSize];
        for (int r2 = 0; r2 < size; ++r2) {
            for (int c2 = 0; c2 < popSize; ++c2) {
                d2[r2][c2] = this.random.nextGaussian();
            }
        }
        return new Array2DRowRealMatrix(d2, false);
    }

    private class FitnessFunction {
        private final boolean isRepairMode;

        FitnessFunction() {
            this.isRepairMode = true;
        }

        public ValuePenaltyPair value(double[] point) {
            double value;
            double penalty = 0.0;
            if (this.isRepairMode) {
                double[] repaired = this.repair(point);
                value = CMAESOptimizer.this.computeObjectiveValue(repaired);
                penalty = this.penalty(point, repaired);
            } else {
                value = CMAESOptimizer.this.computeObjectiveValue(point);
            }
            value = CMAESOptimizer.this.isMinimize ? value : -value;
            penalty = CMAESOptimizer.this.isMinimize ? penalty : -penalty;
            return new ValuePenaltyPair(value, penalty);
        }

        public boolean isFeasible(double[] x) {
            double[] lB = CMAESOptimizer.this.getLowerBound();
            double[] uB = CMAESOptimizer.this.getUpperBound();
            for (int i2 = 0; i2 < x.length; ++i2) {
                if (x[i2] < lB[i2]) {
                    return false;
                }
                if (!(x[i2] > uB[i2])) continue;
                return false;
            }
            return true;
        }

        private double[] repair(double[] x) {
            double[] lB = CMAESOptimizer.this.getLowerBound();
            double[] uB = CMAESOptimizer.this.getUpperBound();
            double[] repaired = new double[x.length];
            for (int i2 = 0; i2 < x.length; ++i2) {
                repaired[i2] = x[i2] < lB[i2] ? lB[i2] : (x[i2] > uB[i2] ? uB[i2] : x[i2]);
            }
            return repaired;
        }

        private double penalty(double[] x, double[] repaired) {
            double penalty = 0.0;
            for (int i2 = 0; i2 < x.length; ++i2) {
                double diff = FastMath.abs(x[i2] - repaired[i2]);
                penalty += diff;
            }
            return CMAESOptimizer.this.isMinimize ? penalty : -penalty;
        }
    }

    private static class ValuePenaltyPair {
        private double value;
        private double penalty;

        ValuePenaltyPair(double value, double penalty) {
            this.value = value;
            this.penalty = penalty;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleIndex
    implements Comparable<DoubleIndex> {
        private final double value;
        private final int index;

        DoubleIndex(double value, int index) {
            this.value = value;
            this.index = index;
        }

        @Override
        public int compareTo(DoubleIndex o2) {
            return Double.compare(this.value, o2.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof DoubleIndex) {
                return Double.compare(this.value, ((DoubleIndex)other).value) == 0;
            }
            return false;
        }

        public int hashCode() {
            long bits = Double.doubleToLongBits(this.value);
            return (int)((0x15F34EL ^ bits >>> 32 ^ bits) & 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static class PopulationSize
    implements OptimizationData {
        private final int lambda;

        public PopulationSize(int size) throws NotStrictlyPositiveException {
            if (size <= 0) {
                throw new NotStrictlyPositiveException(size);
            }
            this.lambda = size;
        }

        public int getPopulationSize() {
            return this.lambda;
        }
    }

    public static class Sigma
    implements OptimizationData {
        private final double[] sigma;

        public Sigma(double[] s2) throws NotPositiveException {
            for (int i2 = 0; i2 < s2.length; ++i2) {
                if (!(s2[i2] < 0.0)) continue;
                throw new NotPositiveException(s2[i2]);
            }
            this.sigma = (double[])s2.clone();
        }

        public double[] getSigma() {
            return (double[])this.sigma.clone();
        }
    }
}

