/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.security.SecurityUtil;

public class JspWriterImpl
extends JspWriter {
    private Writer out;
    private ServletResponse response;
    private char[] cb;
    private int nextChar;
    private boolean flushed = false;
    private boolean closed = false;

    public JspWriterImpl() {
        super(8192, true);
    }

    public JspWriterImpl(ServletResponse response, int sz, boolean autoFlush) {
        super(sz, autoFlush);
        if (sz < 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.response = response;
        this.cb = sz == 0 ? null : new char[sz];
        this.nextChar = 0;
    }

    void init(ServletResponse response, int sz, boolean autoFlush) {
        this.response = response;
        if (sz > 0 && (this.cb == null || sz > this.cb.length)) {
            this.cb = new char[sz];
        }
        this.nextChar = 0;
        this.autoFlush = autoFlush;
        this.bufferSize = sz;
    }

    void recycle() {
        this.flushed = false;
        this.closed = false;
        this.out = null;
        this.nextChar = 0;
        this.response = null;
    }

    protected final void flushBuffer() throws IOException {
        if (this.bufferSize == 0) {
            return;
        }
        this.flushed = true;
        this.ensureOpen();
        if (this.nextChar == 0) {
            return;
        }
        this.initOut();
        this.out.write(this.cb, 0, this.nextChar);
        this.nextChar = 0;
    }

    private void initOut() throws IOException {
        if (this.out == null) {
            this.out = this.response.getWriter();
        }
    }

    private String getLocalizeMessage(final String message) {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Localizer.getMessage(message);
                }
            });
        }
        return Localizer.getMessage(message);
    }

    @Override
    public final void clear() throws IOException {
        if (this.bufferSize == 0 && this.out != null) {
            throw new IllegalStateException(this.getLocalizeMessage("jsp.error.ise_on_clear"));
        }
        if (this.flushed) {
            throw new IOException(this.getLocalizeMessage("jsp.error.attempt_to_clear_flushed_buffer"));
        }
        this.ensureOpen();
        this.nextChar = 0;
    }

    @Override
    public void clearBuffer() throws IOException {
        if (this.bufferSize == 0) {
            throw new IllegalStateException(this.getLocalizeMessage("jsp.error.ise_on_clear"));
        }
        this.ensureOpen();
        this.nextChar = 0;
    }

    private final void bufferOverflow() throws IOException {
        throw new IOException(this.getLocalizeMessage("jsp.error.overflow"));
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.response == null || this.closed) {
            return;
        }
        this.flush();
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.closed = true;
    }

    @Override
    public int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    private void ensureOpen() throws IOException {
        if (this.response == null || this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void write(int c2) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(c2);
        } else {
            if (this.nextChar >= this.bufferSize) {
                if (this.autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
            }
            this.cb[this.nextChar++] = (char)c2;
        }
    }

    private static int min(int a2, int b2) {
        if (a2 < b2) {
            return a2;
        }
        return b2;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(cbuf, off, len);
            return;
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len >= this.bufferSize) {
            if (this.autoFlush) {
                this.flushBuffer();
            } else {
                this.bufferOverflow();
            }
            this.initOut();
            this.out.write(cbuf, off, len);
            return;
        }
        int b2 = off;
        int t = off + len;
        while (b2 < t) {
            int d2 = JspWriterImpl.min(this.bufferSize - this.nextChar, t - b2);
            System.arraycopy(cbuf, b2, this.cb, this.nextChar, d2);
            b2 += d2;
            this.nextChar += d2;
            if (this.nextChar < this.bufferSize) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    @Override
    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(String s2, int off, int len) throws IOException {
        this.ensureOpen();
        if (this.bufferSize == 0) {
            this.initOut();
            this.out.write(s2, off, len);
            return;
        }
        int b2 = off;
        int t = off + len;
        while (b2 < t) {
            int d2 = JspWriterImpl.min(this.bufferSize - this.nextChar, t - b2);
            s2.getChars(b2, b2 + d2, this.cb, this.nextChar);
            b2 += d2;
            this.nextChar += d2;
            if (this.nextChar < this.bufferSize) continue;
            if (this.autoFlush) {
                this.flushBuffer();
                continue;
            }
            this.bufferOverflow();
        }
    }

    @Override
    public void newLine() throws IOException {
        this.write(System.lineSeparator());
    }

    @Override
    public void print(boolean b2) throws IOException {
        this.write(b2 ? "true" : "false");
    }

    @Override
    public void print(char c2) throws IOException {
        this.write(String.valueOf(c2));
    }

    @Override
    public void print(int i2) throws IOException {
        this.write(String.valueOf(i2));
    }

    @Override
    public void print(long l2) throws IOException {
        this.write(String.valueOf(l2));
    }

    @Override
    public void print(float f2) throws IOException {
        this.write(String.valueOf(f2));
    }

    @Override
    public void print(double d2) throws IOException {
        this.write(String.valueOf(d2));
    }

    @Override
    public void print(char[] s2) throws IOException {
        this.write(s2);
    }

    @Override
    public void print(String s2) throws IOException {
        if (s2 == null) {
            s2 = "null";
        }
        this.write(s2);
    }

    @Override
    public void print(Object obj) throws IOException {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() throws IOException {
        this.newLine();
    }

    @Override
    public void println(boolean x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(int x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(long x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(float x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(double x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char[] x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(String x) throws IOException {
        this.print(x);
        this.println();
    }

    @Override
    public void println(Object x) throws IOException {
        this.print(x);
        this.println();
    }
}

