/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspectj.util.LangUtil;

public class FileUtil {
    public static final File DEFAULT_PARENT = new File(".");
    public static final List SOURCE_SUFFIXES = Collections.unmodifiableList(Arrays.asList(".java", ".aj"));
    public static final FileFilter ZIP_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return FileUtil.isZipFile(file);
        }

        public String toString() {
            return "ZIP_FILTER";
        }
    };
    static final int[] INT_RA = new int[0];
    public static final FileFilter ALL = new FileFilter(){

        public boolean accept(File f2) {
            return true;
        }
    };
    public static final FileFilter DIRS_AND_WRITABLE_CLASSES = new FileFilter(){

        public boolean accept(File file) {
            return null != file && (file.isDirectory() || file.canWrite() && file.getName().toLowerCase().endsWith(".class"));
        }
    };
    private static final boolean PERMIT_CVS;
    public static final FileFilter aspectjSourceFileFilter;
    static final String FILECHARS = "abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    static /* synthetic */ Class class$org$aspectj$util$FileUtil;

    public static boolean isZipFile(File file) {
        try {
            return null != file && new ZipFile(file) != null;
        }
        catch (IOException e2) {
            return false;
        }
    }

    public static int zipSuffixLength(File file) {
        return null == file ? 0 : FileUtil.zipSuffixLength(file.getPath());
    }

    public static int zipSuffixLength(String path) {
        String test;
        if (null != path && 4 < path.length() && (".zip".equals(test = path.substring(path.length() - 4).toLowerCase()) || ".jar".equals(test))) {
            return 4;
        }
        return 0;
    }

    public static boolean hasSourceSuffix(File file) {
        return null != file && FileUtil.hasSourceSuffix(file.getPath());
    }

    public static boolean hasSourceSuffix(String path) {
        return null != path && 0 != FileUtil.sourceSuffixLength(path);
    }

    public static int sourceSuffixLength(File file) {
        return null == file ? 0 : FileUtil.sourceSuffixLength(file.getPath());
    }

    public static int sourceSuffixLength(String path) {
        if (LangUtil.isEmpty(path)) {
            return 0;
        }
        Iterator iter = SOURCE_SUFFIXES.iterator();
        while (iter.hasNext()) {
            String suffix = (String)iter.next();
            if (!path.endsWith(suffix) && !path.toLowerCase().endsWith(suffix)) continue;
            return suffix.length();
        }
        return 0;
    }

    public static boolean canReadDir(File dir) {
        return null != dir && dir.canRead() && dir.isDirectory();
    }

    public static boolean canReadFile(File file) {
        return null != file && file.canRead() && file.isFile();
    }

    public static boolean canWriteDir(File dir) {
        return null != dir && dir.canWrite() && dir.isDirectory();
    }

    public static boolean canWriteFile(File file) {
        return null != file && file.canWrite() && file.isFile();
    }

    public static void throwIaxUnlessCanReadDir(File dir, String label) {
        if (!FileUtil.canReadDir(dir)) {
            throw new IllegalArgumentException(label + " not readable dir: " + dir);
        }
    }

    public static void throwIaxUnlessCanWriteFile(File file, String label) {
        if (!FileUtil.canWriteFile(file)) {
            throw new IllegalArgumentException(label + " not writable file: " + file);
        }
    }

    public static void throwIaxUnlessCanWriteDir(File dir, String label) {
        if (!FileUtil.canWriteDir(dir)) {
            throw new IllegalArgumentException(label + " not writable dir: " + dir);
        }
    }

    public static String[] getPaths(File[] files) {
        if (null == files || 0 == files.length) {
            return new String[0];
        }
        String[] result = new String[files.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            if (null == files[i2]) continue;
            result[i2] = files[i2].getPath();
        }
        return result;
    }

    public static String[] getPaths(List files) {
        int size;
        int n2 = size = null == files ? 0 : files.size();
        if (0 == size) {
            return new String[0];
        }
        String[] result = new String[size];
        for (int i2 = 0; i2 < size; ++i2) {
            File file = (File)files.get(i2);
            if (null == file) continue;
            result[i2] = file.getPath();
        }
        return result;
    }

    public static String fileToClassName(File basedir, File classFile) {
        LangUtil.throwIaxIfNull(classFile, "classFile");
        String classFilePath = FileUtil.normalizedPath(classFile);
        if (!classFilePath.endsWith(".class")) {
            String m2 = classFile + " does not end with .class";
            throw new IllegalArgumentException(m2);
        }
        classFilePath = classFilePath.substring(0, classFilePath.length() - 6);
        if (null != basedir) {
            String basePath = FileUtil.normalizedPath(basedir);
            if (!classFilePath.startsWith(basePath)) {
                String m3 = classFile + " does not start with " + basedir;
                throw new IllegalArgumentException(m3);
            }
            classFilePath = classFilePath.substring(basePath.length() + 1);
        } else {
            int loc;
            String[] suffixes = new String[]{"com", "org", "java", "javax"};
            boolean found = false;
            for (int i2 = 0; !found && i2 < suffixes.length; ++i2) {
                int loc2 = classFilePath.indexOf(suffixes[i2] + "/");
                if (0 != loc2 && (-1 == loc2 || '/' != classFilePath.charAt(loc2 - 1))) continue;
                classFilePath = classFilePath.substring(loc2);
                found = true;
            }
            if (!found && -1 != (loc = classFilePath.lastIndexOf("/"))) {
                classFilePath = classFilePath.substring(loc + 1);
            }
        }
        return classFilePath.replace('/', '.');
    }

    public static String normalizedPath(File file, File basedir) {
        String basePath;
        String filePath = FileUtil.normalizedPath(file);
        if (null != basedir && filePath.startsWith(basePath = FileUtil.normalizedPath(basedir)) && (filePath = filePath.substring(basePath.length())).startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return filePath;
    }

    public static String flatten(File[] files, String infix) {
        if (LangUtil.isEmpty(files)) {
            return "";
        }
        return FileUtil.flatten(FileUtil.getPaths(files), infix);
    }

    public static String flatten(String[] paths, String infix) {
        if (null == infix) {
            infix = File.pathSeparator;
        }
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String path = paths[i2];
            if (null == path) continue;
            if (first) {
                first = false;
            } else {
                result.append(infix);
            }
            result.append(path);
        }
        return result.toString();
    }

    public static String normalizedPath(File file) {
        return null == file ? "" : FileUtil.weakNormalize(file.getAbsolutePath());
    }

    public static String weakNormalize(String path) {
        if (null != path) {
            path = path.replace('\\', '/').trim();
        }
        return path;
    }

    public static File getBestFile(String[] paths) {
        if (null == paths) {
            return null;
        }
        File result = null;
        for (int i2 = 0; null == result && i2 < paths.length; ++i2) {
            String path = paths[i2];
            if (null == path) continue;
            if (path.startsWith("sp:")) {
                try {
                    path = System.getProperty(path.substring(3));
                }
                catch (Throwable t) {
                    path = null;
                }
                if (null == path) continue;
            }
            try {
                File f2 = new File(path);
                if (!f2.exists() || !f2.canRead()) continue;
                result = FileUtil.getBestFile(f2);
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return result;
    }

    public static File getBestFile(File file) {
        LangUtil.throwIaxIfNull(file, "file");
        if (file.exists()) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException e2) {
                return file.getAbsoluteFile();
            }
        }
        return file;
    }

    public static String getBestPath(File file) {
        LangUtil.throwIaxIfNull(file, "file");
        if (file.exists()) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e2) {
                return file.getAbsolutePath();
            }
        }
        return file.getPath();
    }

    public static String[] getAbsolutePaths(File[] files) {
        if (null == files || 0 == files.length) {
            return new String[0];
        }
        String[] result = new String[files.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            if (null == files[i2]) continue;
            result[i2] = files[i2].getAbsolutePath();
        }
        return result;
    }

    public static int deleteContents(File dir) {
        return FileUtil.deleteContents(dir, ALL);
    }

    public static int deleteContents(File dir, FileFilter filter) {
        return FileUtil.deleteContents(dir, filter, true);
    }

    public static int deleteContents(File dir, FileFilter filter, boolean deleteEmptyDirs) {
        if (null == dir) {
            throw new IllegalArgumentException("null dir");
        }
        if (!dir.exists() || !dir.canWrite()) {
            return 0;
        }
        if (!dir.isDirectory()) {
            dir.delete();
            return 1;
        }
        String[] fromFiles = dir.list();
        int result = 0;
        for (int i2 = 0; i2 < fromFiles.length; ++i2) {
            String string = fromFiles[i2];
            File file = new File(dir, string);
            if (null != filter && !filter.accept(file)) continue;
            if (file.isDirectory()) {
                result += FileUtil.deleteContents(file, filter, deleteEmptyDirs);
                if (!deleteEmptyDirs || 0 != file.list().length) continue;
                file.delete();
                continue;
            }
            file.delete();
            ++result;
        }
        return result;
    }

    public static int copyDir(File fromDir, File toDir) throws IOException {
        return FileUtil.copyDir(fromDir, toDir, null, null);
    }

    public static int copyDir(File fromDir, File toDir, String fromSuffix, String toSuffix) throws IOException {
        return FileUtil.copyDir(fromDir, toDir, fromSuffix, toSuffix, null);
    }

    public static int copyDir(File fromDir, File toDir, final String fromSuffix, String toSuffix, FileFilter delegate) throws IOException {
        String[] fromFiles;
        int slen;
        if (null == fromDir || !fromDir.canRead()) {
            return 0;
        }
        boolean haveSuffix = null != fromSuffix && 0 < fromSuffix.length();
        int n2 = slen = !haveSuffix ? 0 : fromSuffix.length();
        if (!toDir.exists()) {
            toDir.mkdirs();
        }
        if (!haveSuffix) {
            fromFiles = fromDir.list();
        } else {
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return new File(dir, name).isDirectory() || name.endsWith(fromSuffix);
                }
            };
            fromFiles = fromDir.list(filter);
        }
        int result = 0;
        int MAX = null == fromFiles ? 0 : fromFiles.length;
        for (int i2 = 0; i2 < MAX; ++i2) {
            String filename = fromFiles[i2];
            File fromFile = new File(fromDir, filename);
            if (!fromFile.canRead()) continue;
            if (fromFile.isDirectory()) {
                result += FileUtil.copyDir(fromFile, new File(toDir, filename), fromSuffix, toSuffix, delegate);
                continue;
            }
            if (!fromFile.isFile()) continue;
            if (haveSuffix) {
                filename = filename.substring(0, filename.length() - slen);
            }
            if (null != toSuffix) {
                filename = filename + toSuffix;
            }
            File targetFile = new File(toDir, filename);
            if (null == delegate || delegate.accept(targetFile)) {
                FileUtil.copyFile(fromFile, targetFile);
            }
            ++result;
        }
        return result;
    }

    public static String[] listFiles(File srcDir) {
        ArrayList result = new ArrayList();
        if (null != srcDir && srcDir.canRead()) {
            FileUtil.listFiles(srcDir, null, result);
        }
        return result.toArray(new String[0]);
    }

    public static File[] listFiles(File srcDir, FileFilter fileFilter) {
        ArrayList result = new ArrayList();
        if (null != srcDir && srcDir.canRead()) {
            FileUtil.listFiles(srcDir, result, fileFilter);
        }
        return result.toArray(new File[result.size()]);
    }

    public static List listClassFiles(File dir) {
        ArrayList result = new ArrayList();
        if (null != dir && dir.canRead()) {
            FileUtil.listClassFiles(dir, result);
        }
        return result;
    }

    public static File[] getBaseDirFiles(File basedir, String[] paths) {
        return FileUtil.getBaseDirFiles(basedir, paths, null);
    }

    public static File[] getBaseDirFiles(File basedir, String[] paths, String[] suffixes) {
        LangUtil.throwIaxIfNull(basedir, "basedir");
        LangUtil.throwIaxIfNull(paths, "paths");
        File[] result = null;
        if (!LangUtil.isEmpty(suffixes)) {
            ArrayList<File> list = new ArrayList<File>();
            block0: for (int i2 = 0; i2 < paths.length; ++i2) {
                String path = paths[i2];
                for (int j2 = 0; j2 < suffixes.length; ++j2) {
                    if (!path.endsWith(suffixes[j2])) continue;
                    list.add(new File(basedir, paths[i2]));
                    continue block0;
                }
            }
            result = list.toArray(new File[0]);
        } else {
            result = new File[paths.length];
            for (int i3 = 0; i3 < result.length; ++i3) {
                result[i3] = FileUtil.newFile(basedir, paths[i3]);
            }
        }
        return result;
    }

    private static File newFile(File dir, String path) {
        if (".".equals(path)) {
            return dir;
        }
        if ("..".equals(path)) {
            File parentDir = dir.getParentFile();
            if (null != parentDir) {
                return parentDir;
            }
            return new File(dir, "..");
        }
        return new File(dir, path);
    }

    public static File[] copyFiles(File srcDir, String[] relativePaths, File destDir) throws IllegalArgumentException, IOException {
        String[] paths = relativePaths;
        FileUtil.throwIaxUnlessCanReadDir(srcDir, "srcDir");
        FileUtil.throwIaxUnlessCanWriteDir(destDir, "destDir");
        LangUtil.throwIaxIfNull(paths, "relativePaths");
        File[] result = new File[paths.length];
        for (int i2 = 0; i2 < paths.length; ++i2) {
            String path = paths[i2];
            LangUtil.throwIaxIfNull(path, "relativePaths-entry");
            File src = FileUtil.newFile(srcDir, paths[i2]);
            File dest = FileUtil.newFile(destDir, path);
            File destParent = dest.getParentFile();
            if (!destParent.exists()) {
                destParent.mkdirs();
            }
            LangUtil.throwIaxIfFalse(FileUtil.canWriteDir(destParent), "dest-entry-parent");
            FileUtil.copyFile(src, dest);
            result[i2] = dest;
        }
        return result;
    }

    public static void copyFile(File fromFile, File toFile) throws IOException {
        LangUtil.throwIaxIfNull(fromFile, "fromFile");
        LangUtil.throwIaxIfNull(toFile, "toFile");
        LangUtil.throwIaxIfFalse(!toFile.equals(fromFile), "same file");
        if (toFile.isDirectory()) {
            FileUtil.throwIaxUnlessCanWriteDir(toFile, "toFile");
            if (fromFile.isFile()) {
                File targFile = new File(toFile, fromFile.getName());
                FileUtil.copyValidFiles(fromFile, targFile);
            } else if (fromFile.isDirectory()) {
                FileUtil.copyDir(fromFile, toFile);
            } else {
                LangUtil.throwIaxIfFalse(false, "not dir or file: " + fromFile);
            }
        } else if (toFile.isFile()) {
            if (fromFile.isDirectory()) {
                LangUtil.throwIaxIfFalse(false, "can't copy to file dir: " + fromFile);
            }
            FileUtil.copyValidFiles(fromFile, toFile);
        } else {
            FileUtil.ensureParentWritable(toFile);
            if (fromFile.isFile()) {
                FileUtil.copyValidFiles(fromFile, toFile);
            } else if (fromFile.isDirectory()) {
                toFile.mkdirs();
                FileUtil.throwIaxUnlessCanWriteDir(toFile, "toFile");
                FileUtil.copyDir(fromFile, toFile);
            } else {
                LangUtil.throwIaxIfFalse(false, "not dir or file: " + fromFile);
            }
        }
    }

    public static File ensureParentWritable(File path) {
        LangUtil.throwIaxIfNull(path, "path");
        File pathParent = path.getParentFile();
        if (null == pathParent) {
            pathParent = DEFAULT_PARENT;
        }
        if (!pathParent.canWrite()) {
            pathParent.mkdirs();
        }
        FileUtil.throwIaxUnlessCanWriteDir(pathParent, "pathParent");
        return pathParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyValidFiles(File fromFile, File toFile) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(fromFile);
            out = new FileOutputStream(toFile);
            FileUtil.copyStream(in, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public static void copyStream(DataInputStream in, PrintStream out) throws IOException {
        String s2;
        LangUtil.throwIaxIfNull(in, "in");
        LangUtil.throwIaxIfNull(in, "out");
        while (null != (s2 = in.readLine())) {
            out.println(s2);
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int MAX = 4096;
        byte[] buf = new byte[4096];
        int bytesRead = in.read(buf, 0, 4096);
        while (bytesRead != -1) {
            out.write(buf, 0, bytesRead);
            bytesRead = in.read(buf, 0, 4096);
        }
    }

    public static void copyStream(Reader in, Writer out) throws IOException {
        int MAX = 4096;
        char[] buf = new char[4096];
        int bytesRead = in.read(buf, 0, 4096);
        while (bytesRead != -1) {
            out.write(buf, 0, bytesRead);
            bytesRead = in.read(buf, 0, 4096);
        }
    }

    public static File makeNewChildDir(File parent, String child) {
        if (null == parent || !parent.canWrite() || !parent.isDirectory()) {
            throw new IllegalArgumentException("bad parent: " + parent);
        }
        if (null == child) {
            child = "makeNewChildDir";
        } else if (!FileUtil.isValidFileName(child)) {
            throw new IllegalArgumentException("bad child: " + child);
        }
        File result = new File(parent, child);
        int safety = 1000;
        String suffix = FileUtil.randomFileString();
        while (0 < --safety && result.exists()) {
            result = new File(parent, child + suffix);
            suffix = FileUtil.randomFileString();
        }
        if (result.exists()) {
            System.err.println("exhausted files for child dir in " + parent);
            return null;
        }
        return result.mkdirs() && result.exists() ? result : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempDir(String name) {
        if (null == name) {
            name = "FileUtil_getTempDir";
        } else if (!FileUtil.isValidFileName(name)) {
            throw new IllegalArgumentException(" invalid: " + name);
        }
        File result = null;
        File tempFile = null;
        try {
            tempFile = File.createTempFile("ignoreMe", ".txt");
            File tempParent = tempFile.getParentFile();
            result = FileUtil.makeNewChildDir(tempParent, name);
        }
        catch (IOException t) {
            result = FileUtil.makeNewChildDir(new File("."), name);
        }
        finally {
            if (null != tempFile) {
                tempFile.delete();
            }
        }
        return result;
    }

    public static URL[] getFileURLs(File[] files) {
        if (null == files || 0 == files.length) {
            return new URL[0];
        }
        URL[] result = new URL[files.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = FileUtil.getFileURL(files[i2]);
        }
        return result;
    }

    public static URL getFileURL(File file) {
        LangUtil.throwIaxIfNull(file, "file");
        URL result = null;
        try {
            result = file.toURL();
            if (null != result) {
                return result;
            }
            String url = "file:" + file.getAbsolutePath().replace('\\', '/');
            result = new URL(url + (file.isDirectory() ? "/" : ""));
        }
        catch (MalformedURLException e2) {
            String m2 = "Util.makeURL(\"" + file.getPath() + "\" MUE " + e2.getMessage();
            System.err.println(m2);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeAsString(File file, String contents) {
        String e2;
        LangUtil.throwIaxIfNull(file, "file");
        if (null == contents) {
            contents = "";
        }
        Writer out = null;
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                String string = "unable to make parent dir for " + file;
                return string;
            }
            StringReader in = new StringReader(contents);
            out = new FileWriter(file);
            FileUtil.copyStream(in, out);
            e2 = null;
        }
        catch (IOException e3) {
            String string = LangUtil.unqualifiedClassName(e3) + " writing " + file + ": " + e3.getMessage();
            return string;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e4) {}
            }
        }
        return e2;
    }

    public static boolean[] readBooleanArray(DataInputStream s2) throws IOException {
        int len = s2.readInt();
        boolean[] ret = new boolean[len];
        for (int i2 = 0; i2 < len; ++i2) {
            ret[i2] = s2.readBoolean();
        }
        return ret;
    }

    public static void writeBooleanArray(boolean[] a2, DataOutputStream s2) throws IOException {
        int len = a2.length;
        s2.writeInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            s2.writeBoolean(a2[i2]);
        }
    }

    public static int[] readIntArray(DataInputStream s2) throws IOException {
        int len = s2.readInt();
        int[] ret = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            ret[i2] = s2.readInt();
        }
        return ret;
    }

    public static void writeIntArray(int[] a2, DataOutputStream s2) throws IOException {
        int len = a2.length;
        s2.writeInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            s2.writeInt(a2[i2]);
        }
    }

    public static String[] readStringArray(DataInputStream s2) throws IOException {
        int len = s2.readInt();
        String[] ret = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            ret[i2] = s2.readUTF();
        }
        return ret;
    }

    public static void writeStringArray(String[] a2, DataOutputStream s2) throws IOException {
        if (a2 == null) {
            s2.writeInt(0);
            return;
        }
        int len = a2.length;
        s2.writeInt(len);
        for (int i2 = 0; i2 < len; ++i2) {
            s2.writeUTF(a2[i2]);
        }
    }

    public static String readAsString(File file) throws IOException {
        int ch;
        BufferedReader r2 = new BufferedReader(new FileReader(file));
        StringBuffer b2 = new StringBuffer();
        while ((ch = r2.read()) != -1) {
            b2.append((char)ch);
        }
        r2.close();
        return b2.toString();
    }

    public static byte[] readAsByteArray(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        byte[] ret = FileUtil.readAsByteArray(in);
        in.close();
        return ret;
    }

    public static byte[] readAsByteArray(InputStream inStream) throws IOException {
        int nRead;
        int size = 1024;
        byte[] ba = new byte[size];
        int readSoFar = 0;
        while ((nRead = inStream.read(ba, readSoFar, size - readSoFar)) != -1) {
            if ((readSoFar += nRead) != size) continue;
            int newSize = size * 2;
            byte[] newBa = new byte[newSize];
            System.arraycopy(ba, 0, newBa, 0, size);
            ba = newBa;
            size = newSize;
        }
        byte[] newBa = new byte[readSoFar];
        System.arraycopy(ba, 0, newBa, 0, readSoFar);
        return newBa;
    }

    static String randomFileString() {
        double FILECHARS_length = FILECHARS.length();
        int LEN = 6;
        char[] result = new char[6];
        int index = (int)(Math.random() * 6.0);
        for (int i2 = 0; i2 < 6; ++i2) {
            if (index >= 6) {
                index = 0;
            }
            result[index++] = FILECHARS.charAt((int)(Math.random() * FILECHARS_length));
        }
        return new String(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getStreamFromZip(String zipFile, String name) {
        ZipFile zf = new ZipFile(zipFile);
        try {
            ZipEntry entry = zf.getEntry(name);
            InputStream inputStream = zf.getInputStream(entry);
            return inputStream;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (IOException ioe) {
                return null;
            }
        }
    }

    public static List lineSeek(String sought, List sources, boolean listAll, PrintStream errorSink) {
        if (LangUtil.isEmpty(sought) || LangUtil.isEmpty(sources)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        Iterator iter = sources.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            String error = FileUtil.lineSeek(sought, path, listAll, result);
            if (null == error || null == errorSink) continue;
            errorSink.println(error);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lineSeek(String sought, String sourcePath, boolean listAll, ArrayList sink) {
        if (LangUtil.isEmpty(sought) || LangUtil.isEmpty(sourcePath)) {
            return "nothing sought";
        }
        if (LangUtil.isEmpty(sourcePath)) {
            return "no sourcePath";
        }
        File file = new File(sourcePath);
        if (!file.canRead() || !file.isFile()) {
            return "sourcePath not a readable file";
        }
        int lineNum = 0;
        FileReader fin = null;
        try {
            String line;
            fin = new FileReader(file);
            BufferedReader reader = new BufferedReader(fin);
            while (null != (line = reader.readLine())) {
                ++lineNum;
                int loc = line.indexOf(sought);
                if (-1 == loc) continue;
                sink.add(sourcePath + ":" + lineNum + ":" + loc);
                if (listAll) continue;
                break;
            }
        }
        catch (IOException e2) {
            String string = LangUtil.unqualifiedClassName(e2) + " reading " + sourcePath + ":" + lineNum;
            return string;
        }
        finally {
            try {
                if (null != fin) {
                    fin.close();
                }
            }
            catch (IOException e3) {}
        }
        return null;
    }

    public static BufferedOutputStream makeOutputStream(File file) throws FileNotFoundException {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public static boolean sleepPastFinalModifiedTime(File[] files) {
        if (null == files || 0 == files.length) {
            return true;
        }
        long delayUntil = System.currentTimeMillis();
        for (int i2 = 0; i2 < files.length; ++i2) {
            long nextModTime;
            File file = files[i2];
            if (null == file || !file.exists() || (nextModTime = file.lastModified()) <= delayUntil) continue;
            delayUntil = nextModTime;
        }
        return LangUtil.sleepUntil(++delayUntil);
    }

    private static void listClassFiles(File baseDir, ArrayList result) {
        File[] files = baseDir.listFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            File f2 = files[i2];
            if (f2.isDirectory()) {
                FileUtil.listClassFiles(f2, result);
                continue;
            }
            if (!f2.getName().endsWith(".class")) continue;
            result.add(f2);
        }
    }

    private static void listFiles(File baseDir, ArrayList result, FileFilter filter) {
        File[] files = baseDir.listFiles();
        boolean skipCVS = !PERMIT_CVS && filter == aspectjSourceFileFilter;
        for (int i2 = 0; i2 < files.length; ++i2) {
            File f2 = files[i2];
            if (f2.isDirectory()) {
                String name;
                if (skipCVS && ("cvs".equals(name = f2.getName().toLowerCase()) || "sccs".equals(name))) continue;
                FileUtil.listFiles(f2, result, filter);
                continue;
            }
            if (!filter.accept(f2)) continue;
            result.add(f2);
        }
    }

    private static boolean isValidFileName(String input) {
        return null != input && -1 == input.indexOf(File.pathSeparator);
    }

    private static void listFiles(File baseDir, String dir, ArrayList result) {
        String dirPrefix = null == dir ? "" : dir + "/";
        File dirFile = null == dir ? baseDir : new File(baseDir.getPath() + "/" + dir);
        String[] files = dirFile.list();
        for (int i2 = 0; i2 < files.length; ++i2) {
            File f2 = new File(dirFile, files[i2]);
            String path = dirPrefix + files[i2];
            if (f2.isDirectory()) {
                FileUtil.listFiles(baseDir, path, result);
                continue;
            }
            result.add(path);
        }
    }

    private FileUtil() {
    }

    public static List makeClasspath(URL[] urls) {
        LinkedList<String> ret = new LinkedList<String>();
        if (urls != null) {
            for (int i2 = 0; i2 < urls.length; ++i2) {
                ret.add(urls[i2].getPath());
            }
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String name = (class$org$aspectj$util$FileUtil == null ? (class$org$aspectj$util$FileUtil = FileUtil.class$("org.aspectj.util.FileUtil")) : class$org$aspectj$util$FileUtil).getName() + ".PERMIT_CVS";
        PERMIT_CVS = LangUtil.getBoolean(name, false);
        aspectjSourceFileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName().toLowerCase();
                return name.endsWith(".java") || name.endsWith(".aj");
            }
        };
    }

    public static class Pipe
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;
        private final long sleep;
        private ByteArrayOutputStream snoop;
        private long totalWritten;
        private Throwable thrown;
        private boolean halt;
        private final boolean closeInput;
        private final boolean closeOutput;
        private boolean finishStream;
        private boolean done;

        Pipe(InputStream in, OutputStream out) {
            this(in, out, 100L, false, false);
        }

        Pipe(InputStream in, OutputStream out, long sleep, boolean closeInput, boolean closeOutput) {
            LangUtil.throwIaxIfNull(in, "in");
            LangUtil.throwIaxIfNull(out, "out");
            this.in = in;
            this.out = out;
            this.closeInput = closeInput;
            this.closeOutput = closeOutput;
            this.sleep = Math.min(0L, Math.max(60000L, sleep));
        }

        public void setSnoop(ByteArrayOutputStream snoop) {
            this.snoop = snoop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.totalWritten = 0L;
            if (this.halt) {
                return;
            }
            try {
                int MAX = 4096;
                byte[] buf = new byte[4096];
                int count = this.in.read(buf, 0, 4096);
                while (this.halt && this.finishStream && 0 < count || !this.halt && -1 != count) {
                    this.out.write(buf, 0, count);
                    ByteArrayOutputStream mySnoop = this.snoop;
                    if (null != mySnoop) {
                        mySnoop.write(buf, 0, count);
                    }
                    this.totalWritten += (long)count;
                    if (this.halt && !this.finishStream) {
                        break;
                    }
                    if (!this.halt && 0L < this.sleep) {
                        Thread.sleep(this.sleep);
                    }
                    if (this.halt && !this.finishStream) {
                        break;
                    }
                    count = this.in.read(buf, 0, 4096);
                }
            }
            catch (Throwable e2) {
                this.thrown = e2;
            }
            finally {
                this.halt = true;
                if (this.closeInput) {
                    try {
                        this.in.close();
                    }
                    catch (IOException e3) {}
                }
                if (this.closeOutput) {
                    try {
                        this.out.close();
                    }
                    catch (IOException e4) {}
                }
                this.done = true;
                this.completing(this.totalWritten, this.thrown);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean halt(boolean wait, boolean finishStream) {
            if (!this.halt) {
                this.halt = true;
            }
            if (wait) {
                while (!this.done) {
                    Pipe pipe = this;
                    synchronized (pipe) {
                        this.notifyAll();
                    }
                    if (this.done) continue;
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e2) {
                        break;
                    }
                }
            }
            return this.halt;
        }

        public long totalWritten() {
            return this.totalWritten;
        }

        public Throwable getThrown() {
            return this.thrown;
        }

        protected void completing(long totalWritten, Throwable thrown) {
        }
    }
}

