/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.UnresolvedTypeVariableReferenceType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;

public class NewMethodTypeMunger
extends ResolvedTypeMunger {
    public NewMethodTypeMunger(ResolvedMember signature, Set superMethodsCalled, List typeVariableAliases) {
        super(Method, signature);
        this.typeVariableAliases = typeVariableAliases;
        this.setSuperMethodsCalled(superMethodsCalled);
    }

    public ResolvedMember getInterMethodBody(UnresolvedType aspectType) {
        return AjcMemberMaker.interMethodBody(this.signature, aspectType);
    }

    public ResolvedMember getDeclaredInterMethodBody(UnresolvedType aspectType, World w) {
        if (this.declaredSignature != null) {
            ResolvedMemberImpl rm = this.declaredSignature.parameterizedWith(null, this.signature.getDeclaringType().resolve(w), false, this.getTypeVariableAliases());
            return AjcMemberMaker.interMethodBody(rm, aspectType);
        }
        return AjcMemberMaker.interMethodBody(this.signature, aspectType);
    }

    public ResolvedMember getDeclaredInterMethodDispatcher(UnresolvedType aspectType, World w) {
        if (this.declaredSignature != null) {
            ResolvedMemberImpl rm = this.declaredSignature.parameterizedWith(null, this.signature.getDeclaringType().resolve(w), false, this.getTypeVariableAliases());
            return AjcMemberMaker.interMethodDispatcher(rm, aspectType);
        }
        return AjcMemberMaker.interMethodDispatcher(this.signature, aspectType);
    }

    public void write(DataOutputStream s2) throws IOException {
        this.kind.write(s2);
        this.signature.write(s2);
        this.writeSuperMethodsCalled(s2);
        this.writeSourceLocation(s2);
        this.writeOutTypeAliases(s2);
    }

    public static ResolvedTypeMunger readMethod(VersionedDataInputStream s2, ISourceContext context) throws IOException {
        ISourceLocation sloc = null;
        ResolvedMemberImpl rmImpl = ResolvedMemberImpl.readResolvedMember(s2, context);
        Set<ResolvedMember> superMethodsCalled = NewMethodTypeMunger.readSuperMethodsCalled(s2);
        sloc = NewMethodTypeMunger.readSourceLocation(s2);
        List<String> typeVarAliases = NewMethodTypeMunger.readInTypeAliases(s2);
        NewMethodTypeMunger munger = new NewMethodTypeMunger(rmImpl, superMethodsCalled, typeVarAliases);
        if (sloc != null) {
            munger.setSourceLocation(sloc);
        }
        return munger;
    }

    public ResolvedMember getMatchingSyntheticMember(Member member, ResolvedType aspectType) {
        ResolvedMember ret = AjcMemberMaker.interMethodDispatcher(this.getSignature(), aspectType);
        if (ResolvedType.matches(ret, member)) {
            return this.getSignature();
        }
        return super.getMatchingSyntheticMember(member, aspectType);
    }

    public ResolvedTypeMunger parameterizedFor(ResolvedType target) {
        ResolvedType genericType = target;
        if (target.isRawType() || target.isParameterizedType()) {
            genericType = genericType.getGenericType();
        }
        ResolvedMemberImpl parameterizedSignature = null;
        if (target.isGenericType()) {
            TypeVariable[] vars = target.getTypeVariables();
            UnresolvedType[] varRefs = new UnresolvedTypeVariableReferenceType[vars.length];
            for (int i2 = 0; i2 < vars.length; ++i2) {
                varRefs[i2] = new UnresolvedTypeVariableReferenceType(vars[i2]);
            }
            parameterizedSignature = this.getSignature().parameterizedWith(varRefs, genericType, true, this.typeVariableAliases);
        } else {
            parameterizedSignature = this.getSignature().parameterizedWith(target.getTypeParameters(), genericType, target.isParameterizedType(), this.typeVariableAliases);
        }
        NewMethodTypeMunger nmtm = new NewMethodTypeMunger(parameterizedSignature, this.getSuperMethodsCalled(), this.typeVariableAliases);
        nmtm.setDeclaredSignature(this.getSignature());
        nmtm.setSourceLocation(this.getSourceLocation());
        return nmtm;
    }

    public boolean equals(Object other) {
        if (!(other instanceof NewMethodTypeMunger)) {
            return false;
        }
        NewMethodTypeMunger o2 = (NewMethodTypeMunger)other;
        return (this.kind == null ? o2.kind == null : this.kind.equals(o2.kind)) && (this.signature == null ? o2.signature == null : this.signature.equals(o2.signature)) && (this.declaredSignature == null ? o2.declaredSignature == null : this.declaredSignature.equals(o2.declaredSignature)) && (this.typeVariableAliases == null ? o2.typeVariableAliases == null : ((Object)this.typeVariableAliases).equals(o2.typeVariableAliases));
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.kind.hashCode();
        result = 37 * result + (this.signature == null ? 0 : this.signature.hashCode());
        result = 37 * result + (this.declaredSignature == null ? 0 : this.declaredSignature.hashCode());
        result = 37 * result + (this.typeVariableAliases == null ? 0 : ((Object)this.typeVariableAliases).hashCode());
        return result;
    }

    public ResolvedTypeMunger parameterizeWith(Map m2, World w) {
        ResolvedMember parameterizedSignature = this.getSignature().parameterizedWith(m2, w);
        NewMethodTypeMunger nmtm = new NewMethodTypeMunger(parameterizedSignature, this.getSuperMethodsCalled(), this.typeVariableAliases);
        nmtm.setDeclaredSignature(this.getSignature());
        nmtm.setSourceLocation(this.getSourceLocation());
        return nmtm;
    }
}

