/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.PatternNodeVisitor;

public class ModifiersPattern
extends PatternNode {
    private int requiredModifiers;
    private int forbiddenModifiers;
    public static final ModifiersPattern ANY = new ModifiersPattern(0, 0);
    private static Map modifierFlags = null;

    public ModifiersPattern(int requiredModifiers, int forbiddenModifiers) {
        this.requiredModifiers = requiredModifiers;
        this.forbiddenModifiers = forbiddenModifiers;
    }

    public String toString() {
        if (this == ANY) {
            return "";
        }
        String ret = Modifier.toString(this.requiredModifiers);
        if (this.forbiddenModifiers == 0) {
            return ret;
        }
        return ret + " !" + Modifier.toString(this.forbiddenModifiers);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ModifiersPattern)) {
            return false;
        }
        ModifiersPattern o2 = (ModifiersPattern)other;
        return o2.requiredModifiers == this.requiredModifiers && o2.forbiddenModifiers == this.forbiddenModifiers;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.requiredModifiers;
        result = 37 * result + this.forbiddenModifiers;
        return result;
    }

    public boolean matches(int modifiers) {
        return (modifiers & this.requiredModifiers) == this.requiredModifiers && (modifiers & this.forbiddenModifiers) == 0;
    }

    public static ModifiersPattern read(VersionedDataInputStream s2) throws IOException {
        short requiredModifiers = s2.readShort();
        short forbiddenModifiers = s2.readShort();
        if (requiredModifiers == 0 && forbiddenModifiers == 0) {
            return ANY;
        }
        return new ModifiersPattern(requiredModifiers, forbiddenModifiers);
    }

    public void write(DataOutputStream s2) throws IOException {
        s2.writeShort(this.requiredModifiers);
        s2.writeShort(this.forbiddenModifiers);
    }

    public static int getModifierFlag(String name) {
        Integer flag;
        if (modifierFlags == null) {
            modifierFlags = new HashMap();
            for (int flag2 = 1; flag2 <= 2048; flag2 <<= 1) {
                String flagName = Modifier.toString(flag2);
                modifierFlags.put(flagName, new Integer(flag2));
            }
        }
        if ((flag = (Integer)modifierFlags.get(name)) == null) {
            return -1;
        }
        return flag;
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

