/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.csv;

import java.util.ArrayList;
import org.homelinux.elabor.csv.LineParser;

public class CsvLineParser
implements LineParser {
    @Override
    public String[] parse(String line, char delimiter) {
        boolean openQuote = false;
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int index = 0;
        int length = line.length();
        while (index < length) {
            char c2 = line.charAt(index);
            if (c2 == '\"' && !openQuote && start == index) {
                openQuote = true;
            } else if (c2 == '\"' && openQuote && (index == length - 1 || line.charAt(index + 1) == delimiter)) {
                openQuote = false;
            } else if (c2 == delimiter && !openQuote) {
                String value = line.substring(start, index);
                String cleanValue = CsvLineParser.cleanQuote(value.trim());
                list.add(cleanValue);
                start = index + 1;
            }
            ++index;
        }
        if (start < length) {
            String field = line.substring(start).trim();
            field = CsvLineParser.cleanQuote(field);
            list.add(field);
        } else if (start == length) {
            list.add("");
        }
        return list.toArray(new String[1]);
    }

    private static String cleanQuote(String value) {
        String cleaned = "";
        int length = value.length();
        if (length > 0) {
            char c2 = value.charAt(length - 1);
            cleaned = value.charAt(0) == '\"' && c2 == '\"' ? value.substring(1, length == 1 ? 1 : length - 1) : value;
        }
        return cleaned;
    }
}

