/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.dom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.homelinux.elabor.dom.DomElementIterator;
import org.homelinux.elabor.dom.DomIterator;
import org.homelinux.elabor.dom.ElementCreator;
import org.homelinux.elabor.dom.ElementExtractor;
import org.homelinux.elabor.dom.ElementFiller;
import org.homelinux.elabor.file.InvalidFileFormat;
import org.homelinux.elabor.structures.StructuresHelper;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DomHelper {
    private DomHelper() {
    }

    public static Element getDocumentElement(String content) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        byte[] bytes = content.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Document document = builder.parse(inputStream);
        return document.getDocumentElement();
    }

    public static final List<Element> getElements(Node node, String pattern) {
        Iterator<Element> iterator = DomHelper.getElementIterator(node, pattern);
        ArrayList<Element> elements = new ArrayList<Element>();
        while (iterator.hasNext()) {
            elements.add(iterator.next());
        }
        return elements;
    }

    public static final Iterator<Element> getElementIterator(Node node, String pattern) {
        return new DomIterator(node, pattern);
    }

    public static final <T> List<T> getElementList(Node node, String pattern, ElementCreator<T> creator) {
        List<Element> elements = DomHelper.getElements(node, pattern);
        ArrayList collection = new ArrayList();
        ElementExtractor<T> extractor = new ElementExtractor<T>(creator);
        StructuresHelper.buildCollection(collection, elements, extractor);
        return collection;
    }

    public static final <T> Iterator<T> getElementIterator(Node node, String pattern, ElementCreator<T> creator) {
        DomIterator iterator = new DomIterator(node, pattern);
        return new DomElementIterator<T>(iterator, creator);
    }

    public static <T> void fill(T object, Element element, ElementFiller<T> filler) {
        Iterator<Element> iterator = DomHelper.getElementIterator(element, ".*");
        while (iterator.hasNext()) {
            Element child = iterator.next();
            filler.fill(object, child);
        }
    }

    public static int getIntegerAttribute(Element element, String name) throws InvalidFileFormat {
        String text = element.getAttribute(name);
        return DomHelper.getInteger(name, text);
    }

    public static int getIntegerElement(Element element, String tag) throws InvalidFileFormat {
        String text = DomHelper.getTextElement(element, tag);
        return DomHelper.getInteger(tag, text);
    }

    private static int getInteger(String tag, String text) throws InvalidFileFormat {
        int value;
        try {
            value = Integer.parseInt(text);
        }
        catch (NumberFormatException e2) {
            throw new InvalidFileFormat(String.valueOf(tag) + ".notInteger", e2.getMessage());
        }
        return value;
    }

    public static long getLongElement(Element element, String tag) throws InvalidFileFormat {
        String text = DomHelper.getTextElement(element, tag);
        return DomHelper.getLong(tag, text);
    }

    private static long getLong(String tag, String text) throws InvalidFileFormat {
        long value;
        try {
            value = Long.parseLong(text);
        }
        catch (NumberFormatException e2) {
            throw new InvalidFileFormat(String.valueOf(tag) + ".notLong", text);
        }
        return value;
    }

    public static float getFloatElement(Element element, String tag) throws InvalidFileFormat {
        float value;
        String text = DomHelper.getTextElement(element, tag);
        try {
            value = Float.parseFloat(text);
        }
        catch (NumberFormatException e2) {
            throw new InvalidFileFormat(String.valueOf(tag) + ".notNumber", text);
        }
        return value;
    }

    public static double getDoubleElement(Element element, String tag) throws InvalidFileFormat {
        String text = DomHelper.getTextElement(element, tag);
        return DomHelper.getDouble(tag, text);
    }

    public static double getDoubleAttribute(Element element, String name) throws InvalidFileFormat {
        String text = element.getAttribute(name);
        return DomHelper.getDouble(name, text);
    }

    private static double getDouble(String tag, String text) throws InvalidFileFormat {
        double value;
        try {
            value = Double.parseDouble(text);
        }
        catch (NumberFormatException e2) {
            throw new InvalidFileFormat(String.valueOf(tag) + ".notNumber", text);
        }
        return value;
    }

    public static <E extends Enum<E>> E getEnumElement(Element element, String tag, Class<E> enumType) throws InvalidFileFormat {
        E value;
        String text = DomHelper.getTextElement(element, tag);
        try {
            value = Enum.valueOf(enumType, text);
        }
        catch (Exception e2) {
            throw new InvalidFileFormat(String.valueOf(tag) + ".invalidEnumValue", text);
        }
        return value;
    }

    public static String getTextElement(Element element, String tag, boolean optional) throws DOMException, InvalidFileFormat {
        Element textElement = DomHelper.getElement(element, tag, optional);
        return textElement == null ? "" : textElement.getTextContent();
    }

    public static String getTextElement(Element element, String tag) throws InvalidFileFormat {
        return DomHelper.getTextElement(element, tag, false);
    }

    public static Element getElement(Element element, String tag, boolean optional) throws InvalidFileFormat {
        Element result;
        Iterator<Element> children = DomHelper.getElementIterator(element, tag);
        if (children.hasNext()) {
            result = children.next();
            if (children.hasNext()) {
                throw new InvalidFileFormat(String.valueOf(tag) + ".notUnique");
            }
        } else if (optional) {
            result = null;
        } else {
            throw new InvalidFileFormat(String.valueOf(tag) + ".notFound");
        }
        return result;
    }

    public static Date getDataElement(Element element, String tag, DateFormat formatDate) throws InvalidFileFormat {
        Date date;
        try {
            String dateStr = DomHelper.getElement(element, tag, false).getTextContent();
            date = formatDate.parse(dateStr);
        }
        catch (ParseException e2) {
            throw new InvalidFileFormat(String.valueOf(tag) + ".invalidDate");
        }
        return date;
    }
}

