/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.dao.jdbc;

import java.util.List;
import org.homelinux.elabor.springtools.dao.AttachmentDao;
import org.homelinux.elabor.springtools.dao.jdbc.AttachmentMapper;
import org.homelinux.elabor.springtools.domain.attachment.Attachment;
import org.homelinux.elabor.springtools.domain.attachment.AttachmentContainer;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.ObjectRetrievalFailureException;

public class JdbcAttachmentDao
extends SimpleJdbcDaoSupport
implements AttachmentDao {
    private static String GET_ATTACHMENTS = "SELECT * FROM attachment, item_attachment WHERE attachment.id = item_attachment.attachment_id AND item_attachment.item_id = ? AND item_attachment.kind = ? ORDER BY item_attachment.sort, attachment.id";
    private static String DELETE_ATTACHMENT = "DELETE FROM attachment WHERE id IN (SELECT attachment_id FROM item_attachment WHERE item_id = ? AND item_attachment.kind = ?)";
    private static String LINK_ATTACHMENT = "INSERT INTO item_attachment (attachment_id, item_id, kind, sort) VALUES (?, ?, ?, ?)";
    private static String GET_ATTACHMENT = "SELECT * FROM attachment WHERE id = ?";
    private SimpleJdbcInsert insertAttachment;

    private SimpleJdbcInsert getInsertAttachment() {
        if (this.insertAttachment == null) {
            this.insertAttachment = new SimpleJdbcInsert(this.getDataSource());
            this.insertAttachment.withTableName("attachment");
            this.insertAttachment.usingGeneratedKeyColumns("id");
        }
        return this.insertAttachment;
    }

    @Override
    public void saveAttachments(AttachmentContainer container) {
        this.getSimpleJdbcTemplate().update(DELETE_ATTACHMENT, container.getId(), container.getKind());
        int order = 0;
        for (Attachment attachment : container.getAttachments()) {
            this.saveAttachment(attachment);
            this.getSimpleJdbcTemplate().update(LINK_ATTACHMENT, attachment.getId(), container.getId(), container.getKind(), order);
            ++order;
        }
    }

    protected void saveAttachment(Attachment attachment) {
        SqlParameterSource source = JdbcAttachmentDao.createAttachmentSource(attachment);
        Number newKey = this.getInsertAttachment().executeAndReturnKey(source);
        attachment.setId(newKey.intValue());
    }

    private static SqlParameterSource createAttachmentSource(Attachment attachment) {
        MapSqlParameterSource source = new MapSqlParameterSource();
        source.addValue("id", attachment.getId());
        source.addValue("name", attachment.getFileName());
        source.addValue("content_type", attachment.getContentType());
        source.addValue("size", attachment.getSize());
        SqlLobValue lob = new SqlLobValue(attachment.getContent(), (LobHandler)new DefaultLobHandler());
        source.addValue("content", lob, 2004);
        return source;
    }

    @Override
    public Attachment loadAttachment(Integer attachmentId) {
        Attachment attachment;
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        try {
            attachment = template.queryForObject(GET_ATTACHMENT, new AttachmentMapper(), attachmentId);
        }
        catch (EmptyResultDataAccessException ex) {
            throw new ObjectRetrievalFailureException(Attachment.class, (Object)attachmentId);
        }
        return attachment;
    }

    @Override
    public List<Attachment> loadAttachments(AttachmentContainer container) {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        return template.query(GET_ATTACHMENTS, new AttachmentMapper(), container.getId(), container.getKind());
    }
}

