/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.domain.attachment;

import java.io.File;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URLConnection;
import org.homelinux.elabor.springtools.domain.attachment.Attachment;
import org.homelinux.elabor.springtools.web.controllers.DownloadHelper;

public class DefaultAttachment
implements Attachment {
    private Integer id;
    private String name;
    private String title;
    private String contentType;
    private byte[] content;
    private File file;

    public DefaultAttachment() {
    }

    public DefaultAttachment(File file) throws IOException {
        this.setContent(file);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public String getFileName() {
        return this.name;
    }

    @Override
    public void setFileName(String name) {
        this.name = name;
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String type = fileNameMap.getContentTypeFor(name);
        this.setContentType(type);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public Long getSize() {
        return this.content.length;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public void setContent(byte[] content) {
        this.content = content;
    }

    @Override
    public DefaultAttachment copy() {
        DefaultAttachment clone = new DefaultAttachment();
        clone.setContent(this.getContent());
        clone.setContentType(this.getContentType());
        clone.setId(this.getId());
        clone.setFileName(this.getFileName());
        clone.setTitle(this.getTitle());
        return clone;
    }

    @Override
    public void setContent(File content) throws IOException {
        this.file = content;
        this.name = content.getName();
        this.content = DownloadHelper.getContent(content);
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

