/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.taglib.graphics;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.springtools.taglib.graphics.Curve;
import org.homelinux.elabor.springtools.taglib.graphics.GraphicData;
import org.homelinux.elabor.springtools.taglib.graphics.GraphicsData;
import org.homelinux.elabor.text.Format;
import org.springframework.web.servlet.tags.form.AbstractFormTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class Graphics
extends AbstractFormTag {
    private static final long serialVersionUID = 1L;
    private static final DecimalFormat VALUE_FORMAT = Format.newDecimalFormat(Locale.UK, "0.000");
    private static final DecimalFormat LABEL_FORMAT = new DecimalFormat("#0.000");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy");
    private static final DateFormat HOUR_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private GraphicsData data;

    public void setData(GraphicsData data) {
        this.data = data;
    }

    @Override
    protected int writeTagContent(TagWriter writer) throws JspException {
        int width = this.data.getWidth();
        int height = this.data.getHeight();
        int hMargin = this.data.getHMargin();
        int vMargin = this.data.getVMargin();
        Date startDate = this.data.getStartDate();
        int period = this.data.getPeriod();
        for (GraphicData graphicData : this.data.getGraphics()) {
            if (graphicData.isEmpty()) continue;
            Graphics.printGraphic(writer, width, height, hMargin, vMargin, startDate, period, graphicData);
        }
        return 0;
    }

    private static void printGraphic(TagWriter writer, int width, int height, int hMargin, int vMargin, Date startDate, int period, GraphicData graphicData) throws JspException {
        writer.startTag("svg");
        writer.writeAttribute("id", "grafico");
        writer.writeAttribute("width", String.valueOf(width + 2 * hMargin));
        writer.writeAttribute("height", String.valueOf(height + 2 * vMargin));
        writer.writeAttribute("viewBox", String.valueOf(-hMargin) + "," + -vMargin + "," + (width + 2 * hMargin) + "," + (height + 2 * vMargin));
        writer.writeAttribute("preserveAspectRatio", "none");
        writer.writeAttribute("transform", "scale(1,-1)");
        double maxValue = graphicData.getMaxValue();
        int time = period * (graphicData.getLength() - 1);
        Graphics.printPane(writer, width, height, hMargin, vMargin, maxValue, startDate, time);
        Graphics.printCurves(writer, width, height, graphicData);
        writer.endTag();
    }

    private static void printPane(TagWriter writer, int width, int height, int hMargin, int vMargin, double maxValue, Date startDate, int time) throws JspException {
        Graphics.printLine(writer, -hMargin, -vMargin, width + hMargin, -vMargin, "black");
        Graphics.printLine(writer, -hMargin, -vMargin, -hMargin, height + vMargin, "black");
        Graphics.printLine(writer, -hMargin, height + vMargin, width + hMargin, height + vMargin, "black");
        Graphics.printLine(writer, width + hMargin, -vMargin, width + hMargin, height + vMargin, "black");
        Graphics.printLine(writer, 0, 0, width, 0, "black");
        Graphics.printLine(writer, 0, 0, 0, height, "black");
        Graphics.printLine(writer, width, 0, width, height, "black");
        Graphics.printLine(writer, 0, height, width, height, "black");
        int index = 0;
        while (index <= 10) {
            Graphics.printLine(writer, index * width / 10, 0, index * width / 10, height, "gray");
            ElaborCalendar calendar = new ElaborCalendar(startDate);
            calendar.addMinuti(time * index / 10);
            Date date = calendar.getDate();
            String label = DATE_FORMAT.format(date);
            Graphics.printText(writer, index * width / 10, -vMargin / 3, label, "middle", height / 40, "#125");
            label = HOUR_FORMAT.format(date);
            Graphics.printText(writer, index * width / 10, -2 * vMargin / 3, label, "middle", height / 40, "#125");
            ++index;
        }
        index = 1;
        while (index <= 10) {
            Graphics.printLine(writer, 0, index * height / 10, width, index * height / 10, "gray");
            String yValue = LABEL_FORMAT.format((double)index * maxValue / 10.0);
            Graphics.printText(writer, -hMargin / 10, index * height / 10, yValue, "end", height / 40, "#125");
            ++index;
        }
    }

    private static void printCurves(TagWriter writer, int width, int height, GraphicData graphicData) throws JspException {
        double maxValue = graphicData.getMaxValue();
        int length = graphicData.getLength();
        for (Curve curve : graphicData.getCurves()) {
            Graphics.printCurve(writer, width, height, curve, maxValue, length);
        }
    }

    private static void printCurve(TagWriter writer, int width, int height, Curve curve, double maxValue, int length) throws JspException {
        StringBuilder path = new StringBuilder();
        Iterator iterator = curve.iterator();
        int index = 0;
        if (iterator.hasNext()) {
            double value = (Double)iterator.next();
            path.append("M0,");
            path.append(Graphics.formatValue(value, height, maxValue));
            while (iterator.hasNext()) {
                path.append(" L");
                path.append(Graphics.formatIndex(++index, width, length));
                path.append(",");
                value = (Double)iterator.next();
                path.append(Graphics.formatValue(value, height, maxValue));
            }
        }
        String color = curve.getColor();
        writer.startTag("path");
        writer.writeAttribute("d", path.toString());
        writer.writeAttribute("stroke", color);
        writer.writeAttribute("stroke-width", String.valueOf(1));
        writer.writeAttribute("fill", "none");
        writer.endTag();
    }

    private static String formatIndex(double x, double width, double length) {
        return VALUE_FORMAT.format(x * width / (length - 1.0));
    }

    private static String formatValue(double value, double height, double maxValue) {
        return VALUE_FORMAT.format(value * height / maxValue);
    }

    private static void printLine(TagWriter writer, int x1, int y1, int x2, int y2, String color) throws JspException {
        writer.startTag("line");
        writer.writeAttribute("x1", String.valueOf(x1));
        writer.writeAttribute("y1", String.valueOf(y1));
        writer.writeAttribute("x2", String.valueOf(x2));
        writer.writeAttribute("y2", String.valueOf(y2));
        writer.writeAttribute("stroke", color);
        writer.writeAttribute("stroke-width", String.valueOf(1));
        writer.endTag();
    }

    private static void printText(TagWriter writer, int x, int y, String text, String anchor, int size, String color) throws JspException {
        writer.startTag("text");
        writer.writeAttribute("id", "label-" + String.valueOf(x));
        writer.writeAttribute("x", String.valueOf(x));
        writer.writeAttribute("y", String.valueOf(-y));
        writer.writeAttribute("text-anchor", anchor);
        writer.writeAttribute("dominant-baseline", "middle");
        writer.writeAttribute("font-size", String.valueOf(size));
        writer.writeAttribute("transform", "scale(1,-1)");
        writer.writeAttribute("fill", color);
        writer.appendValue(text);
        writer.endTag();
    }
}

