/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.util.ObjectUtilities;

public class XYSplineRenderer
extends XYLineAndShapeRenderer {
    private int precision;
    private FillType fillType;
    private GradientPaintTransformer gradientPaintTransformer;

    public XYSplineRenderer() {
        this(5, FillType.NONE);
    }

    public XYSplineRenderer(int precision) {
        this(precision, FillType.NONE);
    }

    public XYSplineRenderer(int precision, FillType fillType) {
        if (precision <= 0) {
            throw new IllegalArgumentException("Requires precision > 0.");
        }
        ParamChecks.nullNotPermitted((Object)fillType, "fillType");
        this.precision = precision;
        this.fillType = fillType;
        this.gradientPaintTransformer = new StandardGradientPaintTransformer();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int p2) {
        if (p2 <= 0) {
            throw new IllegalArgumentException("Requires p > 0.");
        }
        this.precision = p2;
        this.fireChangeEvent();
    }

    public FillType getFillType() {
        return this.fillType;
    }

    public void setFillType(FillType fillType) {
        this.fillType = fillType;
        this.fireChangeEvent();
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gpt) {
        this.gradientPaintTransformer = gpt;
        this.fireChangeEvent();
    }

    @Override
    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        this.setDrawSeriesLineAsPath(true);
        XYSplineState state = new XYSplineState(info);
        state.setProcessVisibleItemsOnly(false);
        return state;
    }

    @Override
    protected void drawPrimaryLineAsPath(XYItemRendererState state, Graphics2D g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis xAxis, ValueAxis yAxis, Rectangle2D dataArea) {
        XYSplineState s2 = (XYSplineState)state;
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        double transX1 = xAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = yAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (!Double.isNaN(transX1) && !Double.isNaN(transY1)) {
            Point2D.Float p2;
            Point2D.Float float_ = p2 = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float((float)transY1, (float)transX1) : new Point2D.Float((float)transX1, (float)transY1);
            if (!s2.points.contains(p2)) {
                s2.points.add(p2);
            }
        }
        if (item == dataset.getItemCount(series) - 1) {
            if (s2.points.size() > 1) {
                Point2D.Float origin;
                if (this.fillType == FillType.TO_ZERO) {
                    float xz = (float)xAxis.valueToJava2D(0.0, dataArea, yAxisLocation);
                    float yz = (float)yAxis.valueToJava2D(0.0, dataArea, yAxisLocation);
                    origin = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(yz, xz) : new Point2D.Float(xz, yz);
                } else if (this.fillType == FillType.TO_LOWER_BOUND) {
                    float xlb = (float)xAxis.valueToJava2D(xAxis.getLowerBound(), dataArea, xAxisLocation);
                    float ylb = (float)yAxis.valueToJava2D(yAxis.getLowerBound(), dataArea, yAxisLocation);
                    origin = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(ylb, xlb) : new Point2D.Float(xlb, ylb);
                } else {
                    float xub = (float)xAxis.valueToJava2D(xAxis.getUpperBound(), dataArea, xAxisLocation);
                    float yub = (float)yAxis.valueToJava2D(yAxis.getUpperBound(), dataArea, yAxisLocation);
                    origin = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(yub, xub) : new Point2D.Float(xub, yub);
                }
                Point2D cp0 = s2.points.get(0);
                s2.seriesPath.moveTo(cp0.getX(), cp0.getY());
                if (this.fillType != FillType.NONE) {
                    if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                        s2.fillArea.moveTo(((Point2D)origin).getX(), cp0.getY());
                    } else {
                        s2.fillArea.moveTo(cp0.getX(), ((Point2D)origin).getY());
                    }
                    s2.fillArea.lineTo(cp0.getX(), cp0.getY());
                }
                if (s2.points.size() == 2) {
                    Point2D cp1 = s2.points.get(1);
                    if (this.fillType != FillType.NONE) {
                        s2.fillArea.lineTo(cp1.getX(), cp1.getY());
                        s2.fillArea.lineTo(cp1.getX(), ((Point2D)origin).getY());
                        s2.fillArea.closePath();
                    }
                    s2.seriesPath.lineTo(cp1.getX(), cp1.getY());
                } else {
                    int i2;
                    int i3;
                    int np = s2.points.size();
                    float[] d2 = new float[np];
                    float[] x = new float[np];
                    float[] a2 = new float[np];
                    float[] h2 = new float[np];
                    for (i3 = 0; i3 < np; ++i3) {
                        Point2D.Float cpi = (Point2D.Float)s2.points.get(i3);
                        x[i3] = cpi.x;
                        d2[i3] = cpi.y;
                    }
                    for (i3 = 1; i3 <= np - 1; ++i3) {
                        h2[i3] = x[i3] - x[i3 - 1];
                    }
                    float[] sub = new float[np - 1];
                    float[] diag = new float[np - 1];
                    float[] sup = new float[np - 1];
                    for (i2 = 1; i2 <= np - 2; ++i2) {
                        diag[i2] = (h2[i2] + h2[i2 + 1]) / 3.0f;
                        sup[i2] = h2[i2 + 1] / 6.0f;
                        sub[i2] = h2[i2] / 6.0f;
                        a2[i2] = (d2[i2 + 1] - d2[i2]) / h2[i2 + 1] - (d2[i2] - d2[i2 - 1]) / h2[i2];
                    }
                    this.solveTridiag(sub, diag, sup, a2, np - 2);
                    float oldt = x[0];
                    float oldy = d2[0];
                    for (i2 = 1; i2 <= np - 1; ++i2) {
                        for (int j2 = 1; j2 <= this.precision; ++j2) {
                            float t1 = h2[i2] * (float)j2 / (float)this.precision;
                            float t2 = h2[i2] - t1;
                            float y = ((-a2[i2 - 1] / 6.0f * (t2 + h2[i2]) * t1 + d2[i2 - 1]) * t2 + (-a2[i2] / 6.0f * (t1 + h2[i2]) * t2 + d2[i2]) * t1) / h2[i2];
                            float t = x[i2 - 1] + t1;
                            s2.seriesPath.lineTo(t, y);
                            if (this.fillType == FillType.NONE) continue;
                            s2.fillArea.lineTo(t, y);
                        }
                    }
                }
                if (this.fillType != FillType.NONE) {
                    if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                        s2.fillArea.lineTo(((Point2D)origin).getX(), s2.points.get(s2.points.size() - 1).getY());
                    } else {
                        s2.fillArea.lineTo(s2.points.get(s2.points.size() - 1).getX(), ((Point2D)origin).getY());
                    }
                    s2.fillArea.closePath();
                }
                if (this.fillType != FillType.NONE) {
                    Paint fp = this.getSeriesFillPaint(series);
                    if (this.gradientPaintTransformer != null && fp instanceof GradientPaint) {
                        GradientPaint gp = this.gradientPaintTransformer.transform((GradientPaint)fp, s2.fillArea);
                        g2.setPaint(gp);
                    } else {
                        g2.setPaint(fp);
                    }
                    g2.fill(s2.fillArea);
                    s2.fillArea.reset();
                }
                this.drawFirstPassShape(g2, pass, series, item, s2.seriesPath);
            }
            s2.points = new ArrayList<Point2D>();
        }
    }

    private void solveTridiag(float[] sub, float[] diag, float[] sup, float[] b2, int n2) {
        int i2;
        for (i2 = 2; i2 <= n2; ++i2) {
            int n3 = i2;
            sub[n3] = sub[n3] / diag[i2 - 1];
            int n4 = i2;
            diag[n4] = diag[n4] - sub[i2] * sup[i2 - 1];
            int n5 = i2;
            b2[n5] = b2[n5] - sub[i2] * b2[i2 - 1];
        }
        int n6 = n2;
        b2[n6] = b2[n6] / diag[n2];
        for (i2 = n2 - 1; i2 >= 1; --i2) {
            b2[i2] = (b2[i2] - sup[i2] * b2[i2 + 1]) / diag[i2];
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYSplineRenderer)) {
            return false;
        }
        XYSplineRenderer that = (XYSplineRenderer)obj;
        if (this.precision != that.precision) {
            return false;
        }
        if (this.fillType != that.fillType) {
            return false;
        }
        if (!ObjectUtilities.equal(this.gradientPaintTransformer, that.gradientPaintTransformer)) {
            return false;
        }
        return super.equals(obj);
    }

    public static class XYSplineState
    extends XYLineAndShapeRenderer.State {
        public GeneralPath fillArea = new GeneralPath();
        public List<Point2D> points = new ArrayList<Point2D>();

        public XYSplineState(PlotRenderingInfo info) {
            super(info);
        }
    }

    public static enum FillType {
        NONE,
        TO_ZERO,
        TO_LOWER_BOUND,
        TO_UPPER_BOUND;

    }
}

