/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AssumptionViolatedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assume {
    public static void assumeTrue(boolean b2) {
        Assume.assumeThat(b2, CoreMatchers.is(true));
    }

    public static void assumeFalse(boolean b2) {
        Assume.assumeTrue(!b2);
    }

    public static void assumeTrue(String message, boolean b2) {
        if (!b2) {
            throw new AssumptionViolatedException(message);
        }
    }

    public static void assumeFalse(String message, boolean b2) {
        Assume.assumeTrue(message, !b2);
    }

    public static void assumeNotNull(Object ... objects) {
        Assume.assumeThat(Arrays.asList(objects), CoreMatchers.everyItem(CoreMatchers.notNullValue()));
    }

    public static <T> void assumeThat(T actual, Matcher<T> matcher) {
        if (!matcher.matches(actual)) {
            throw new AssumptionViolatedException(actual, matcher);
        }
    }

    public static <T> void assumeThat(String message, T actual, Matcher<T> matcher) {
        if (!matcher.matches(actual)) {
            throw new AssumptionViolatedException(message, actual, matcher);
        }
    }

    public static void assumeNoException(Throwable e2) {
        Assume.assumeThat(e2, CoreMatchers.nullValue());
    }

    public static void assumeNoException(String message, Throwable e2) {
        Assume.assumeThat(message, e2, CoreMatchers.nullValue());
    }
}

