/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationUtils {
    static final String VALUE = "value";
    private static final Map<Class, Boolean> annotatedInterfaceCache = new WeakHashMap<Class, Boolean>();

    public static Annotation[] getAnnotations(Method method) {
        return BridgeMethodResolver.findBridgedMethod(method).getAnnotations();
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
        A ann = resolvedMethod.getAnnotation(annotationType);
        if (ann == null) {
            Annotation[] annotationArray = resolvedMethod.getAnnotations();
            int n2 = annotationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Annotation metaAnn = annotationArray[n3];
                ann = metaAnn.annotationType().getAnnotation(annotationType);
                if (ann != null) break;
                ++n3;
            }
        }
        return ann;
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        A annotation = AnnotationUtils.getAnnotation(method, annotationType);
        Class<?> cl = method.getDeclaringClass();
        if (annotation == null) {
            annotation = AnnotationUtils.searchOnInterfaces(method, annotationType, cl.getInterfaces());
        }
        while (annotation == null) {
            if ((cl = cl.getSuperclass()) == null || cl == Object.class) break;
            try {
                Method equivalentMethod = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
                if (annotation != null) continue;
                annotation = AnnotationUtils.searchOnInterfaces(method, annotationType, cl.getInterfaces());
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return annotation;
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, Class<A> annotationType, Class[] ifcs) {
        A annotation = null;
        Class[] classArray = ifcs;
        int n2 = ifcs.length;
        int n3 = 0;
        while (n3 < n2) {
            Class iface = classArray[n3];
            if (AnnotationUtils.isInterfaceWithAnnotatedMethods(iface)) {
                try {
                    Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                    annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (annotation != null) break;
            }
            ++n3;
        }
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterfaceWithAnnotatedMethods(Class<?> iface) {
        Map<Class, Boolean> map = annotatedInterfaceCache;
        synchronized (map) {
            Boolean flag = annotatedInterfaceCache.get(iface);
            if (flag != null) {
                return flag;
            }
            boolean found = false;
            Method[] methodArray = iface.getMethods();
            int n2 = methodArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Method ifcMethod = methodArray[n3];
                if (ifcMethod.getAnnotations().length > 0) {
                    found = true;
                    break;
                }
                ++n3;
            }
            annotatedInterfaceCache.put(iface, found);
            return found;
        }
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        Class<?> superClass;
        Assert.notNull(clazz, "Class must not be null");
        A annotation = clazz.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        Object[] objectArray = clazz.getInterfaces();
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Class<?> ifc = objectArray[n3];
            annotation = AnnotationUtils.findAnnotation(ifc, annotationType);
            if (annotation != null) {
                return annotation;
            }
            ++n3;
        }
        if (!Annotation.class.isAssignableFrom(clazz)) {
            objectArray = clazz.getAnnotations();
            n2 = objectArray.length;
            n3 = 0;
            while (n3 < n2) {
                Object ann = objectArray[n3];
                annotation = AnnotationUtils.findAnnotation(ann.annotationType(), annotationType);
                if (annotation != null) {
                    return annotation;
                }
                ++n3;
            }
        }
        if ((superClass = clazz.getSuperclass()) == null || superClass == Object.class) {
            return null;
        }
        return AnnotationUtils.findAnnotation(superClass, annotationType);
    }

    public static Class<?> findAnnotationDeclaringClass(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        return AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz) ? clazz : AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz.getSuperclass());
    }

    public static boolean isAnnotationDeclaredLocally(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        boolean declaredLocally = false;
        for (Annotation annotation : Arrays.asList(clazz.getDeclaredAnnotations())) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            declaredLocally = true;
            break;
        }
        return declaredLocally;
    }

    public static boolean isAnnotationInherited(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isAnnotationPresent(annotationType) && !AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation) {
        return AnnotationUtils.getAnnotationAttributes(annotation, false);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation, boolean classValuesAsString) {
        Method[] methods;
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Method[] methodArray = methods = annotation.annotationType().getDeclaredMethods();
        int n2 = methods.length;
        int n3 = 0;
        while (n3 < n2) {
            Method method = methodArray[n3];
            if (method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE) {
                try {
                    String[] value = method.invoke((Object)annotation, new Object[0]);
                    if (classValuesAsString) {
                        if (value instanceof Class) {
                            value = ((Class)value).getName();
                        } else if (value instanceof Class[]) {
                            Class[] clazzArray = (Class[])value;
                            String[] newValue = new String[clazzArray.length];
                            int i2 = 0;
                            while (i2 < clazzArray.length) {
                                newValue[i2] = clazzArray[i2].getName();
                                ++i2;
                            }
                            value = newValue;
                        }
                    }
                    attrs.put(method.getName(), value);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not obtain annotation attribute values", ex);
                }
            }
            ++n3;
        }
        return attrs;
    }

    public static Object getValue(Annotation annotation) {
        return AnnotationUtils.getValue(annotation, VALUE);
    }

    public static Object getValue(Annotation annotation, String attributeName) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object getDefaultValue(Annotation annotation) {
        return AnnotationUtils.getDefaultValue(annotation, VALUE);
    }

    public static Object getDefaultValue(Annotation annotation, String attributeName) {
        return AnnotationUtils.getDefaultValue(annotation.annotationType(), attributeName);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getDefaultValue(annotationType, VALUE);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType, String attributeName) {
        try {
            Method method = annotationType.getDeclaredMethod(attributeName, new Class[0]);
            return method.getDefaultValue();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

