/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTypeDescriptor
extends TypeDescriptor {
    private final PropertyDescriptor propertyDescriptor;
    private Annotation[] cachedAnnotations;

    public PropertyTypeDescriptor(PropertyDescriptor propertyDescriptor, MethodParameter methodParameter) {
        super(methodParameter);
        this.propertyDescriptor = propertyDescriptor;
    }

    public PropertyTypeDescriptor(PropertyDescriptor propertyDescriptor, MethodParameter methodParameter, Class<?> type) {
        super(methodParameter, type);
        this.propertyDescriptor = propertyDescriptor;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] anns = this.cachedAnnotations;
        if (anns == null) {
            Annotation ann;
            int n2;
            int n3;
            Annotation[] annotationArray;
            LinkedHashMap<Class<? extends Annotation>, Annotation> annMap = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
            String name = this.propertyDescriptor.getName();
            if (StringUtils.hasLength(name)) {
                Class<?> clazz = this.getMethodParameter().getMethod().getDeclaringClass();
                Field field = ReflectionUtils.findField(clazz, name);
                if (field == null && (field = ReflectionUtils.findField(clazz, String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1))) == null) {
                    field = ReflectionUtils.findField(clazz, String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1));
                }
                if (field != null) {
                    annotationArray = field.getAnnotations();
                    n3 = annotationArray.length;
                    n2 = 0;
                    while (n2 < n3) {
                        ann = annotationArray[n2];
                        annMap.put(ann.annotationType(), ann);
                        ++n2;
                    }
                }
            }
            Method writeMethod = this.propertyDescriptor.getWriteMethod();
            Method readMethod = this.propertyDescriptor.getReadMethod();
            if (writeMethod != null && writeMethod != this.getMethodParameter().getMethod()) {
                annotationArray = writeMethod.getAnnotations();
                n3 = annotationArray.length;
                n2 = 0;
                while (n2 < n3) {
                    ann = annotationArray[n2];
                    annMap.put(ann.annotationType(), ann);
                    ++n2;
                }
            }
            if (readMethod != null && readMethod != this.getMethodParameter().getMethod()) {
                annotationArray = readMethod.getAnnotations();
                n3 = annotationArray.length;
                n2 = 0;
                while (n2 < n3) {
                    ann = annotationArray[n2];
                    annMap.put(ann.annotationType(), ann);
                    ++n2;
                }
            }
            annotationArray = this.getMethodParameter().getMethodAnnotations();
            n3 = annotationArray.length;
            n2 = 0;
            while (n2 < n3) {
                ann = annotationArray[n2];
                annMap.put(ann.annotationType(), ann);
                ++n2;
            }
            annotationArray = this.getMethodParameter().getParameterAnnotations();
            n3 = annotationArray.length;
            n2 = 0;
            while (n2 < n3) {
                ann = annotationArray[n2];
                annMap.put(ann.annotationType(), ann);
                ++n2;
            }
            anns = annMap.values().toArray(new Annotation[annMap.size()]);
            this.cachedAnnotations = anns;
        }
        return anns;
    }

    @Override
    public TypeDescriptor forElementType(Class<?> elementType) {
        if (elementType != null) {
            return new PropertyTypeDescriptor(this.propertyDescriptor, this.getMethodParameter(), elementType);
        }
        return super.forElementType(null);
    }
}

