/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardMethodMetadata
implements MethodMetadata {
    private final Method introspectedMethod;

    public StandardMethodMetadata(Method introspectedMethod) {
        Assert.notNull(introspectedMethod, "Method must not be null");
        this.introspectedMethod = introspectedMethod;
    }

    public final Method getIntrospectedMethod() {
        return this.introspectedMethod;
    }

    @Override
    public String getMethodName() {
        return this.introspectedMethod.getName();
    }

    @Override
    public String getDeclaringClassName() {
        return this.introspectedMethod.getDeclaringClass().getName();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isOverridable() {
        return !this.isStatic() && !this.isFinal() && !Modifier.isPrivate(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.introspectedMethod.getAnnotations();
        int n2 = anns.length;
        int n3 = 0;
        while (n3 < n2) {
            Annotation ann = annotationArray[n3];
            if (ann.annotationType().getName().equals(annotationType)) {
                return true;
            }
            Annotation[] annotationArray2 = ann.annotationType().getAnnotations();
            int n4 = annotationArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                Annotation metaAnn = annotationArray2[n5];
                if (metaAnn.annotationType().getName().equals(annotationType)) {
                    return true;
                }
                ++n5;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        Annotation[] anns;
        Annotation[] annotationArray = anns = this.introspectedMethod.getAnnotations();
        int n2 = anns.length;
        int n3 = 0;
        while (n3 < n2) {
            Annotation ann = annotationArray[n3];
            if (ann.annotationType().getName().equals(annotationType)) {
                return AnnotationUtils.getAnnotationAttributes(ann, true);
            }
            Annotation[] annotationArray2 = ann.annotationType().getAnnotations();
            int n4 = annotationArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                Annotation metaAnn = annotationArray2[n5];
                if (metaAnn.annotationType().getName().equals(annotationType)) {
                    return AnnotationUtils.getAnnotationAttributes(metaAnn, true);
                }
                ++n5;
            }
            ++n3;
        }
        return null;
    }
}

