/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHelper {
    static ArgumentsMatchInfo compareArguments(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue(expectedArgTypes.size() == suppliedArgTypes.size(), "Expected argument types and supplied argument types should be arrays of same length");
        ArgsMatchKind match = ArgsMatchKind.EXACT;
        ArrayList<Integer> argsRequiringConversion = null;
        int i2 = 0;
        while (i2 < expectedArgTypes.size() && match != null) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i2);
            TypeDescriptor expectedArg = expectedArgTypes.get(i2);
            if (!expectedArg.equals(suppliedArg)) {
                if (suppliedArg == TypeDescriptor.NULL) {
                    if (expectedArg.isPrimitive()) {
                        match = null;
                    }
                } else if (suppliedArg.isAssignableTo(expectedArg)) {
                    if (match != ArgsMatchKind.REQUIRES_CONVERSION) {
                        match = ArgsMatchKind.CLOSE;
                    }
                } else if (typeConverter.canConvert(suppliedArg, expectedArg)) {
                    if (argsRequiringConversion == null) {
                        argsRequiringConversion = new ArrayList<Integer>();
                    }
                    argsRequiringConversion.add(i2);
                    match = ArgsMatchKind.REQUIRES_CONVERSION;
                } else {
                    match = null;
                }
            }
            ++i2;
        }
        if (match == null) {
            return null;
        }
        if (match == ArgsMatchKind.REQUIRES_CONVERSION) {
            int[] argsArray = new int[argsRequiringConversion.size()];
            int i3 = 0;
            while (i3 < argsRequiringConversion.size()) {
                argsArray[i3] = (Integer)argsRequiringConversion.get(i3);
                ++i3;
            }
            return new ArgumentsMatchInfo(match, argsArray);
        }
        return new ArgumentsMatchInfo(match);
    }

    static ArgumentsMatchInfo compareArgumentsVarargs(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue(expectedArgTypes != null && expectedArgTypes.size() > 0, "Expected arguments must at least include one array (the vargargs parameter)");
        Assert.isTrue(expectedArgTypes.get(expectedArgTypes.size() - 1).isArray(), "Final expected argument should be array type (the varargs parameter)");
        ArgsMatchKind match = ArgsMatchKind.EXACT;
        ArrayList<Integer> argsRequiringConversion = null;
        int argCountUpToVarargs = expectedArgTypes.size() - 1;
        int i2 = 0;
        while (i2 < argCountUpToVarargs && match != null) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i2);
            TypeDescriptor expectedArg = expectedArgTypes.get(i2);
            if (suppliedArg == TypeDescriptor.NULL) {
                if (expectedArg.isPrimitive()) {
                    match = null;
                }
            } else if (!expectedArg.equals(suppliedArg)) {
                if (suppliedArg.isAssignableTo(expectedArg)) {
                    if (match != ArgsMatchKind.REQUIRES_CONVERSION) {
                        match = ArgsMatchKind.CLOSE;
                    }
                } else if (typeConverter.canConvert(suppliedArg, expectedArg)) {
                    if (argsRequiringConversion == null) {
                        argsRequiringConversion = new ArrayList<Integer>();
                    }
                    argsRequiringConversion.add(i2);
                    match = ArgsMatchKind.REQUIRES_CONVERSION;
                } else {
                    match = null;
                }
            }
            ++i2;
        }
        if (match == null) {
            return null;
        }
        if (suppliedArgTypes.size() != expectedArgTypes.size() || !expectedArgTypes.get(expectedArgTypes.size() - 1).equals(suppliedArgTypes.get(suppliedArgTypes.size() - 1))) {
            Class<?> varargsParameterType = expectedArgTypes.get(expectedArgTypes.size() - 1).getElementType();
            int i3 = expectedArgTypes.size() - 1;
            while (i3 < suppliedArgTypes.size()) {
                TypeDescriptor suppliedArg = suppliedArgTypes.get(i3);
                if (varargsParameterType != suppliedArg.getType()) {
                    if (suppliedArg == TypeDescriptor.NULL) {
                        if (varargsParameterType.isPrimitive()) {
                            match = null;
                        }
                    } else if (ClassUtils.isAssignable(varargsParameterType, suppliedArg.getType())) {
                        if (match != ArgsMatchKind.REQUIRES_CONVERSION) {
                            match = ArgsMatchKind.CLOSE;
                        }
                    } else if (typeConverter.canConvert(suppliedArg, TypeDescriptor.valueOf(varargsParameterType))) {
                        if (argsRequiringConversion == null) {
                            argsRequiringConversion = new ArrayList();
                        }
                        argsRequiringConversion.add(i3);
                        match = ArgsMatchKind.REQUIRES_CONVERSION;
                    } else {
                        match = null;
                    }
                }
                ++i3;
            }
        }
        if (match == null) {
            return null;
        }
        if (match == ArgsMatchKind.REQUIRES_CONVERSION) {
            int[] argsArray = new int[argsRequiringConversion.size()];
            int i4 = 0;
            while (i4 < argsRequiringConversion.size()) {
                argsArray[i4] = (Integer)argsRequiringConversion.get(i4);
                ++i4;
            }
            return new ArgumentsMatchInfo(match, argsArray);
        }
        return new ArgumentsMatchInfo(match);
    }

    static void convertArguments(TypeConverter converter, Object[] arguments, Object methodOrCtor, int[] argumentsRequiringConversion, Integer varargsPosition) throws EvaluationException {
        int[] nArray = argumentsRequiringConversion;
        int n2 = argumentsRequiringConversion.length;
        int n3 = 0;
        while (n3 < n2) {
            TypeDescriptor targetType;
            int argPosition = nArray[n3];
            if (varargsPosition != null && argPosition >= varargsPosition) {
                MethodParameter methodParam = MethodParameter.forMethodOrConstructor(methodOrCtor, varargsPosition);
                targetType = new TypeDescriptor(methodParam, methodParam.getParameterType().getComponentType());
            } else {
                targetType = new TypeDescriptor(MethodParameter.forMethodOrConstructor(methodOrCtor, argPosition));
            }
            arguments[argPosition] = converter.convertValue(arguments[argPosition], TypeDescriptor.forObject(arguments[argPosition]), targetType);
            ++n3;
        }
    }

    public static void convertAllArguments(TypeConverter converter, Object[] arguments, Method method) throws SpelEvaluationException {
        Integer varargsPosition = null;
        if (method.isVarArgs()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            varargsPosition = paramTypes.length - 1;
        }
        int argPosition = 0;
        while (argPosition < arguments.length) {
            TypeDescriptor targetType;
            if (varargsPosition != null && argPosition >= varargsPosition) {
                MethodParameter methodParam = new MethodParameter(method, (int)varargsPosition);
                targetType = new TypeDescriptor(methodParam, methodParam.getParameterType().getComponentType());
            } else {
                targetType = new TypeDescriptor(new MethodParameter(method, argPosition));
            }
            try {
                Object argument = arguments[argPosition];
                if (argument != null && !targetType.getObjectType().isInstance(argument)) {
                    if (converter == null) {
                        throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, argument.getClass().getName(), targetType);
                    }
                    arguments[argPosition] = converter.convertValue(argument, TypeDescriptor.forObject(argument), targetType);
                }
            }
            catch (EvaluationException ex) {
                if (ex instanceof SpelEvaluationException) {
                    throw (SpelEvaluationException)ex;
                }
                throw new SpelEvaluationException(ex, SpelMessage.TYPE_CONVERSION_ERROR, arguments[argPosition].getClass().getName(), targetType);
            }
            ++argPosition;
        }
    }

    public static Object[] setupArgumentsForVarargsInvocation(Class[] requiredParameterTypes, Object ... args) {
        int parameterCount = requiredParameterTypes.length;
        int argumentCount = args.length;
        if (parameterCount != args.length || requiredParameterTypes[parameterCount - 1] != (args[argumentCount - 1] == null ? null : args[argumentCount - 1].getClass())) {
            int arraySize = 0;
            if (argumentCount >= parameterCount) {
                arraySize = argumentCount - (parameterCount - 1);
            }
            Object[] repackagedArguments = (Object[])Array.newInstance(requiredParameterTypes[parameterCount - 1].getComponentType(), arraySize);
            int i2 = 0;
            while (i2 < arraySize) {
                repackagedArguments[i2] = args[parameterCount + i2 - 1];
                ++i2;
            }
            Object[] newArgs = new Object[parameterCount];
            int i3 = 0;
            while (i3 < newArgs.length - 1) {
                newArgs[i3] = args[i3];
                ++i3;
            }
            newArgs[newArgs.length - 1] = repackagedArguments;
            return newArgs;
        }
        return args;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArgsMatchKind {
        EXACT,
        CLOSE,
        REQUIRES_CONVERSION;

    }

    public static class ArgumentsMatchInfo {
        public final ArgsMatchKind kind;
        public int[] argsRequiringConversion;

        ArgumentsMatchInfo(ArgsMatchKind kind, int[] integers) {
            this.kind = kind;
            this.argsRequiringConversion = integers;
        }

        ArgumentsMatchInfo(ArgsMatchKind kind) {
            this.kind = kind;
        }

        public boolean isExactMatch() {
            return this.kind == ArgsMatchKind.EXACT;
        }

        public boolean isCloseMatch() {
            return this.kind == ArgsMatchKind.CLOSE;
        }

        public boolean isMatchRequiringConversion() {
            return this.kind == ArgsMatchKind.REQUIRES_CONVERSION;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ArgumentMatch: ").append((Object)this.kind);
            if (this.argsRequiringConversion != null) {
                sb.append("  (argsForConversion:");
                int i2 = 0;
                while (i2 < this.argsRequiringConversion.length) {
                    if (i2 > 0) {
                        sb.append(",");
                    }
                    sb.append(this.argsRequiringConversion[i2]);
                    ++i2;
                }
                sb.append(")");
            }
            return sb.toString();
        }
    }
}

