/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Constants;
import org.springframework.jmx.export.MBeanExportException;
import org.springframework.jmx.export.MBeanExportOperations;
import org.springframework.jmx.export.MBeanExporterListener;
import org.springframework.jmx.export.NotificationListenerBean;
import org.springframework.jmx.export.SpringModelMBean;
import org.springframework.jmx.export.UnableToRegisterMBeanException;
import org.springframework.jmx.export.assembler.AutodetectCapableMBeanInfoAssembler;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.assembler.SimpleReflectiveMBeanInfoAssembler;
import org.springframework.jmx.export.naming.KeyNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.export.naming.SelfNaming;
import org.springframework.jmx.export.notification.ModelMBeanNotificationPublisher;
import org.springframework.jmx.export.notification.NotificationPublisherAware;
import org.springframework.jmx.support.JmxUtils;
import org.springframework.jmx.support.MBeanRegistrationSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanExporter
extends MBeanRegistrationSupport
implements MBeanExportOperations,
BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    public static final int AUTODETECT_NONE = 0;
    public static final int AUTODETECT_MBEAN = 1;
    public static final int AUTODETECT_ASSEMBLER = 2;
    public static final int AUTODETECT_ALL = 3;
    private static final String WILDCARD = "*";
    private static final String MR_TYPE_OBJECT_REFERENCE = "ObjectReference";
    private static final String CONSTANT_PREFIX_AUTODETECT = "AUTODETECT_";
    private static final Constants constants = new Constants(MBeanExporter.class);
    private Map<String, Object> beans;
    private Integer autodetectMode;
    private boolean allowEagerInit = false;
    private boolean ensureUniqueRuntimeObjectNames = true;
    private boolean exposeManagedResourceClassLoader = true;
    private Set<String> excludedBeans;
    private MBeanExporterListener[] listeners;
    private NotificationListenerBean[] notificationListeners;
    private final Map<NotificationListenerBean, ObjectName[]> registeredNotificationListeners = new LinkedHashMap<NotificationListenerBean, ObjectName[]>();
    private MBeanInfoAssembler assembler = new SimpleReflectiveMBeanInfoAssembler();
    private ObjectNamingStrategy namingStrategy = new KeyNamingStrategy();
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private ListableBeanFactory beanFactory;

    public void setBeans(Map<String, Object> beans) {
        this.beans = beans;
    }

    public void setAutodetect(boolean autodetect) {
        this.autodetectMode = autodetect ? 3 : 0;
    }

    public void setAutodetectMode(int autodetectMode) {
        if (!constants.getValues(CONSTANT_PREFIX_AUTODETECT).contains(autodetectMode)) {
            throw new IllegalArgumentException("Only values of autodetect constants allowed");
        }
        this.autodetectMode = autodetectMode;
    }

    public void setAutodetectModeName(String constantName) {
        if (constantName == null || !constantName.startsWith(CONSTANT_PREFIX_AUTODETECT)) {
            throw new IllegalArgumentException("Only autodetect constants allowed");
        }
        this.autodetectMode = (Integer)constants.asNumber(constantName);
    }

    public void setAllowEagerInit(boolean allowEagerInit) {
        this.allowEagerInit = allowEagerInit;
    }

    public void setAssembler(MBeanInfoAssembler assembler) {
        this.assembler = assembler;
    }

    public void setNamingStrategy(ObjectNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setListeners(MBeanExporterListener[] listeners) {
        this.listeners = listeners;
    }

    public void setExcludedBeans(String[] excludedBeans) {
        this.excludedBeans = excludedBeans != null ? new HashSet(Arrays.asList(excludedBeans)) : null;
    }

    public void setEnsureUniqueRuntimeObjectNames(boolean ensureUniqueRuntimeObjectNames) {
        this.ensureUniqueRuntimeObjectNames = ensureUniqueRuntimeObjectNames;
    }

    public void setExposeManagedResourceClassLoader(boolean exposeManagedResourceClassLoader) {
        this.exposeManagedResourceClassLoader = exposeManagedResourceClassLoader;
    }

    public void setNotificationListeners(NotificationListenerBean[] notificationListeners) {
        this.notificationListeners = notificationListeners;
    }

    public void setNotificationListenerMappings(Map<?, ? extends NotificationListener> listeners) {
        Assert.notNull(listeners, "'listeners' must not be null");
        ArrayList<NotificationListenerBean> notificationListeners = new ArrayList<NotificationListenerBean>(listeners.size());
        for (Map.Entry<?, NotificationListener> entry : listeners.entrySet()) {
            NotificationListenerBean bean = new NotificationListenerBean(entry.getValue());
            Object key = entry.getKey();
            if (key != null && !WILDCARD.equals(key)) {
                bean.setMappedObjectName(entry.getKey());
            }
            notificationListeners.add(bean);
        }
        this.notificationListeners = notificationListeners.toArray(new NotificationListenerBean[notificationListeners.size()]);
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        } else {
            this.logger.info("MBeanExporter not running in a ListableBeanFactory: autodetection of MBeans not available.");
        }
    }

    @Override
    public void afterPropertiesSet() {
        if (this.server == null) {
            this.server = JmxUtils.locateMBeanServer();
        }
        try {
            this.logger.info("Registering beans for JMX exposure on startup");
            this.registerBeans();
            this.registerNotificationListeners();
        }
        catch (RuntimeException ex) {
            this.unregisterNotificationListeners();
            this.unregisterBeans();
            throw ex;
        }
    }

    @Override
    public void destroy() {
        this.logger.info("Unregistering JMX-exposed beans on shutdown");
        this.unregisterNotificationListeners();
        this.unregisterBeans();
    }

    @Override
    public ObjectName registerManagedResource(Object managedResource) throws MBeanExportException {
        ObjectName objectName;
        Assert.notNull(managedResource, "Managed resource must not be null");
        try {
            objectName = this.getObjectName(managedResource, null);
            if (this.ensureUniqueRuntimeObjectNames) {
                objectName = JmxUtils.appendIdentityToObjectName(objectName, managedResource);
            }
        }
        catch (Exception ex) {
            throw new MBeanExportException("Unable to generate ObjectName for MBean [" + managedResource + "]", ex);
        }
        this.registerManagedResource(managedResource, objectName);
        return objectName;
    }

    @Override
    public void registerManagedResource(Object managedResource, ObjectName objectName) throws MBeanExportException {
        Assert.notNull(managedResource, "Managed resource must not be null");
        Assert.notNull(objectName, "ObjectName must not be null");
        try {
            if (this.isMBean(managedResource.getClass())) {
                this.doRegister(managedResource, objectName);
            } else {
                ModelMBean mbean = this.createAndConfigureMBean(managedResource, managedResource.getClass().getName());
                this.doRegister(mbean, objectName);
                this.injectNotificationPublisherIfNecessary(managedResource, mbean, objectName);
            }
        }
        catch (JMException ex) {
            throw new UnableToRegisterMBeanException("Unable to register MBean [" + managedResource + "] with object name [" + objectName + "]", ex);
        }
    }

    @Override
    public void unregisterManagedResource(ObjectName objectName) {
        Assert.notNull(objectName, "ObjectName must not be null");
        this.doUnregister(objectName);
    }

    protected void registerBeans() {
        int mode;
        if (this.beans == null) {
            this.beans = new HashMap<String, Object>();
            if (this.autodetectMode == null) {
                this.autodetectMode = 3;
            }
        }
        int n2 = mode = this.autodetectMode != null ? this.autodetectMode : 0;
        if (mode != 0) {
            if (this.beanFactory == null) {
                throw new MBeanExportException("Cannot autodetect MBeans if not running in a BeanFactory");
            }
            if (mode == 1 || mode == 3) {
                this.logger.debug("Autodetecting user-defined JMX MBeans");
                this.autodetectMBeans();
            }
            if ((mode == 2 || mode == 3) && this.assembler instanceof AutodetectCapableMBeanInfoAssembler) {
                this.autodetectBeans((AutodetectCapableMBeanInfoAssembler)this.assembler);
            }
        }
        if (!this.beans.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
                this.registerBeanNameOrInstance(entry.getValue(), entry.getKey());
            }
        }
    }

    protected boolean isBeanDefinitionLazyInit(ListableBeanFactory beanFactory, String beanName) {
        return beanFactory instanceof ConfigurableListableBeanFactory && beanFactory.containsBeanDefinition(beanName) && ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(beanName).isLazyInit();
    }

    protected ObjectName registerBeanNameOrInstance(Object mapValue, String beanKey) throws MBeanExportException {
        try {
            if (mapValue instanceof String) {
                if (this.beanFactory == null) {
                    throw new MBeanExportException("Cannot resolve bean names if not running in a BeanFactory");
                }
                String beanName = (String)mapValue;
                if (this.isBeanDefinitionLazyInit(this.beanFactory, beanName)) {
                    ObjectName objectName = this.registerLazyInit(beanName, beanKey);
                    this.replaceNotificationListenerBeanNameKeysIfNecessary(beanName, objectName);
                    return objectName;
                }
                Object bean = this.beanFactory.getBean(beanName);
                ObjectName objectName = this.registerBeanInstance(bean, beanKey);
                this.replaceNotificationListenerBeanNameKeysIfNecessary(beanName, objectName);
                return objectName;
            }
            if (this.beanFactory != null) {
                Map<String, ?> beansOfSameType = this.beanFactory.getBeansOfType(mapValue.getClass(), false, this.allowEagerInit);
                for (Map.Entry<String, ?> entry : beansOfSameType.entrySet()) {
                    if (entry.getValue() != mapValue) continue;
                    String beanName = entry.getKey();
                    ObjectName objectName = this.registerBeanInstance(mapValue, beanKey);
                    this.replaceNotificationListenerBeanNameKeysIfNecessary(beanName, objectName);
                    return objectName;
                }
            }
            return this.registerBeanInstance(mapValue, beanKey);
        }
        catch (Exception ex) {
            throw new UnableToRegisterMBeanException("Unable to register MBean [" + mapValue + "] with key '" + beanKey + "'", ex);
        }
    }

    private void replaceNotificationListenerBeanNameKeysIfNecessary(String beanName, ObjectName objectName) {
        if (this.notificationListeners != null) {
            NotificationListenerBean[] notificationListenerBeanArray = this.notificationListeners;
            int n2 = this.notificationListeners.length;
            int n3 = 0;
            while (n3 < n2) {
                NotificationListenerBean notificationListener = notificationListenerBeanArray[n3];
                notificationListener.replaceObjectName(beanName, objectName);
                ++n3;
            }
        }
    }

    private ObjectName registerBeanInstance(Object bean, String beanKey) throws JMException {
        ObjectName objectName = this.getObjectName(bean, beanKey);
        Object mbeanToExpose = null;
        if (this.isMBean(bean.getClass())) {
            mbeanToExpose = bean;
        } else {
            DynamicMBean adaptedBean = this.adaptMBeanIfPossible(bean);
            if (adaptedBean != null) {
                mbeanToExpose = adaptedBean;
            }
        }
        if (mbeanToExpose != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Located MBean '" + beanKey + "': registering with JMX server as MBean [" + objectName + "]");
            }
            this.doRegister(mbeanToExpose, objectName);
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Located managed bean '" + beanKey + "': registering with JMX server as MBean [" + objectName + "]");
            }
            ModelMBean mbean = this.createAndConfigureMBean(bean, beanKey);
            this.doRegister(mbean, objectName);
            this.injectNotificationPublisherIfNecessary(bean, mbean, objectName);
        }
        return objectName;
    }

    private ObjectName registerLazyInit(String beanName, String beanKey) throws JMException {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.setFrozen(true);
        if (this.isMBean(this.beanFactory.getType(beanName))) {
            LazyInitTargetSource targetSource = new LazyInitTargetSource();
            targetSource.setTargetBeanName(beanName);
            targetSource.setBeanFactory(this.beanFactory);
            proxyFactory.setTargetSource(targetSource);
            Object proxy = proxyFactory.getProxy(this.beanClassLoader);
            ObjectName objectName = this.getObjectName(proxy, beanKey);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Located MBean '" + beanKey + "': registering with JMX server as lazy-init MBean [" + objectName + "]");
            }
            this.doRegister(proxy, objectName);
            return objectName;
        }
        NotificationPublisherAwareLazyTargetSource targetSource = new NotificationPublisherAwareLazyTargetSource();
        targetSource.setTargetBeanName(beanName);
        targetSource.setBeanFactory(this.beanFactory);
        proxyFactory.setTargetSource(targetSource);
        Object proxy = proxyFactory.getProxy(this.beanClassLoader);
        ObjectName objectName = this.getObjectName(proxy, beanKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Located simple bean '" + beanKey + "': registering with JMX server as lazy-init MBean [" + objectName + "]");
        }
        ModelMBean mbean = this.createAndConfigureMBean(proxy, beanKey);
        targetSource.setModelMBean(mbean);
        targetSource.setObjectName(objectName);
        this.doRegister(mbean, objectName);
        return objectName;
    }

    protected ObjectName getObjectName(Object bean, String beanKey) throws MalformedObjectNameException {
        if (bean instanceof SelfNaming) {
            return ((SelfNaming)bean).getObjectName();
        }
        return this.namingStrategy.getObjectName(bean, beanKey);
    }

    protected boolean isMBean(Class beanClass) {
        return JmxUtils.isMBean(beanClass);
    }

    protected DynamicMBean adaptMBeanIfPossible(Object bean) throws JMException {
        Class<?> targetClass = AopUtils.getTargetClass(bean);
        if (targetClass != bean.getClass()) {
            Class<?> ifc = JmxUtils.getMXBeanInterface(targetClass);
            if (ifc != null) {
                if (!ifc.isInstance(bean)) {
                    throw new NotCompliantMBeanException("Managed bean [" + bean + "] has a target class with an MXBean interface but does not expose it in the proxy");
                }
                return new StandardMBean(bean, ifc, true);
            }
            ifc = JmxUtils.getMBeanInterface(targetClass);
            if (ifc != null) {
                if (!ifc.isInstance(bean)) {
                    throw new NotCompliantMBeanException("Managed bean [" + bean + "] has a target class with an MBean interface but does not expose it in the proxy");
                }
                return new StandardMBean(bean, ifc);
            }
        }
        return null;
    }

    protected ModelMBean createAndConfigureMBean(Object managedResource, String beanKey) throws MBeanExportException {
        try {
            ModelMBean mbean = this.createModelMBean();
            mbean.setModelMBeanInfo(this.getMBeanInfo(managedResource, beanKey));
            mbean.setManagedResource(managedResource, MR_TYPE_OBJECT_REFERENCE);
            return mbean;
        }
        catch (Exception ex) {
            throw new MBeanExportException("Could not create ModelMBean for managed resource [" + managedResource + "] with key '" + beanKey + "'", ex);
        }
    }

    protected ModelMBean createModelMBean() throws MBeanException {
        return this.exposeManagedResourceClassLoader ? new SpringModelMBean() : new RequiredModelMBean();
    }

    private ModelMBeanInfo getMBeanInfo(Object managedBean, String beanKey) throws JMException {
        ModelMBeanInfo info = this.assembler.getMBeanInfo(managedBean, beanKey);
        if (this.logger.isWarnEnabled() && ObjectUtils.isEmpty(info.getAttributes()) && ObjectUtils.isEmpty(info.getOperations())) {
            this.logger.warn("Bean with key '" + beanKey + "' has been registered as an MBean but has no exposed attributes or operations");
        }
        return info;
    }

    private void autodetectBeans(final AutodetectCapableMBeanInfoAssembler assembler) {
        this.autodetect(new AutodetectCallback(){

            public boolean include(Class beanClass, String beanName) {
                return assembler.includeBean(beanClass, beanName);
            }
        });
    }

    private void autodetectMBeans() {
        this.autodetect(new AutodetectCallback(){

            public boolean include(Class beanClass, String beanName) {
                return MBeanExporter.this.isMBean(beanClass);
            }
        });
    }

    private void autodetect(AutodetectCallback callback) {
        LinkedHashSet beanNames = new LinkedHashSet(this.beanFactory.getBeanDefinitionCount());
        beanNames.addAll(Arrays.asList(this.beanFactory.getBeanDefinitionNames()));
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            beanNames.addAll(Arrays.asList(((ConfigurableBeanFactory)((Object)this.beanFactory)).getSingletonNames()));
        }
        for (String beanName : beanNames) {
            if (this.isExcluded(beanName) || this.isBeanDefinitionAbstract(this.beanFactory, beanName)) continue;
            try {
                Object beanInstance;
                Class<?> beanClass = this.beanFactory.getType(beanName);
                if (beanClass == null || !callback.include(beanClass, beanName)) continue;
                boolean lazyInit = this.isBeanDefinitionLazyInit(this.beanFactory, beanName);
                Object object = beanInstance = !lazyInit ? this.beanFactory.getBean(beanName) : null;
                if (!(this.beans.containsValue(beanName) || beanInstance != null && CollectionUtils.containsInstance(this.beans.values(), beanInstance))) {
                    this.beans.put(beanName, beanInstance != null ? beanInstance : beanName);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info("Bean with name '" + beanName + "' has been autodetected for JMX exposure");
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Bean with name '" + beanName + "' is already registered for JMX exposure");
            }
            catch (CannotLoadBeanClassException ex) {
                if (!this.allowEagerInit) continue;
                throw ex;
            }
        }
    }

    private boolean isExcluded(String beanName) {
        return this.excludedBeans != null && (this.excludedBeans.contains(beanName) || beanName.startsWith("&") && this.excludedBeans.contains(beanName.substring("&".length())));
    }

    private boolean isBeanDefinitionAbstract(ListableBeanFactory beanFactory, String beanName) {
        return beanFactory instanceof ConfigurableListableBeanFactory && beanFactory.containsBeanDefinition(beanName) && ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(beanName).isAbstract();
    }

    private void injectNotificationPublisherIfNecessary(Object managedResource, ModelMBean modelMBean, ObjectName objectName) {
        if (managedResource instanceof NotificationPublisherAware) {
            ((NotificationPublisherAware)managedResource).setNotificationPublisher(new ModelMBeanNotificationPublisher(modelMBean, objectName, managedResource));
        }
    }

    private void registerNotificationListeners() throws MBeanExportException {
        if (this.notificationListeners != null) {
            NotificationListenerBean[] notificationListenerBeanArray = this.notificationListeners;
            int n2 = this.notificationListeners.length;
            int n3 = 0;
            while (n3 < n2) {
                NotificationListenerBean bean = notificationListenerBeanArray[n3];
                try {
                    ObjectName[] mappedObjectNames = bean.getResolvedObjectNames();
                    if (mappedObjectNames == null) {
                        mappedObjectNames = this.getRegisteredObjectNames();
                    }
                    if (this.registeredNotificationListeners.put(bean, mappedObjectNames) == null) {
                        ObjectName[] objectNameArray = mappedObjectNames;
                        int n4 = mappedObjectNames.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            ObjectName mappedObjectName = objectNameArray[n5];
                            this.server.addNotificationListener(mappedObjectName, bean.getNotificationListener(), bean.getNotificationFilter(), bean.getHandback());
                            ++n5;
                        }
                    }
                }
                catch (Exception ex) {
                    throw new MBeanExportException("Unable to register NotificationListener", ex);
                }
                ++n3;
            }
        }
    }

    private void unregisterNotificationListeners() {
        for (Map.Entry<NotificationListenerBean, ObjectName[]> entry : this.registeredNotificationListeners.entrySet()) {
            ObjectName[] mappedObjectNames;
            NotificationListenerBean bean = entry.getKey();
            ObjectName[] objectNameArray = mappedObjectNames = entry.getValue();
            int n2 = mappedObjectNames.length;
            int n3 = 0;
            while (n3 < n2) {
                block4: {
                    ObjectName mappedObjectName = objectNameArray[n3];
                    try {
                        this.server.removeNotificationListener(mappedObjectName, bean.getNotificationListener(), bean.getNotificationFilter(), bean.getHandback());
                    }
                    catch (Exception ex) {
                        if (!this.logger.isDebugEnabled()) break block4;
                        this.logger.debug("Unable to unregister NotificationListener", ex);
                    }
                }
                ++n3;
            }
        }
        this.registeredNotificationListeners.clear();
    }

    @Override
    protected void onRegister(ObjectName objectName) {
        this.notifyListenersOfRegistration(objectName);
    }

    @Override
    protected void onUnregister(ObjectName objectName) {
        this.notifyListenersOfUnregistration(objectName);
    }

    private void notifyListenersOfRegistration(ObjectName objectName) {
        if (this.listeners != null) {
            MBeanExporterListener[] mBeanExporterListenerArray = this.listeners;
            int n2 = this.listeners.length;
            int n3 = 0;
            while (n3 < n2) {
                MBeanExporterListener listener = mBeanExporterListenerArray[n3];
                listener.mbeanRegistered(objectName);
                ++n3;
            }
        }
    }

    private void notifyListenersOfUnregistration(ObjectName objectName) {
        if (this.listeners != null) {
            MBeanExporterListener[] mBeanExporterListenerArray = this.listeners;
            int n2 = this.listeners.length;
            int n3 = 0;
            while (n3 < n2) {
                MBeanExporterListener listener = mBeanExporterListenerArray[n3];
                listener.mbeanUnregistered(objectName);
                ++n3;
            }
        }
    }

    private static interface AutodetectCallback {
        public boolean include(Class var1, String var2);
    }

    private class NotificationPublisherAwareLazyTargetSource
    extends LazyInitTargetSource {
        private ModelMBean modelMBean;
        private ObjectName objectName;

        private NotificationPublisherAwareLazyTargetSource() {
        }

        public void setModelMBean(ModelMBean modelMBean) {
            this.modelMBean = modelMBean;
        }

        public void setObjectName(ObjectName objectName) {
            this.objectName = objectName;
        }

        protected void postProcessTargetObject(Object targetObject) {
            MBeanExporter.this.injectNotificationPublisherIfNecessary(targetObject, this.modelMBean, this.objectName);
        }
    }
}

