/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.annotation;

import java.io.IOException;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;
import org.springframework.util.ClassUtils;

public class AnnotationSessionFactoryBean
extends LocalSessionFactoryBean
implements ResourceLoaderAware {
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private Class[] annotatedClasses;
    private String[] annotatedPackages;
    private String[] packagesToScan;
    private TypeFilter[] entityTypeFilters = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false), new AnnotationTypeFilter(org.hibernate.annotations.Entity.class, false)};
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public AnnotationSessionFactoryBean() {
        this.setConfigurationClass((Class)AnnotationConfiguration.class);
    }

    public void setConfigurationClass(Class configurationClass) {
        if (configurationClass == null || !AnnotationConfiguration.class.isAssignableFrom(configurationClass)) {
            throw new IllegalArgumentException("AnnotationSessionFactoryBean only supports AnnotationConfiguration or subclasses");
        }
        super.setConfigurationClass(configurationClass);
    }

    public void setAnnotatedClasses(Class[] annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public void setAnnotatedPackages(String[] annotatedPackages) {
        this.annotatedPackages = annotatedPackages;
    }

    public void setPackagesToScan(String[] packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public void setEntityTypeFilters(TypeFilter[] entityTypeFilters) {
        this.entityTypeFilters = entityTypeFilters;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver(resourceLoader);
    }

    protected void postProcessMappings(Configuration config) throws HibernateException {
        int n2;
        int n3;
        Object[] objectArray;
        AnnotationConfiguration annConfig = (AnnotationConfiguration)config;
        if (this.annotatedClasses != null) {
            objectArray = this.annotatedClasses;
            n3 = this.annotatedClasses.length;
            n2 = 0;
            while (n2 < n3) {
                Object annotatedClass = objectArray[n2];
                annConfig.addAnnotatedClass((Class)annotatedClass);
                ++n2;
            }
        }
        if (this.annotatedPackages != null) {
            objectArray = this.annotatedPackages;
            n3 = this.annotatedPackages.length;
            n2 = 0;
            while (n2 < n3) {
                Object annotatedPackage = objectArray[n2];
                annConfig.addPackage((String)annotatedPackage);
                ++n2;
            }
        }
        this.scanPackages(annConfig);
    }

    protected void scanPackages(AnnotationConfiguration config) {
        if (this.packagesToScan != null) {
            try {
                String[] stringArray = this.packagesToScan;
                int n2 = this.packagesToScan.length;
                int n3 = 0;
                while (n3 < n2) {
                    String pkg = stringArray[n3];
                    String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath(pkg) + RESOURCE_PATTERN;
                    Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                    CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory(this.resourcePatternResolver);
                    Resource[] resourceArray = resources;
                    int n4 = resources.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Resource resource = resourceArray[n5];
                        if (resource.isReadable()) {
                            MetadataReader reader = readerFactory.getMetadataReader(resource);
                            String className = reader.getClassMetadata().getClassName();
                            if (this.matchesFilter(reader, readerFactory)) {
                                config.addAnnotatedClass(this.resourcePatternResolver.getClassLoader().loadClass(className));
                            }
                        }
                        ++n5;
                    }
                    ++n3;
                }
            }
            catch (IOException ex) {
                throw new MappingException("Failed to scan classpath for unlisted classes", (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                throw new MappingException("Failed to load annotated classes from classpath", (Throwable)ex);
            }
        }
    }

    private boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (this.entityTypeFilters != null) {
            TypeFilter[] typeFilterArray = this.entityTypeFilters;
            int n2 = this.entityTypeFilters.length;
            int n3 = 0;
            while (n3 < n2) {
                TypeFilter filter = typeFilterArray[n3];
                if (filter.match(reader, readerFactory)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    protected void postProcessConfiguration(Configuration config) throws HibernateException {
        this.postProcessAnnotationConfiguration((AnnotationConfiguration)config);
    }

    protected void postProcessAnnotationConfiguration(AnnotationConfiguration config) throws HibernateException {
    }
}

