/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxws;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceProvider;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJaxWsServiceExporter
implements BeanFactoryAware,
InitializingBean,
DisposableBean {
    private Map<String, Object> endpointProperties;
    private Executor executor;
    private String bindingType;
    private Object[] webServiceFeatures;
    private ListableBeanFactory beanFactory;
    private final Set<Endpoint> publishedEndpoints = new LinkedHashSet<Endpoint>();

    public void setEndpointProperties(Map<String, Object> endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setBindingType(String bindingType) {
        this.bindingType = bindingType;
    }

    public void setWebServiceFeatures(Object[] webServiceFeatures) {
        this.webServiceFeatures = webServiceFeatures;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " requires a ListableBeanFactory");
        }
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.publishEndpoints();
    }

    public void publishEndpoints() {
        LinkedHashSet beanNames = new LinkedHashSet(this.beanFactory.getBeanDefinitionCount());
        beanNames.addAll(Arrays.asList(this.beanFactory.getBeanDefinitionNames()));
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            beanNames.addAll(Arrays.asList(((ConfigurableBeanFactory)((Object)this.beanFactory)).getSingletonNames()));
        }
        for (String beanName : beanNames) {
            try {
                Class<?> type = this.beanFactory.getType(beanName);
                if (type == null || type.isInterface()) continue;
                WebService wsAnnotation = type.getAnnotation(WebService.class);
                WebServiceProvider wsProviderAnnotation = type.getAnnotation(WebServiceProvider.class);
                if (wsAnnotation == null && wsProviderAnnotation == null) continue;
                Endpoint endpoint = this.createEndpoint(this.beanFactory.getBean(beanName));
                if (this.endpointProperties != null) {
                    endpoint.setProperties(this.endpointProperties);
                }
                if (this.executor != null) {
                    endpoint.setExecutor(this.executor);
                }
                if (wsAnnotation != null) {
                    this.publishEndpoint(endpoint, wsAnnotation);
                } else {
                    this.publishEndpoint(endpoint, wsProviderAnnotation);
                }
                this.publishedEndpoints.add(endpoint);
            }
            catch (CannotLoadBeanClassException cannotLoadBeanClassException) {}
        }
    }

    protected Endpoint createEndpoint(Object bean) {
        if (this.webServiceFeatures != null) {
            return new FeatureEndpointProvider().createEndpoint(this.bindingType, bean, this.webServiceFeatures);
        }
        return Endpoint.create((String)this.bindingType, (Object)bean);
    }

    protected abstract void publishEndpoint(Endpoint var1, WebService var2);

    protected abstract void publishEndpoint(Endpoint var1, WebServiceProvider var2);

    @Override
    public void destroy() {
        for (Endpoint endpoint : this.publishedEndpoints) {
            endpoint.stop();
        }
    }

    private class FeatureEndpointProvider {
        private FeatureEndpointProvider() {
        }

        public Endpoint createEndpoint(String bindingType, Object implementor, Object[] features) {
            WebServiceFeature[] wsFeatures = new WebServiceFeature[features.length];
            int i2 = 0;
            while (i2 < features.length) {
                wsFeatures[i2] = this.convertWebServiceFeature(features[i2]);
                ++i2;
            }
            try {
                Method create = Endpoint.class.getMethod("create", String.class, Object.class, WebServiceFeature[].class);
                return (Endpoint)ReflectionUtils.invokeMethod(create, null, bindingType, implementor, wsFeatures);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("JAX-WS 2.2 not available - cannot create feature endpoints", ex);
            }
        }

        private WebServiceFeature convertWebServiceFeature(Object feature) {
            Assert.notNull(feature, "WebServiceFeature specification object must not be null");
            if (feature instanceof WebServiceFeature) {
                return (WebServiceFeature)feature;
            }
            if (feature instanceof Class) {
                return (WebServiceFeature)BeanUtils.instantiate((Class)feature);
            }
            if (feature instanceof String) {
                try {
                    Class<?> featureClass = this.getBeanClassLoader().loadClass((String)feature);
                    return (WebServiceFeature)BeanUtils.instantiate(featureClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException("Could not load WebServiceFeature class [" + feature + "]");
                }
            }
            throw new IllegalArgumentException("Unknown WebServiceFeature specification type: " + feature.getClass());
        }

        private ClassLoader getBeanClassLoader() {
            return AbstractJaxWsServiceExporter.this.beanFactory instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)((Object)AbstractJaxWsServiceExporter.this.beanFactory)).getBeanClassLoader() : ClassUtils.getDefaultClassLoader();
        }
    }
}

