/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScheduledTasksBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ELEMENT_SCHEDULED = "scheduled";

    protected boolean shouldGenerateId() {
        return true;
    }

    protected String getBeanClassName(Element element) {
        return "org.springframework.scheduling.config.ScheduledTaskRegistrar";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ManagedMap<RuntimeBeanReference, String> cronTaskMap = new ManagedMap<RuntimeBeanReference, String>();
        ManagedMap<RuntimeBeanReference, String> fixedDelayTaskMap = new ManagedMap<RuntimeBeanReference, String>();
        ManagedMap<RuntimeBeanReference, String> fixedRateTaskMap = new ManagedMap<RuntimeBeanReference, String>();
        NodeList childNodes = element.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            Node child = childNodes.item(i2);
            if (this.isScheduledElement(child, parserContext)) {
                Element taskElement = (Element)child;
                String ref = taskElement.getAttribute("ref");
                String method = taskElement.getAttribute("method");
                if (!StringUtils.hasText(ref) || !StringUtils.hasText(method)) {
                    parserContext.getReaderContext().error("Both 'ref' and 'method' are required", taskElement);
                } else {
                    RuntimeBeanReference runnableBeanRef = new RuntimeBeanReference(this.createRunnableBean(ref, method, taskElement, parserContext));
                    String cronAttribute = taskElement.getAttribute("cron");
                    if (StringUtils.hasText(cronAttribute)) {
                        cronTaskMap.put(runnableBeanRef, cronAttribute);
                    } else {
                        String fixedDelayAttribute = taskElement.getAttribute("fixed-delay");
                        if (StringUtils.hasText(fixedDelayAttribute)) {
                            fixedDelayTaskMap.put(runnableBeanRef, fixedDelayAttribute);
                        } else {
                            String fixedRateAttribute = taskElement.getAttribute("fixed-rate");
                            if (!StringUtils.hasText(fixedRateAttribute)) {
                                parserContext.getReaderContext().error("One of 'cron', 'fixed-delay', or 'fixed-rate' is required", taskElement);
                            } else {
                                fixedRateTaskMap.put(runnableBeanRef, fixedRateAttribute);
                            }
                        }
                    }
                }
            }
            ++i2;
        }
        String schedulerRef = element.getAttribute("scheduler");
        if (StringUtils.hasText(schedulerRef)) {
            builder.addPropertyReference("taskScheduler", schedulerRef);
        }
        builder.addPropertyValue("cronTasks", cronTaskMap);
        builder.addPropertyValue("fixedDelayTasks", fixedDelayTaskMap);
        builder.addPropertyValue("fixedRateTasks", fixedRateTaskMap);
    }

    private boolean isScheduledElement(Node node, ParserContext parserContext) {
        return node.getNodeType() == 1 && ELEMENT_SCHEDULED.equals(parserContext.getDelegate().getLocalName(node));
    }

    private String createRunnableBean(String ref, String method, Element taskElement, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition("org.springframework.scheduling.support.MethodInvokingRunnable");
        builder.addPropertyReference("targetObject", ref);
        builder.addPropertyValue("targetMethod", method);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource(taskElement));
        String generatedName = parserContext.getReaderContext().generateBeanName(builder.getRawBeanDefinition());
        parserContext.registerBeanComponent(new BeanComponentDefinition(builder.getBeanDefinition(), generatedName));
        return generatedName;
    }
}

