/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.SchedulerRepository;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.scheduling.quartz.SchedulerAccessor;

public class SchedulerAccessorBean
extends SchedulerAccessor
implements BeanFactoryAware,
InitializingBean {
    private String schedulerName;
    private Scheduler scheduler;
    private BeanFactory beanFactory;

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws SchedulerException {
        if (this.scheduler == null) {
            if (this.schedulerName != null) {
                this.scheduler = this.findScheduler(this.schedulerName);
            } else {
                throw new IllegalStateException("No Scheduler specified");
            }
        }
        this.registerListeners();
        this.registerJobsAndTriggers();
    }

    protected Scheduler findScheduler(String schedulerName) throws SchedulerException {
        Scheduler schedulerInRepo;
        if (this.beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf = (ListableBeanFactory)this.beanFactory;
            String[] beanNames = lbf.getBeanNamesForType(Scheduler.class);
            int i2 = 0;
            while (i2 < beanNames.length) {
                Scheduler schedulerBean = (Scheduler)lbf.getBean(beanNames[i2]);
                if (schedulerName.equals(schedulerBean.getSchedulerName())) {
                    return schedulerBean;
                }
                ++i2;
            }
        }
        if ((schedulerInRepo = SchedulerRepository.getInstance().lookup(schedulerName)) == null) {
            throw new IllegalStateException("No Scheduler named '" + schedulerName + "' found");
        }
        return schedulerInRepo;
    }
}

