/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.test.AbstractSingleSpringContextTests;
import org.springframework.test.AbstractSpringContextTests;
import org.springframework.util.Assert;

@Deprecated
public abstract class AbstractDependencyInjectionSpringContextTests
extends AbstractSingleSpringContextTests {
    public static final int AUTOWIRE_NO = 0;
    public static final int AUTOWIRE_BY_NAME = 1;
    public static final int AUTOWIRE_BY_TYPE = 2;
    private boolean populateProtectedVariables = false;
    private int autowireMode = 2;
    private boolean dependencyCheck = true;
    private String[] managedVariableNames;

    public AbstractDependencyInjectionSpringContextTests() {
    }

    public AbstractDependencyInjectionSpringContextTests(String name) {
        super(name);
    }

    public final void setPopulateProtectedVariables(boolean populateFields) {
        this.populateProtectedVariables = populateFields;
    }

    public final boolean isPopulateProtectedVariables() {
        return this.populateProtectedVariables;
    }

    public final void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public final int getAutowireMode() {
        return this.autowireMode;
    }

    public final void setDependencyCheck(boolean dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public final boolean isDependencyCheck() {
        return this.dependencyCheck;
    }

    protected void prepareTestInstance() throws Exception {
        if (this.getApplicationContext() == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ApplicationContext has not been configured for test [" + this.getClass().getName() + "]: dependency injection will NOT be performed.");
            }
        } else {
            this.injectDependencies();
        }
    }

    protected void injectDependencies() throws Exception {
        Assert.state(this.getApplicationContext() != null, "injectDependencies() called without first configuring an ApplicationContext");
        if (this.isPopulateProtectedVariables()) {
            if (this.managedVariableNames == null) {
                this.initManagedVariableNames();
            }
            this.populateProtectedVariables();
        }
        this.getApplicationContext().getBeanFactory().autowireBeanProperties(this, this.getAutowireMode(), this.isDependencyCheck());
    }

    private void initManagedVariableNames() throws IllegalAccessException {
        LinkedList<String> managedVarNames = new LinkedList<String>();
        Class<?> clazz = this.getClass();
        do {
            Field[] fields = clazz.getDeclaredFields();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found " + fields.length + " fields on " + clazz);
            }
            int i2 = 0;
            while (i2 < fields.length) {
                Field field = fields[i2];
                field.setAccessible(true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Candidate field: " + field);
                }
                if (this.isProtectedInstanceField(field)) {
                    Object oldValue = field.get(this);
                    if (oldValue == null) {
                        managedVarNames.add(field.getName());
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Added managed variable '" + field.getName() + "'");
                        }
                    } else if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Rejected managed variable '" + field.getName() + "'");
                    }
                }
                ++i2;
            }
        } while (!(clazz = clazz.getSuperclass()).equals(AbstractDependencyInjectionSpringContextTests.class));
        this.managedVariableNames = managedVarNames.toArray(new String[managedVarNames.size()]);
    }

    private boolean isProtectedInstanceField(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && Modifier.isProtected(modifiers);
    }

    private void populateProtectedVariables() throws IllegalAccessException {
        int i2 = 0;
        while (i2 < this.managedVariableNames.length) {
            block6: {
                String varName = this.managedVariableNames[i2];
                Object bean = null;
                try {
                    Field field = this.findField(this.getClass(), varName);
                    bean = this.getApplicationContext().getBean(varName, field.getType());
                    field.setAccessible(true);
                    field.set(this, bean);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Populated field: " + field);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn("No field with name '" + varName + "'");
                    }
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    if (!this.logger.isWarnEnabled()) break block6;
                    this.logger.warn("No bean with name '" + varName + "'");
                }
            }
            ++i2;
        }
    }

    private Field findField(Class clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            Class superclass = clazz.getSuperclass();
            if (superclass != AbstractSpringContextTests.class) {
                return this.findField(superclass, name);
            }
            throw ex;
        }
    }
}

